/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.limewire.io.NetworkUtils;

public final class ForceIPPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Router Configuration");
    public static final String LABEL = I18n.tr("LimeWire can configure itself to work from behind a firewall or router. Using Universal Plug 'n Play (UPnP), LimeWire can automatically configure your router or firewall for optimal performance. If your router does not support UPnP, LimeWire can be set to advertise an external port manually. (You must also configure your router if you choose manual configuration.)");
    private final WholeNumberField PORT_FIELD = new SizedWholeNumberField();
    private final ButtonGroup BUTTONS = new ButtonGroup();
    private final JRadioButton UPNP = new JRadioButton(I18n.tr("Use UPnP (Recommended)"));
    private final JRadioButton PORT = new JRadioButton(I18n.tr("Manual Port Forward:"));
    private final JRadioButton NONE = new JRadioButton(I18n.tr("Do Nothing (Not Recommended)"));
    private final NetworkManager networkManager = GuiCoreMediator.getNetworkManager();

    public ForceIPPaneItem() {
        super(TITLE, LABEL);
        this.BUTTONS.add(this.UPNP);
        this.BUTTONS.add(this.PORT);
        this.BUTTONS.add(this.NONE);
        this.PORT.addItemListener(new LocalPortListener());
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 6);
        panel.add((Component)this.UPNP, c);
        c.gridwidth = -1;
        panel.add((Component)this.PORT, c);
        c.gridwidth = 0;
        panel.add((Component)this.PORT_FIELD, c);
        panel.add((Component)this.NONE, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        panel.add(Box.createGlue(), c);
        GUIUtils.restrictSize(panel, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.add(panel);
    }

    private void updateState() {
        this.PORT_FIELD.setEnabled(this.PORT.isSelected());
        this.PORT_FIELD.setEditable(this.PORT.isSelected());
    }

    public void initOptions() {
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue()) {
            this.PORT.setSelected(true);
        } else if (ConnectionSettings.DISABLE_UPNP.getValue()) {
            this.NONE.setSelected(true);
        } else {
            this.UPNP.setSelected(true);
        }
        this.PORT_FIELD.setValue(ConnectionSettings.FORCED_PORT.getValue());
        this.updateState();
    }

    public boolean applyOptions() throws IOException {
        boolean restart = false;
        boolean oldUPNP = ConnectionSettings.UPNP_IN_USE.getValue();
        int oldPort = ConnectionSettings.FORCED_PORT.getValue();
        boolean oldForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
        if (this.UPNP.isSelected()) {
            if (!ConnectionSettings.UPNP_IN_USE.getValue()) {
                ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
            }
            ConnectionSettings.DISABLE_UPNP.setValue(false);
            if (!oldUPNP) {
                restart = true;
            }
        } else if (this.NONE.isSelected()) {
            ConnectionSettings.FORCE_IP_ADDRESS.setValue(false);
            ConnectionSettings.DISABLE_UPNP.setValue(true);
        } else {
            int forcedPort = this.PORT_FIELD.getValue();
            if (!NetworkUtils.isValidPort(forcedPort)) {
                GUIMediator.showError(I18n.tr("You must enter a port between 1 and 65535 when manually forcing your port."));
                throw new IOException("bad port: " + forcedPort);
            }
            ConnectionSettings.DISABLE_UPNP.setValue(false);
            ConnectionSettings.FORCE_IP_ADDRESS.setValue(true);
            ConnectionSettings.UPNP_IN_USE.setValue(false);
            ConnectionSettings.FORCED_PORT.setValue(forcedPort);
        }
        boolean newForce = ConnectionSettings.FORCE_IP_ADDRESS.getValue();
        int newPort = ConnectionSettings.FORCED_PORT.getValue();
        if (oldForce != newForce || newForce && oldPort != newPort) {
            this.networkManager.addressChanged();
        }
        return restart;
    }

    public boolean isDirty() {
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue() && !ConnectionSettings.UPNP_IN_USE.getValue() ? !this.PORT.isSelected() : (ConnectionSettings.DISABLE_UPNP.getValue() ? !this.NONE.isSelected() : !this.UPNP.isSelected())) {
            return true;
        }
        return this.PORT.isSelected() && this.PORT_FIELD.getValue() != ConnectionSettings.FORCED_PORT.getValue();
    }

    private class LocalPortListener
    implements ItemListener {
        private LocalPortListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ForceIPPaneItem.this.updateState();
        }
    }
}

