/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.limewire.io.IP;

public final class IgnoreMessagesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Filter Hosts");
    public static final String LABEL = I18n.tr("You can disallow messages from specific hosts by adding their IP addresses (e.g. \"192.168.0.1\", \"192.*.*.*\", \"192.168.12.16/255.255.255.240\" or \"192.168.12.16/28\") to the banned list.");
    private final ListEditor MESSAGES_LIST = new ListEditor();
    private final JCheckBox networkBlackList = new JCheckBox();

    public IgnoreMessagesPaneItem() {
        super(TITLE, LABEL);
        this.add(this.MESSAGES_LIST);
        this.MESSAGES_LIST.addListDataListener(new IPEnforcer());
        this.add(this.getVerticalSeparator());
        this.addLabel(I18n.tr("LimeWire can also manage a blacklist for you.  This will keep LimeWire protected from harmful clients and other nuisances."));
        LabeledComponent labeledComponent = new LabeledComponent(I18n.tr("Use LimeWire's built-in blacklist"), this.networkBlackList, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        String[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(bannedIps)));
        this.networkBlackList.setSelected(FilterSettings.USE_NETWORK_FILTER.getValue());
    }

    public boolean applyOptions() throws IOException {
        Vector<String> model = this.MESSAGES_LIST.getModel();
        Object[] bannedIps = new String[model.size()];
        model.copyInto(bannedIps);
        FilterSettings.USE_NETWORK_FILTER.setValue(this.networkBlackList.isSelected());
        FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue((String[])bannedIps);
        GuiCoreMediator.getSpamServices().reloadIPFilter();
        return false;
    }

    public boolean isDirty() {
        List<String> model = Arrays.asList(FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue());
        return this.networkBlackList.isSelected() != FilterSettings.USE_NETWORK_FILTER.getValue() || !((Object)model).equals(this.MESSAGES_LIST.getModel());
    }

    private class IPEnforcer
    implements ListDataListener {
        private IPEnforcer() {
        }

        public void intervalAdded(ListDataEvent lde) {
            Vector model = (Vector)lde.getSource();
            String ipString = (String)model.get(lde.getIndex0());
            try {
                new IP(ipString);
            }
            catch (IllegalArgumentException e) {
                IgnoreMessagesPaneItem.this.MESSAGES_LIST.removeItem(lde.getIndex0());
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void intervalRemoved(ListDataEvent lde) {
        }

        public void contentsChanged(ListDataEvent lde) {
            Vector model = (Vector)lde.getSource();
            String ipString = (String)model.get(lde.getIndex0());
            try {
                new IP(ipString);
            }
            catch (IllegalArgumentException e) {
                String[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
                IgnoreMessagesPaneItem.this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(bannedIps)));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

