/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.settings.FilterSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class IgnoreResultTypesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Filter Result Types");
    public static final String LABEL = I18n.tr("You can specify general types of search results to filter.");
    private JCheckBox IGNORE_ADULT_CHECK_BOX = new JCheckBox();
    private JCheckBox IGNORE_HTML_CHECK_BOX = new JCheckBox();
    private JCheckBox IGNORE_VBS_CHECK_BOX = new JCheckBox();
    private JCheckBox IGNORE_WMV_ASF_CHECK_BOX = new JCheckBox();
    private String ADULT_BOX_LABEL = I18nMarker.marktr("Ignore Adult Content");
    private String HTML_BOX_LABEL = I18nMarker.marktr("Ignore .htm/.html Files");
    private String VBS_BOX_LABEL = I18nMarker.marktr("Ignore .vbs Files");
    private String WMV_ASF_BOX_LABEL = I18nMarker.marktr("Ignore .wmv/.asf files");

    public IgnoreResultTypesPaneItem() {
        super(TITLE, LABEL);
        this.IGNORE_ADULT_CHECK_BOX.setText(I18n.tr(this.ADULT_BOX_LABEL));
        this.IGNORE_HTML_CHECK_BOX.setText(I18n.tr(this.HTML_BOX_LABEL));
        this.IGNORE_VBS_CHECK_BOX.setText(I18n.tr(this.VBS_BOX_LABEL));
        this.IGNORE_WMV_ASF_CHECK_BOX.setText(I18n.tr(this.WMV_ASF_BOX_LABEL));
        this.add(this.IGNORE_ADULT_CHECK_BOX);
        this.add(this.IGNORE_HTML_CHECK_BOX);
        this.add(this.IGNORE_VBS_CHECK_BOX);
        this.add(this.IGNORE_WMV_ASF_CHECK_BOX);
    }

    public void initOptions() {
        this.IGNORE_ADULT_CHECK_BOX.setSelected(FilterSettings.FILTER_ADULT.getValue());
        this.IGNORE_HTML_CHECK_BOX.setSelected(FilterSettings.FILTER_HTML.getValue());
        this.IGNORE_VBS_CHECK_BOX.setSelected(FilterSettings.FILTER_VBS.getValue());
        this.IGNORE_WMV_ASF_CHECK_BOX.setSelected(FilterSettings.FILTER_WMV_ASF.getValue());
    }

    public boolean applyOptions() throws IOException {
        boolean adultChanged = false;
        adultChanged = FilterSettings.FILTER_ADULT.getValue() != this.IGNORE_ADULT_CHECK_BOX.isSelected();
        FilterSettings.FILTER_ADULT.setValue(this.IGNORE_ADULT_CHECK_BOX.isSelected());
        FilterSettings.FILTER_VBS.setValue(this.IGNORE_VBS_CHECK_BOX.isSelected());
        FilterSettings.FILTER_HTML.setValue(this.IGNORE_HTML_CHECK_BOX.isSelected());
        FilterSettings.FILTER_WMV_ASF.setValue(this.IGNORE_WMV_ASF_CHECK_BOX.isSelected());
        GuiCoreMediator.getSpamServices().adjustSpamFilters();
        if (adultChanged) {
            SearchMediator.rebuildInputPanel();
        }
        return false;
    }

    public boolean isDirty() {
        return FilterSettings.FILTER_ADULT.getValue() != this.IGNORE_ADULT_CHECK_BOX.isSelected() || FilterSettings.FILTER_VBS.getValue() != this.IGNORE_VBS_CHECK_BOX.isSelected() || FilterSettings.FILTER_HTML.getValue() != this.IGNORE_HTML_CHECK_BOX.isSelected() || FilterSettings.FILTER_WMV_ASF.getValue() != this.IGNORE_WMV_ASF_CHECK_BOX.isSelected();
    }
}

