/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class NetworkInterfacePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Network Interface");
    public static final String LABEL = I18n.tr("You can tell LimeWire to bind outgoing connections to an IP address from a specific network interface. Listening sockets will still listen on all available interfaces. This is useful on multi-homed hosts. If you later disable this interface, LimeWire will revert to binding to an arbitrary address.");
    private static final String ADDRESS = "limewire.networkinterfacepane.address";
    private final ButtonGroup GROUP = new ButtonGroup();
    private final JCheckBox CUSTOM;
    private List<JRadioButton> activeButtons = new ArrayList<JRadioButton>();

    public NetworkInterfacePaneItem() {
        super(TITLE, LABEL);
        this.CUSTOM = new JCheckBox(I18n.tr("Use a specific network interface."));
        this.CUSTOM.setSelected(ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue());
        this.CUSTOM.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                NetworkInterfacePaneItem.this.updateButtons(NetworkInterfacePaneItem.this.CUSTOM.isSelected());
            }
        });
        this.add(this.CUSTOM);
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.gridwidth = 0;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                JLabel label = new JLabel(ni.getDisplayName());
                gbc.insets = new Insets(5, 0, 2, 0);
                panel.add((Component)label, gbc);
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                gbc.insets = new Insets(0, 6, 0, 0);
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    JRadioButton button = new JRadioButton(address.getHostAddress());
                    this.GROUP.add(button);
                    if (address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isLoopbackAddress()) {
                        button.setEnabled(false);
                    } else {
                        this.activeButtons.add(button);
                    }
                    if (ConnectionSettings.CUSTOM_INETADRESS.getValue().equals(address.getHostAddress())) {
                        button.setSelected(true);
                    }
                    button.putClientProperty(ADDRESS, address);
                    panel.add((Component)button, gbc);
                }
            }
            this.initializeSelection();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.gridheight = 0;
            panel.add(Box.createGlue(), gbc);
            JScrollPane pane = new JScrollPane(panel);
            pane.setBorder(BorderFactory.createEmptyBorder());
            this.add(pane);
            this.updateButtons(this.CUSTOM.isSelected());
        }
        catch (SocketException se) {
            this.CUSTOM.setSelected(false);
            BoxPanel labelPanel = new BoxPanel(0);
            labelPanel.add(new JLabel(I18n.tr("LimeWire was unable to determine which network interfaces are available on this machine. Outgoing connections will bind to any arbitrary interface.")));
            labelPanel.add(Box.createHorizontalGlue());
            BoxPanel outerPanel = new BoxPanel();
            outerPanel.add(labelPanel);
            outerPanel.add(Box.createVerticalGlue());
            this.add(outerPanel);
        }
    }

    protected void updateButtons(boolean enable) {
        for (JRadioButton button : this.activeButtons) {
            button.setEnabled(enable);
        }
    }

    private void initializeSelection() {
        AbstractButton bt;
        Enumeration<AbstractButton> buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            bt = buttons.nextElement();
            if (!bt.isSelected()) continue;
            return;
        }
        buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            bt = buttons.nextElement();
            if (!bt.isEnabled()) continue;
            bt.setSelected(true);
            return;
        }
    }

    public boolean applyOptions() throws IOException {
        ConnectionSettings.CUSTOM_NETWORK_INTERFACE.setValue(this.CUSTOM.isSelected());
        Enumeration<AbstractButton> buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton bt = buttons.nextElement();
            if (!bt.isSelected()) continue;
            InetAddress addr = (InetAddress)bt.getClientProperty(ADDRESS);
            ConnectionSettings.CUSTOM_INETADRESS.setValue(addr.getHostAddress());
        }
        return false;
    }

    public boolean isDirty() {
        if (!ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue()) {
            return this.CUSTOM.isSelected();
        }
        String expect = ConnectionSettings.CUSTOM_INETADRESS.getValue();
        Enumeration<AbstractButton> buttons = this.GROUP.getElements();
        while (buttons.hasMoreElements()) {
            InetAddress addr;
            AbstractButton bt = buttons.nextElement();
            if (!bt.isSelected() || !(addr = (InetAddress)bt.getClientProperty(ADDRESS)).getHostAddress().equals(expect)) continue;
            return false;
        }
        return true;
    }

    public void initOptions() {
    }
}

