/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public class PromotionalSearchPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("LimeLinks");
    public static final String LABEL = I18n.tr("You can disable LimeLinks from appearing in search results.");
    private final String OPTION_LABEL = I18nMarker.marktr("Disable LimeLinks:");
    private final JCheckBox disableResultsCheckBox = new JCheckBox();

    public PromotionalSearchPaneItem() {
        super(TITLE, LABEL, "http://www.limewire.com/learnMore/limelinks.php");
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this.disableResultsCheckBox, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.disableResultsCheckBox.setSelected(SearchSettings.DISABLE_PROMOTIONAL_RESULTS.getValue());
    }

    public boolean applyOptions() throws IOException {
        SearchSettings.DISABLE_PROMOTIONAL_RESULTS.setValue(this.disableResultsCheckBox.isSelected());
        return false;
    }

    public boolean isDirty() {
        return SearchSettings.DISABLE_PROMOTIONAL_RESULTS.getValue() != this.disableResultsCheckBox.isSelected();
    }
}

