/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

public class ShutdownPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shutdown Behavior");
    public static final String LABEL = I18n.tr("You can choose the default shutdown behavior.");
    private JRadioButton shutdownImmediately;
    private JRadioButton shutdownAfterTransfers;
    private JRadioButton minimizeToTray;

    public ShutdownPaneItem() {
        super(TITLE, LABEL);
        BoxPanel buttonPanel = new BoxPanel();
        String immediateLabel = I18nMarker.marktr("Shutdown Immediately");
        String whenReadyLabel = I18nMarker.marktr("Shutdown after Transfers");
        String minimizeLabel = I18nMarker.marktr("Minimize to System Tray");
        this.shutdownImmediately = new JRadioButton(I18n.tr(immediateLabel));
        this.shutdownAfterTransfers = new JRadioButton(I18n.tr(whenReadyLabel));
        this.minimizeToTray = new JRadioButton(I18n.tr(minimizeLabel));
        ButtonGroup bg = new ButtonGroup();
        buttonPanel.add(this.shutdownImmediately);
        buttonPanel.add(this.shutdownAfterTransfers);
        bg.add(this.shutdownImmediately);
        bg.add(this.shutdownAfterTransfers);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            buttonPanel.add(this.minimizeToTray);
            bg.add(this.minimizeToTray);
        }
        BoxPanel mainPanel = new BoxPanel(0);
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createHorizontalGlue());
        this.add(mainPanel);
    }

    public boolean applyOptions() throws IOException {
        if (this.minimizeToTray.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(false);
        } else if (this.shutdownAfterTransfers.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(true);
        } else {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(false);
        }
        return false;
    }

    public void initOptions() {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            if (OSUtils.supportsTray() && !ResourceManager.instance().isTrayIconAvailable()) {
                this.shutdownAfterTransfers.setSelected(true);
            } else {
                this.minimizeToTray.setSelected(true);
            }
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue()) {
            this.shutdownAfterTransfers.setSelected(true);
        } else {
            this.shutdownImmediately.setSelected(true);
        }
    }

    public boolean isDirty() {
        boolean minimized = ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && !ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        boolean reallyMinimized = minimized && ResourceManager.instance().isTrayIconAvailable();
        boolean afterTransfers = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        boolean reallyAfterTransfers = afterTransfers || minimized && !ResourceManager.instance().isTrayLibraryLoaded();
        boolean immediate = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && !ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        return this.minimizeToTray.isSelected() != reallyMinimized || this.shutdownAfterTransfers.isSelected() != reallyAfterTransfers || this.shutdownImmediately.isSelected() != immediate;
    }
}

