/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComboBox;
import org.limewire.i18n.I18nMarker;

public final class SpeedPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Connection Speed");
    public static final String LABEL = I18n.tr("You can specify your connection speed so that LimeWire can optimize performance.");
    private final String[] SPEED_MENU_ITEMS = new String[]{GUIConstants.MODEM_SPEED, GUIConstants.CABLE_SPEED};
    private final String OPTION_LABEL = I18nMarker.marktr("Speed:");
    private final JComboBox SPEED_BOX = new JComboBox<String>(this.SPEED_MENU_ITEMS);
    private String _speed;

    public SpeedPaneItem() {
        super(TITLE, LABEL);
        this.SPEED_BOX.setMaximumSize(new Dimension(10, 25));
        LabeledComponent comp = new LabeledComponent(this.OPTION_LABEL, this.SPEED_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._speed = this.getSpeedString(ConnectionSettings.CONNECTION_SPEED.getValue());
        this.SPEED_BOX.setSelectedItem(this._speed);
    }

    public boolean applyOptions() throws IOException {
        String speed = (String)this.SPEED_BOX.getSelectedItem();
        if (speed != null && !speed.equals(this._speed)) {
            int speedInt = this.getSpeedInt(speed);
            if (speedInt < 0 || 20000 < speedInt) {
                throw new IllegalArgumentException();
            }
            ConnectionSettings.CONNECTION_SPEED.setValue(speedInt);
            this._speed = speed;
        }
        return false;
    }

    public boolean isDirty() {
        String speed = (String)this.SPEED_BOX.getSelectedItem();
        return speed != null && ConnectionSettings.CONNECTION_SPEED.getValue() != this.getSpeedInt(speed);
    }

    private String getSpeedString(int i) {
        String speed = i == 56 ? GUIConstants.MODEM_SPEED : (i == 350 ? GUIConstants.CABLE_SPEED : GUIConstants.CABLE_SPEED);
        return speed;
    }

    private int getSpeedInt(String s) {
        int i = s.equals(GUIConstants.MODEM_SPEED) ? 56 : (s.equals(GUIConstants.CABLE_SPEED) ? 350 : 350);
        return i;
    }
}

