/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.layout.SpringUtilities;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class StoreFileNamePaneItem
extends AbstractPaneItem {
    private static final String TITLE = I18n.tr("LimeWire Store - File Name");
    private static final String LABEL = I18n.tr("You can choose how to name the files purchased from the LimeWire Store and where to save them.");
    private final String artist = I18n.tr("Artist");
    private final String album = I18n.tr("Album");
    private final String track = I18n.tr("Track");
    private final String title = I18n.tr("Title");
    private final String artistVar = "<artist>";
    private final String albumVar = "<album>";
    private final String trackVar = "<track>";
    private final String titleVar = "<title>";
    private final String FILE_LABEL = I18n.tr("File Name") + ":";
    private final String DIRECTORY_LABEL = I18n.tr("SubFolder") + ":";
    private JPanel templatePanel;
    private JTextField currentTemplateTextField;
    private JComboBox fileTemplates;
    private JComboBox subDirectoryTemplates;
    private String oldFileName;
    private String oldSubDirectory;

    public StoreFileNamePaneItem() {
        super(TITLE, LABEL);
        this.init();
    }

    public void initOptions() {
        this.oldFileName = SharingSettings.getFileNameLWSTemplate();
        this.oldSubDirectory = SharingSettings.getSubDirectoryLWSTemplate();
        StoreFileNamePaneItem.setJComboBox(this.fileTemplates, this.getFileNameTemplatesArray(), SharingSettings.getFileNameLWSTemplate());
        StoreFileNamePaneItem.setJComboBox(this.subDirectoryTemplates, this.getSubDirectoryTemplatesArray(), SharingSettings.getSubDirectoryLWSTemplate());
        this.setPreviewTextField();
    }

    private void init() {
        this.add(this.getTemplateTextField());
        this.add(this.getTemplatePanel());
        this.add(this.getVerticalSeparator());
        this.setPreviewTextField();
    }

    private JTextField getTemplateTextField() {
        if (this.currentTemplateTextField == null) {
            this.currentTemplateTextField = new SizedTextField(25, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.currentTemplateTextField.setEditable(false);
        }
        return this.currentTemplateTextField;
    }

    private JPanel getTemplatePanel() {
        if (this.templatePanel == null) {
            this.templatePanel = new JPanel(new SpringLayout());
            this.templatePanel.add(new JLabel(this.DIRECTORY_LABEL));
            this.templatePanel.add(this.getPresetDirectoryTemplates());
            this.templatePanel.add(new JLabel(this.FILE_LABEL));
            this.templatePanel.add(this.getPresetFileNameTemplates());
            SpringUtilities.makeCompactGrid(this.templatePanel, 2, 2, 6, 6, 6, 6);
        }
        return this.templatePanel;
    }

    private JComboBox getPresetFileNameTemplates() {
        if (this.fileTemplates == null) {
            this.fileTemplates = new JComboBox<ListNode>(this.getFileNameTemplatesArray());
            this.fileTemplates.setMaximumSize(new Dimension(200, 25));
            this.fileTemplates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StoreFileNamePaneItem.this.setPreviewTextField();
                }
            });
        }
        return this.fileTemplates;
    }

    private JComboBox getPresetDirectoryTemplates() {
        if (this.subDirectoryTemplates == null) {
            this.subDirectoryTemplates = new JComboBox<ListNode>(this.getSubDirectoryTemplatesArray());
            this.subDirectoryTemplates.setMaximumSize(new Dimension(200, 25));
            this.subDirectoryTemplates.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    StoreFileNamePaneItem.this.setPreviewTextField();
                }
            });
        }
        return this.subDirectoryTemplates;
    }

    private void setPreviewTextField() {
        String directory = ((ListNode)this.subDirectoryTemplates.getSelectedItem()).getTemplateText();
        this.currentTemplateTextField.setText((directory.length() > 0 ? ((ListNode)this.subDirectoryTemplates.getSelectedItem()).getDisplayText() : "") + ((ListNode)this.fileTemplates.getSelectedItem()).getDisplayText() + ".mp3");
    }

    private ListNode[] getFileNameTemplatesArray() {
        ListNode[] templateOptionStrings = new ListNode[]{new ListNode(this.artist + " - " + this.album + " - " + this.track + " - " + this.title, "<artist> - <album> - <track> - <title>"), new ListNode(this.artist + " - " + this.title, "<artist> - <title>"), new ListNode(this.track + " - " + this.artist + " - " + this.title, "<track> - <artist> - <title>"), new ListNode(this.artist + " - " + this.title + " - " + this.track, "<artist> - <title> - <track>")};
        return templateOptionStrings;
    }

    private ListNode[] getSubDirectoryTemplatesArray() {
        ListNode[] templateOptionStrings = new ListNode[]{new ListNode(this.artist + File.separatorChar + this.album + File.separatorChar, "<artist>" + File.separatorChar + "<album>"), new ListNode(this.album + File.separatorChar, "<album>"), new ListNode(this.artist + File.separatorChar, "<artist>"), new ListNode(I18n.tr("No Subfolder"), "")};
        return templateOptionStrings;
    }

    public boolean applyOptions() throws IOException {
        String subDirectoryTemplateText = ((ListNode)this.subDirectoryTemplates.getSelectedItem()).getTemplateText();
        String fileTemplateText = ((ListNode)this.fileTemplates.getSelectedItem()).getTemplateText();
        if (!fileTemplateText.equals(this.oldFileName)) {
            SharingSettings.setFileNameLWSTemplate(fileTemplateText);
        }
        if (!subDirectoryTemplateText.equals(this.oldSubDirectory)) {
            SharingSettings.setSubdirectoryLWSTemplate(subDirectoryTemplateText);
        }
        return false;
    }

    public boolean isDirty() {
        return !SharingSettings.getFileNameLWSTemplate().equals(this.oldFileName) || !SharingSettings.getSubDirectoryLWSTemplate().equals(this.oldSubDirectory);
    }

    private static void setJComboBox(JComboBox box, ListNode[] boxList, String subString) {
        int index = 0;
        if (subString != null) {
            for (ListNode node : boxList) {
                if (subString.equals(node.getTemplateText())) break;
                ++index;
            }
        }
        if (index >= boxList.length) {
            index = 0;
        }
        box.setSelectedIndex(index);
    }

    class ListNode {
        private final String displayText;
        private final String templateText;

        public ListNode(String displayText, String displayTemplateText) {
            this.displayText = displayText;
            this.templateText = displayTemplateText;
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public String getTemplateText() {
            return this.templateText;
        }

        public String toString() {
            return this.displayText;
        }
    }
}

