/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.iTunesSettings;
import java.io.IOException;
import javax.swing.JCheckBox;
import org.limewire.i18n.I18nMarker;

public final class iTunesPreferencePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Importing");
    public static final String LABEL = I18n.tr("You can have LimeWire import newly downloaded songs into iTunes.");
    private final String CHECK_BOX_LABEL = I18nMarker.marktr("Enable iTunes importing:");
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public iTunesPreferencePaneItem() {
        super(TITLE, LABEL);
        LabeledComponent comp = new LabeledComponent(this.CHECK_BOX_LABEL, this.CHECK_BOX, 120, 10);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this.CHECK_BOX.setSelected(iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue());
    }

    public boolean applyOptions() throws IOException {
        iTunesSettings.ITUNES_SUPPORT_ENABLED.setValue(this.CHECK_BOX.isSelected());
        return false;
    }

    public boolean isDirty() {
        return iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue() != this.CHECK_BOX.isSelected();
    }
}

