/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.playlist;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.mp3.AudioSource;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.mp3.PlayListItem;
import com.limegroup.gnutella.gui.playlist.NumberCell;
import com.limegroup.gnutella.gui.playlist.NumberTableCellRenderer;
import com.limegroup.gnutella.gui.playlist.PlaylistButtons;
import com.limegroup.gnutella.gui.playlist.PlaylistDataLine;
import com.limegroup.gnutella.gui.playlist.PlaylistModel;
import com.limegroup.gnutella.gui.playlist.StoreName;
import com.limegroup.gnutella.gui.playlist.StoreNameRendererEditor;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlaylistMediator
extends AbstractTableMediator<PlaylistModel, PlaylistDataLine, PlayListItem>
implements ThemeObserver {
    private static final Log LOG = LogFactory.getLog(PlaylistMediator.class);
    private static final PlaylistMediator INSTANCE = new PlaylistMediator();
    private StoreNameRendererEditor STORE_RENDERER;
    private StoreNameRendererEditor STORE_EDITOR;
    private NumberTableCellRenderer TABLE_NUMBER_RENDERER;
    private final Object PLAY_LOCK = new Object();
    private boolean isContinuous = true;
    private File lastOpenedPlaylist;
    private File lastSavedPlaylist;
    ActionListener LOAD_LISTENER;
    ActionListener SAVE_LISTENER;
    ActionListener CLEAR_LISTENER;
    ActionListener CONTINUOUS_LISTENER;
    ActionListener SHUFFLE_LISTENER;
    private PlaylistModel MODEL;

    private PlaylistMediator() {
        super("PLAYLIST_TABLE");
        ThemeMediator.addThemeObserver(this);
    }

    public static PlaylistMediator getInstance() {
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.LOAD_LISTENER = new LoadListener();
        this.SAVE_LISTENER = new SaveListener();
        this.CLEAR_LISTENER = new ClearListener();
        this.CONTINUOUS_LISTENER = new ContinuousListener();
        this.SHUFFLE_LISTENER = new ShuffleListener();
        this.REMOVE_LISTENER = new RemoveListener();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(I18n.tr("Playlist"));
        this.MODEL = new PlaylistModel();
        this.DATA_MODEL = this.MODEL;
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new PlaylistButtons(this).getComponent();
        this.STORE_RENDERER = new StoreNameRendererEditor();
        this.STORE_EDITOR = new StoreNameRendererEditor();
        this.TABLE_NUMBER_RENDERER = new NumberTableCellRenderer();
    }

    @Override
    public void updateTheme() {
        super.updateTheme();
        this.STORE_RENDERER.updateTheme();
        this.STORE_EDITOR.updateTheme();
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Playlist Window..."));
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        return null;
    }

    @Override
    protected void setupMainPanel() {
        JPanel jp = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        jp.add((Component)this.getScrolledTablePane(), gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        jp.add(Box.createVerticalStrut(6), gbc);
        gbc.gridy = 2;
        jp.add((Component)this.buildOptionsPanel(), gbc);
        this.MAIN_PANEL.add(jp);
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        this.setButtonEnabled(3, false);
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(StoreName.class, this.STORE_RENDERER);
        this.TABLE.setDefaultRenderer(NumberCell.class, this.TABLE_NUMBER_RENDERER);
    }

    @Override
    protected void setDefaultEditors() {
        super.setDefaultEditors();
        this.TABLE.setDefaultEditor(StoreName.class, this.STORE_EDITOR);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new PlaylistFileTransferHandler());
    }

    @Override
    public void handleSelection(int row) {
        this.setButtonEnabled(2, true);
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(2, false);
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
    }

    @Override
    public void handleActionKey() {
        this.playSong();
    }

    public void setSelectedIndex(PlayListItem item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.MODEL.setCurrentSong(item);
    }

    public PlayListItem getNextSong() {
        return this.getSongToPlay();
    }

    public List<PlayListItem> getSongs() {
        return this.MODEL.getSongs();
    }

    public PlayListItem getPrevSong() {
        this.MODEL.setBackwardsMode();
        return this.getSongToPlay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlayListItem getSongToPlay() {
        PlayListItem retFile = null;
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            retFile = this.MODEL.getNextSong();
        }
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.refresh();
                    int playIndex = PlaylistMediator.this.MODEL.getCurrentSongIndex();
                    if (playIndex >= 0) {
                        PlaylistMediator.this.TABLE.ensureRowVisible(playIndex);
                    }
                }
                if (PlaylistMediator.this.TABLE.isEditing()) {
                    TableCellEditor editor = PlaylistMediator.this.TABLE.getCellEditor();
                    editor.cancelCellEditing();
                }
            }
        });
        return retFile;
    }

    public static List<PlayListItem> createItemList(File[] files) {
        ArrayList<PlayListItem> items = new ArrayList<PlayListItem>();
        for (File f : files) {
            if (f == null) continue;
            if (PlaylistMediator.isPlayableFile(f)) {
                items.add(new PlayListItem(f));
                continue;
            }
            if (!f.isDirectory()) continue;
            items.addAll(PlaylistMediator.createItemList(f.listFiles()));
        }
        return items;
    }

    public void addFilesToPlaylist(File[] fs) {
        this.addFilesToPlaylist(fs, -1);
    }

    public void addFilesToPlaylist(final File[] fs, final int index) {
        if (fs == null || fs.length == 0) {
            return;
        }
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                PlaylistMediator.this.addFilesToPlayList(PlaylistMediator.createItemList(fs), index);
            }
        });
    }

    private void addFilesToPlayList(final List<PlayListItem> items, final int index) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    for (PlayListItem item : items) {
                        PlaylistMediator.this.add(item, index);
                    }
                }
                PlaylistMediator.this.setButtonEnabled(3, true);
            }
        });
    }

    public void addFileToPlaylist(URL url, String name, boolean isFile, boolean storePreview, Map<String, String> map) {
        this.addFileToPlaylist(url, name, isFile, storePreview, map, -1);
    }

    public void addFileToPlaylist(final URL url, final String name, final boolean isFile, final boolean storePreview, final Map<String, String> map, final int index) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                try {
                    PlaylistMediator.this.addFileToPlayList(new PlayListItem(url.toURI(), new AudioSource(url), name, isFile, storePreview, map), index);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        });
    }

    public void addFileToPlaylist(File f) {
        this.addFileToPlaylist(f, -1);
    }

    public void addFileToPlaylist(final File f, final int index) {
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                PlaylistMediator.this.addFileToPlayList(new PlayListItem(f), index);
            }
        });
    }

    private void addFileToPlayList(final PlayListItem item, final int index) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.add(item, index);
                }
                PlaylistMediator.this.setButtonEnabled(3, true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFileFromPlaylist(int index) {
        if (index < 0 || index > this.MODEL.getRowCount()) {
            return false;
        }
        Object object = this.PLAY_LOCK;
        synchronized (object) {
            this.removeRow(index);
        }
        if (this.MODEL.getRowCount() <= 0) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    PlaylistMediator.this.setButtonEnabled(3, false);
                }
            });
        }
        return true;
    }

    public boolean isContinuous() {
        return this.isContinuous;
    }

    public boolean isEndOfList() {
        return !this.MODEL.isShuffleSet() && this.MODEL.getCurrentSongIndex() == this.getSize() - 1;
    }

    public void playStarted() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                PlaylistMediator.this.refresh();
            }
        });
    }

    public void playComplete() {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            public void run() {
                PlaylistMediator.this.refresh();
            }
        });
    }

    private JPanel buildOptionsPanel() {
        JLabel options = new JLabel(I18n.tr("Play Options:"));
        JCheckBox shuffle = new JCheckBox(I18n.tr("Shuffle"), false);
        shuffle.addActionListener(this.SHUFFLE_LISTENER);
        JCheckBox continuous = new JCheckBox(I18n.tr("Continuous"), true);
        continuous.addActionListener(this.CONTINUOUS_LISTENER);
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.add(options);
        checkBoxPanel.add(continuous);
        checkBoxPanel.add(shuffle);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        optionsPanel.add((Component)this.BUTTON_ROW, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        optionsPanel.add((Component)checkBoxPanel, gbc);
        return optionsPanel;
    }

    public static boolean isPlayableFile(File file) {
        String name = file.getName().toLowerCase(Locale.US);
        return name.endsWith(".mp3") || name.endsWith(".ogg") || name.endsWith(".wav");
    }

    private void playSong() {
        PlaylistDataLine line = (PlaylistDataLine)((PlaylistModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (line == null) {
            return;
        }
        PlayListItem f = line.getPlayListItem();
        this.MODEL.setCurrentSong(f);
        MediaPlayerComponent.getInstance().loadSong(f);
    }

    public boolean openIfPlaylist(File file) {
        String name = file.getName().toLowerCase(Locale.US);
        if (!name.endsWith(".m3u")) {
            return false;
        }
        this.loadPlayListFile(file, false);
        return true;
    }

    private void loadPlaylist() {
        File selFile;
        String parent;
        File parentFile = null;
        if (this.lastOpenedPlaylist != null && (parent = this.lastOpenedPlaylist.getParent()) != null) {
            parentFile = new File(parent);
        }
        if (parentFile == null) {
            parentFile = CommonUtils.getCurrentDirectory();
        }
        if ((selFile = FileChooserHandler.getInputFile((Component)this.getComponent(), I18nMarker.marktr("Open Playlist (.m3u)"), parentFile, new PlaylistListFileFilter())) == null || !selFile.isFile()) {
            return;
        }
        this.loadPlayListFile(selFile, false);
    }

    private void loadPlayListFile(File selFile, boolean overwrite) {
        String path = selFile.getPath();
        try {
            path = FileUtils.getCanonicalPath(selFile);
        }
        catch (IOException ignored) {
            LOG.warn("unable to get canonical path for file: " + selFile, ignored);
        }
        this.loadPlaylist(selFile, path, overwrite);
    }

    private void loadPlaylist(final File selFile, final String path, final boolean overwrite) {
        BackgroundExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                final PlayList pl = new PlayList(path);
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.lastOpenedPlaylist = selFile;
                    if (overwrite) {
                        PlaylistMediator.this.clearTable();
                    }
                    GUIMediator.safeInvokeLater(new Runnable(){

                        public void run() {
                            PlaylistMediator.this.MODEL.addSongs(pl);
                            if (PlaylistMediator.this.MODEL.getRowCount() > 0) {
                                PlaylistMediator.this.setButtonEnabled(3, true);
                            }
                        }
                    });
                }
            }
        });
    }

    private void savePlaylist() {
        DialogOption choice;
        File suggested = this.lastSavedPlaylist != null ? this.lastSavedPlaylist : (this.lastOpenedPlaylist != null ? this.lastOpenedPlaylist : new File(CommonUtils.getCurrentDirectory(), "limewire.m3u"));
        File selFile = FileChooserHandler.getSaveAsFile(this.getComponent(), I18nMarker.marktr("Save Playlist As"), suggested, new PlaylistListFileFilter());
        if (selFile == null) {
            return;
        }
        if (selFile.exists() && !selFile.equals(this.lastOpenedPlaylist) && (choice = GUIMediator.showYesNoMessage(I18n.tr("Warning: a file with the name {0} already exists in the folder. Overwrite this file?", selFile.getName()), QuestionsHandler.PLAYLIST_OVERWRITE_OK, DialogOption.NO)) != DialogOption.YES) {
            return;
        }
        String path = selFile.getPath();
        try {
            path = FileUtils.getCanonicalPath(selFile);
        }
        catch (IOException ignored) {
            LOG.warn("unable to get canonical path for file: " + selFile, ignored);
        }
        if (!path.toLowerCase(Locale.US).endsWith(".m3u")) {
            path = path + ".m3u";
        }
        this.savePlaylist(path);
    }

    private void savePlaylist(final String path) {
        BackgroundExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PlayList pl = new PlayList(path);
                Object object = PlaylistMediator.this.PLAY_LOCK;
                synchronized (object) {
                    PlaylistMediator.this.lastSavedPlaylist = new File(path);
                    pl.setSongs(PlaylistMediator.this.MODEL.getLocalFiles());
                }
                try {
                    pl.save();
                }
                catch (IOException ignored) {
                    LOG.warn("Unable to save playlist", ignored);
                    GUIMediator.safeInvokeLater(new Runnable(){

                        public void run() {
                            GUIMediator.showError("Unable to save playlist");
                        }
                    });
                }
            }
        });
    }

    private void clearPlaylist() {
        this.MODEL.clear();
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                PlaylistMediator.this.setButtonEnabled(3, false);
            }
        });
    }

    @Override
    public void removeSelection() {
        super.removeSelection();
        if (this.MODEL.getRowCount() <= 0) {
            this.setButtonEnabled(3, false);
        }
    }

    public void buyProduct(PlaylistDataLine line) {
        JOptionPane.showMessageDialog(null, "buy: " + line.getPlayListItem().getName());
    }

    public void infoProduct(PlaylistDataLine line) {
        JOptionPane.showMessageDialog(null, "try: " + line.getPlayListItem().getName());
    }

    public static class PlaylistTransferable
    implements Transferable {
        public static final DataFlavor playlistFlavor = new DataFlavor(PlaylistTransferable.class, "LimeWire PlaylistTransfer");

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{playlistFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(playlistFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                return null;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private class PlaylistFileTransferHandler
    extends LimeTransferHandler {
        DataFlavor playlistFlavor;
        int removeIndex;
        int addIndex;

        public PlaylistFileTransferHandler() {
            super(0x40000003);
            this.playlistFlavor = new DataFlavor(PlaylistTransferable.class, "LimeWire PlaylistTransfer");
            this.removeIndex = -1;
            this.addIndex = -1;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
            return this.canImport(c, flavors);
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return DNDUtils.containsFileFlavors(transferFlavors) || DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(comp, transferFlavors);
        }

        public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
            return this.importData(c, t);
        }

        public boolean importData(JComponent comp, Transferable t) {
            if (!this.canImport(comp, t.getTransferDataFlavors())) {
                return false;
            }
            try {
                int index = ((JTable)comp).getSelectedRow();
                if (index < 0 || index > PlaylistMediator.this.MODEL.getRowCount()) {
                    index = PlaylistMediator.this.MODEL.getRowCount();
                }
                this.addIndex = index;
                if (index > this.removeIndex) {
                    ++index;
                }
                File[] files = DNDUtils.getFiles(t);
                if (!DNDUtils.contains(t.getTransferDataFlavors(), this.playlistFlavor)) {
                    PlaylistMediator.this.addFilesToPlaylist(files, index);
                }
                if (files.length > 0) {
                    return true;
                }
            }
            catch (UnsupportedFlavorException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(comp, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Transferable createTransferable(JComponent comp) {
            int[] rows;
            if (PlaylistMediator.this.TABLE.isEditing()) {
                TableCellEditor editor = PlaylistMediator.this.TABLE.getCellEditor();
                editor.cancelCellEditing();
            }
            if ((rows = PlaylistMediator.this.TABLE.getSelectedRows()).length == 0) {
                return null;
            }
            ArrayList<File> list = new ArrayList<File>(rows.length);
            Object object = PlaylistMediator.this.PLAY_LOCK;
            synchronized (object) {
                for (int i = 0; i < rows.length; ++i) {
                    list.add(((PlaylistDataLine)PlaylistMediator.this.MODEL.get(rows[i])).getFile());
                }
            }
            this.removeIndex = rows[0];
            return new CompositeTransferable(new PlaylistTransferable(), new FileTransferable(list));
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
            if (action == 2) {
                if ((this.removeIndex != -1 || this.addIndex != -1) && this.removeIndex >= 0 && this.addIndex >= 0 && this.removeIndex < PlaylistMediator.this.TABLE.getRowCount() && this.addIndex < PlaylistMediator.this.TABLE.getRowCount()) {
                    this.handleMove(this.removeIndex, this.addIndex);
                }
                this.removeIndex = -1;
                this.addIndex = -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMove(int removeLocation, int addLocation) {
            Object object = PlaylistMediator.this.PLAY_LOCK;
            synchronized (object) {
                PlaylistMediator.this.moveRow(removeLocation, addLocation);
                PlaylistMediator.this.TABLE.setSelectedRow(addLocation);
            }
        }
    }

    private static class PlaylistListFileFilter
    extends FileFilter {
        private PlaylistListFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.US).endsWith("m3u");
        }

        public String getDescription() {
            return I18n.tr("Playlist Files (*.m3u)");
        }
    }

    private class ShuffleListener
    implements ActionListener {
        private ShuffleListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            PlaylistMediator.this.MODEL.setShuffle(b.isSelected());
        }
    }

    private class ContinuousListener
    implements ActionListener {
        private ContinuousListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            PlaylistMediator.this.isContinuous = b.isSelected();
        }
    }

    private class ClearListener
    implements ActionListener {
        private ClearListener() {
        }

        public void actionPerformed(ActionEvent arg0) {
            PlaylistMediator.this.clearPlaylist();
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PlaylistMediator.this.savePlaylist();
        }
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PlaylistMediator.this.loadPlaylist();
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PlaylistMediator.this.removeSelection();
        }
    }
}

