/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.properties;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultProperties {
    private Map<String, String> file = new HashMap<String, String>();
    private Map<String, String> meta;
    private String xml;

    public static String title() {
        if (OSUtils.isMacOSX()) {
            return I18n.tr("Get Info");
        }
        return I18n.tr("Properties");
    }

    public ResultProperties(TableLine line) {
        LimeXMLDocument document;
        this.file.put("Name", line.getFilename());
        this.file.put("Size", ResultProperties.size(line.getSize()));
        this.file.put("Hash", line.getSHA1().toString());
        if (line.getNamedMediaType() != null) {
            this.file.put("Type", line.getNamedMediaType().toString());
        }
        if ((document = line.getXMLDocument()) != null) {
            this.meta = XMLUtils.getDisplayProperties(document);
            this.xml = document.toString();
            if (this.xml.equals("")) {
                this.xml = null;
            }
        }
        if (this.meta != null && this.meta.containsKey("Bitrate")) {
            this.meta.put("Bitrate", this.meta.get("Bitrate") + " " + I18n.tr("Kbps"));
        }
    }

    public Map<String, String> getFileProperties() {
        return this.file;
    }

    public Map<String, String> getMetaProperties() {
        return this.meta;
    }

    public String getXML() {
        return this.xml;
    }

    private static String size(long size) {
        return GUIUtils.toUnitbytes(size) + " (" + NumberFormat.getInstance().format(size) + " bytes)";
    }
}

