/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class CompositeCellTableRendererAndTableCellEditor
extends JPanel
implements TableCellRenderer,
TableCellEditor,
ThemeObserver {
    public final JLabel mainLabel;
    public final List<SmallButton> buttons = new ArrayList<SmallButton>();
    private static final int HGAP = 2;
    private static final int VGAP = 2;
    JPanel buttonPanel;
    private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();

    protected CompositeCellTableRendererAndTableCellEditor() {
        this.setLayout(new BorderLayout());
        int columns = this.createActions().length;
        GridLayout grid = new GridLayout(1, columns);
        grid.setHgap(2);
        this.buttonPanel = new JPanel(grid);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.mainLabel = new JLabel();
        this.add((Component)this.buttonPanel, "West");
        this.add((Component)this.mainLabel, "Center");
        for (Action a : this.createActions()) {
            SmallButton sb = new SmallButton(a);
            this.buttonPanel.add(sb);
            this.buttons.add(sb);
        }
        this.setOpaque(true);
    }

    protected abstract Action[] createActions();

    protected abstract String getNameForValue(Object var1);

    protected boolean buttonsVisible() {
        return true;
    }

    public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        return this.getTableCellComponent(table, value, isSel, hasFocus, row, column);
    }

    public final Component getTableCellEditorComponent(JTable table, Object value, boolean isSel, int row, int col) {
        return this.getTableCellComponent(table, value, true, true, row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(lis)) {
                this.listeners.add(lis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingCanceled(new ChangeEvent(this));
            }
        }
    }

    public final Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject e) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeCellEditorListener(CellEditorListener lis) {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(lis)) {
                this.listeners.remove(lis);
            }
        }
    }

    public final boolean shouldSelectCell(EventObject e) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stopCellEditing() {
        List<CellEditorListener> list = this.listeners;
        synchronized (list) {
            int N = this.listeners.size();
            for (int i = 0; i < N; ++i) {
                this.listeners.get(i).editingStopped(new ChangeEvent(this));
            }
        }
        return true;
    }

    protected abstract Color getFontColor(Color var1);

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.mainLabel != null) {
            this.mainLabel.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.mainLabel != null) {
            this.mainLabel.setForeground(this.getFontColor(fg));
        }
    }

    private Component getTableCellComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        String text = this.getNameForValue(value);
        this.mainLabel.setText(text);
        this.buttonPanel.setVisible(this.buttonsVisible());
        if (isSel) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            LimeJTable ljt = (LimeJTable)table;
            this.setBackground(ljt.getBackgroundForRow(row));
            this.setForeground(ljt.getForeground());
        }
        return this;
    }

    public void updateTheme() {
        this.mainLabel.setFont(UIManager.getFont("Table.font"));
        this.mainLabel.setForeground(ThemeFileHandler.WINDOW8_COLOR.getValue());
    }

    private static class SmallButton
    extends JButton {
        SmallButton(Action a) {
            super(a);
            this.setFocusable(false);
            Font font = UIManager.getFont("Table.font");
            font = font.deriveFont((float)((double)font.getSize() * 0.8));
            this.setFont(font);
            this.setVerticalTextPosition(1);
        }
    }
}

