/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.FilterPanel;
import com.limegroup.gnutella.gui.search.FilterPopupMenuHandler;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.limewire.i18n.I18nMarker;

class FilterInputPanel
extends BoxPanel {
    private final Ditherer DITHERER = new Ditherer(20, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
    private final CardLayout FILTER_CARDS = new CardLayout();
    private final JPanel FILTER_PANEL = new JPanel(this.FILTER_CARDS);
    private final Map<ResultPanel, FilterPanel> ACTIVE_FILTERS = new HashMap<ResultPanel, FilterPanel>();
    private JButton backToSearch;

    FilterInputPanel(ActionListener forButton, KeyListener autoSearch) {
        super(1);
        this.add(Box.createVerticalStrut(4));
        this.add(GUIUtils.left(new JLabel(I18n.tr("Filter Results:"))));
        this.add(this.FILTER_PANEL);
        this.add(Box.createVerticalStrut(4));
        this.add(this.createBackToSearchButton(forButton, autoSearch));
    }

    void requestFilterFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilterInputPanel.this.backToSearch.requestFocus();
            }
        });
    }

    void clearFilters() {
        Iterator<FilterPanel> i = this.ACTIVE_FILTERS.values().iterator();
        while (i.hasNext()) {
            this.FILTER_PANEL.remove(i.next());
            i.remove();
        }
        FilterBox.clearRenderer();
    }

    void panelReset(ResultPanel rp) {
        FilterPanel panel = this.ACTIVE_FILTERS.get(rp);
        if (panel != null) {
            this.FILTER_PANEL.remove(panel);
            this.ACTIVE_FILTERS.remove(rp);
            this.setFiltersFor(rp);
        }
    }

    boolean panelRemoved(ResultPanel rp) {
        FilterPanel panel = this.ACTIVE_FILTERS.get(rp);
        if (panel != null) {
            this.FILTER_PANEL.remove(panel);
            this.ACTIVE_FILTERS.remove(rp);
        }
        FilterBox.clearRenderer();
        return this.ACTIVE_FILTERS.isEmpty();
    }

    boolean setFiltersFor(ResultPanel rp) {
        boolean added = false;
        FilterPanel panel = this.ACTIVE_FILTERS.get(rp);
        if (panel == null) {
            added = true;
            panel = new FilterPanel(rp);
            FilterPopupMenuHandler.install(panel);
            this.FILTER_PANEL.add((Component)panel, panel.getUniqueDescription());
            this.ACTIVE_FILTERS.put(rp, panel);
        }
        this.FILTER_CARDS.show(this.FILTER_PANEL, panel.getUniqueDescription());
        return added;
    }

    private JPanel createBackToSearchButton(ActionListener forButton, KeyListener autoSearch) {
        IconButton search = new IconButton(I18n.tr("Back To Search"), I18nMarker.marktr("Back To Search"));
        search.addActionListener(forButton);
        search.addKeyListener(autoSearch);
        search.setRequestFocusEnabled(true);
        DitherPanel panel = new DitherPanel(this.DITHERER);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(5));
        panel.add(GUIUtils.center(search));
        panel.add(Box.createVerticalStrut(5));
        panel.setBackground(ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        GUIUtils.setOpaque(false, panel);
        if (!ThemeSettings.isNativeTheme()) {
            panel.setOpaque(true);
        }
        panel.setBorder(BorderFactory.createLineBorder(ThemeFileHandler.SEARCH_GRID_COLOR.getValue()));
        this.backToSearch = search;
        return panel;
    }
}

