/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.actions.SearchWhatsNewMediaTypeAction;
import com.limegroup.gnutella.gui.actions.SearchXMLFieldAction;
import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.FilterPanel;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterPopupMenuHandler {
    private FilterPanel filterPanel;

    private FilterPopupMenuHandler(FilterPanel panel) {
        this.filterPanel = panel;
        FilterBox[] boxes = this.filterPanel.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            boxes[i].getList().addMouseListener(new DefaultMouseListener(new MouseHandler(boxes[i])));
        }
    }

    public static void install(FilterPanel panel) {
        new FilterPopupMenuHandler(panel);
    }

    private void createAndShowPopup(FilterBox box, MouseEvent e) {
        JList list = box.getList();
        int index = list.locationToIndex(e.getPoint());
        if (index != -1) {
            list.setSelectedIndex(index);
        }
        LinkedHashMap map = new LinkedHashMap();
        this.addData(box, map);
        FilterBox[] boxes = this.filterPanel.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            this.addData(boxes[i], map);
        }
        Action[] actions = this.createActions(map);
        if (actions.length > 0) {
            JPopupMenu menu = new JPopupMenu();
            for (int i = 0; i < actions.length; ++i) {
                menu.add(new JMenuItem(actions[i]));
            }
            menu.show(box.getList(), e.getX(), e.getY());
        }
    }

    private void addData(FilterBox box, Map<? super Selector, Object> map) {
        Object o;
        if (!box.getSelector().isPropertySelector() && (o = box.getSelectedValue()) != null && !MetadataModel.isAll(o)) {
            map.put(box.getSelector(), o);
        }
    }

    private Action[] createActions(Map<? extends Selector, ? extends Object> map) {
        if (map.isEmpty()) {
            return new Action[0];
        }
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        for (Map.Entry<? extends Selector, ? extends Object> entry : map.entrySet()) {
            Selector sel = entry.getKey();
            if (sel.isSchemaSelector()) {
                actions.add(new SearchWhatsNewMediaTypeAction((NamedMediaType)entry.getValue()));
                continue;
            }
            if (!sel.isFieldSelector()) continue;
            actions.add(new SearchXMLFieldAction(new NameValue<Object>(sel.getTitle(), entry.getValue()), sel.getValue(), entry.getValue().toString(), NamedMediaType.getFromDescription(sel.getSchema())));
        }
        return actions.toArray(new Action[0]);
    }

    private class MouseHandler
    implements MouseObserver {
        private FilterBox box;

        public MouseHandler(FilterBox box) {
            this.box = box;
        }

        public void handlePopupMenu(MouseEvent e) {
            FilterPopupMenuHandler.this.createAndShowPopup(this.box, e);
        }

        public void handleMouseDoubleClick(MouseEvent e) {
        }

        public void handleRightMouseClick(MouseEvent e) {
        }
    }
}

