/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.BitziLookupAction;
import com.limegroup.gnutella.gui.actions.CopyMagnetLinkToClipboardAction;
import com.limegroup.gnutella.gui.properties.ResultProperties;
import com.limegroup.gnutella.gui.search.AbstractSearchResult;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.UISettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GnutellaSearchResult
extends AbstractSearchResult {
    private final RemoteFileDesc RFD;
    private final HostData DATA;
    private Set<? extends IpPort> _alts;

    GnutellaSearchResult(RemoteFileDesc rfd, HostData data, Set<? extends IpPort> alts) {
        this.RFD = rfd;
        this.DATA = data;
        this._alts = UISettings.UI_ADD_REPLY_ALT_LOCS.getValue() ? alts : Collections.emptySet();
    }

    RemoteFileDesc getRemoteFileDesc() {
        return this.RFD;
    }

    HostData getHostData() {
        return this.DATA;
    }

    Set<? extends IpPort> getAlts() {
        return this._alts;
    }

    void clearAlts() {
        this._alts = null;
    }

    void setAlts(Set<? extends IpPort> alts) {
        this._alts = alts;
    }

    @Override
    public String getFileName() {
        return this.RFD.getFileName();
    }

    @Override
    public long getSize() {
        return this.RFD.getSize();
    }

    @Override
    public URN getSHA1Urn() {
        return this.RFD.getSHA1Urn();
    }

    @Override
    public LimeXMLDocument getXMLDocument() {
        return this.RFD.getXMLDocument();
    }

    @Override
    public long getCreationTime() {
        return this.RFD.getCreationTime();
    }

    @Override
    public boolean isDownloading() {
        return this.RFD.isDownloading();
    }

    @Override
    public String getVendor() {
        return this.RFD.getVendor();
    }

    @Override
    public int getQuality() {
        return this.RFD.getQuality();
    }

    @Override
    public int getSecureStatus() {
        return this.RFD.getSecureStatus();
    }

    @Override
    public int getSpeed() {
        return this.DATA.getSpeed();
    }

    @Override
    public boolean isMeasuredSpeed() {
        return false;
    }

    @Override
    public float getSpamRating() {
        return this.RFD.getSpamRating();
    }

    @Override
    public String getHost() {
        return this.RFD.getHost();
    }

    @Override
    public Color getEvenRowColor() {
        return ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
    }

    @Override
    public Color getOddRowColor() {
        return ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue();
    }

    @Override
    public void takeAction(TableLine line, GUID guid, File saveDir, String fileName, boolean saveAs, SearchInformation searchInfo) {
        SearchMediator.downloadGnutellaLine(line, guid, saveDir, fileName, saveAs, searchInfo);
    }

    @Override
    public void initialize(TableLine line) {
        RemoteFileDesc rfd = this.getRemoteFileDesc();
        Set<? extends IpPort> alts = this.getAlts();
        if (rfd.isChatEnabled()) {
            line.setChatHost(rfd);
        }
        if (rfd.isBrowseHostEnabled()) {
            line.setBrowseHost(rfd);
        }
        if (!rfd.isFirewalled()) {
            line.setNonFirewalledHost(rfd);
        }
        line.createEndpointHolder(rfd.getHost(), rfd.getPort(), rfd.isReplyToMulticast());
        line.setAddedOn(rfd.getCreationTime());
        if (alts != null && !alts.isEmpty()) {
            Set<IpPort> as = line.getAltIpPortSet();
            as.addAll(alts);
            this.clearAlts();
            line.getLocation().addHosts(alts);
        }
    }

    @Override
    public JPopupMenu createMenu(JPopupMenu popupMenu, TableLine[] lines, boolean markAsSpam, boolean markAsNot, ResultPanel resultPanel) {
        PopupUtils.addMenuItem(SearchMediator.DOWNLOAD_STRING, resultPanel.DOWNLOAD_LISTENER, popupMenu, lines.length > 0, 0);
        PopupUtils.addMenuItem(I18n.tr("Download As..."), resultPanel.DOWNLOAD_AS_LISTENER, popupMenu, lines.length == 1, 1);
        PopupUtils.addMenuItem(I18n.tr("View License"), (ActionListener)new LicenseListener(resultPanel), popupMenu, lines.length > 0 && lines[0].isLicenseAvailable(), 2);
        PopupUtils.addMenuItem(SearchMediator.CHAT_STRING, resultPanel.CHAT_LISTENER, popupMenu, lines.length > 0 && lines[0].isChatEnabled(), 3);
        PopupUtils.addMenuItem(SearchMediator.BROWSE_HOST_STRING, resultPanel.BROWSE_HOST_LISTENER, popupMenu, lines.length > 0 && lines[0].isBrowseHostEnabled(), 4);
        PopupUtils.addMenuItem(SearchMediator.BLOCK_STRING, (ActionListener)new BlockListener(resultPanel), popupMenu, lines.length > 0, 5);
        JMenu spamMenu = new JMenu(SearchMediator.MARK_AS_STRING);
        spamMenu.setEnabled(markAsSpam || markAsNot);
        PopupUtils.addMenuItem(SearchMediator.SPAM_STRING, resultPanel.MARK_AS_SPAM_LISTENER, spamMenu, markAsSpam);
        PopupUtils.addMenuItem(SearchMediator.NOT_SPAM_STRING, resultPanel.MARK_AS_NOT_SPAM_LISTENER, spamMenu, markAsNot);
        popupMenu.add((Component)spamMenu, 6);
        popupMenu.add((Component)new JPopupMenu.Separator(), 7);
        popupMenu.add((Component)this.createAdvancedMenu(lines.length > 0 ? lines[0] : null, resultPanel), 8);
        popupMenu.add(new JPopupMenu.Separator());
        PopupUtils.addMenuItem(ResultProperties.title(), resultPanel.PROPERTIES_LISTENER, popupMenu, lines.length > 0);
        return popupMenu;
    }

    private JMenu createAdvancedMenu(TableLine line, ResultPanel resultPanel) {
        JMenu menu = new JMenu(I18n.tr("Advanced"));
        if (line == null) {
            menu.setEnabled(false);
            return menu;
        }
        BitziLookupAction bitziAction = new BitziLookupAction(resultPanel);
        bitziAction.setEnabled(line.getRemoteFileDesc().getSHA1Urn() != null);
        menu.add(new JMenuItem(bitziAction));
        CopyMagnetLinkToClipboardAction magnet = new CopyMagnetLinkToClipboardAction(resultPanel);
        magnet.setEnabled(line.hasNonFirewalledRFD());
        menu.add(new JMenuItem(magnet));
        if (line.isLaunchable()) {
            menu.addSeparator();
            PopupUtils.addMenuItem(SearchMediator.LAUNCH_STRING, resultPanel.DOWNLOAD_LISTENER, menu.getPopupMenu(), true);
        }
        return menu;
    }

    private static class BlockListener
    implements ActionListener {
        private final ResultPanel p;

        BlockListener(ResultPanel p) {
            this.p = p;
        }

        public void actionPerformed(ActionEvent e) {
            this.p.blockHost();
        }
    }

    private static class LicenseListener
    implements ActionListener {
        private final ResultPanel p;

        LicenseListener(ResultPanel p) {
            this.p = p;
        }

        public void actionPerformed(ActionEvent e) {
            this.p.showLicense();
        }
    }
}

