/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnetClipboardListener
extends WindowAdapter {
    private static final Log LOG = LogFactory.getLog(MagnetClipboardListener.class);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final StringSelection empty = new StringSelection("");
    private volatile String copiedText;
    private final ExecutorService clipboardParser = ExecutorsHelper.newProcessingQueue("clipboard parser");
    private Runnable parser = new Runnable(){

        public void run() {
            MagnetClipboardListener.this.parseAndLaunch();
        }
    };

    private void parseAndLaunch() {
        Transferable data = null;
        try {
            data = this.CLIPBOARD.getContents(this);
        }
        catch (IllegalStateException isx) {
            return;
        }
        if (data == null) {
            return;
        }
        if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        String contents = null;
        try {
            contents = (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException iox) {
            LOG.info("problem occured while trying to parse clipboard, do nothing", iox);
            return;
        }
        catch (UnsupportedFlavorException ufx) {
            LOG.error("UnsupportedFlavor??", ufx);
            return;
        }
        if (contents == null) {
            return;
        }
        String copied = this.copiedText;
        if (copied != null && copied.equals(contents)) {
            return;
        }
        MagnetOptions[] opts = MagnetOptions.parseMagnets(contents);
        if (opts.length == 0) {
            return;
        }
        LOG.info("clipboard contains " + contents);
        this.purgeClipboard();
        MagnetClipboardListener.handleMagnets(opts, true);
    }

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public void setCopiedText(String text) {
        this.copiedText = text;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.clipboardParser.execute(this.parser);
    }

    private void purgeClipboard() {
        try {
            this.CLIPBOARD.setContents(this.empty, this.empty);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void handleMagnets(final MagnetOptions[] magnets, final boolean showDialog) {
        final MagnetOptions[] downloadCandidates = MagnetClipboardListener.extractDownloadableMagnets(magnets);
        Runnable r = new Runnable(){

            public void run() {
                if (!showDialog) {
                    for (MagnetOptions magnet : downloadCandidates) {
                        DownloaderUtils.createDownloader(magnet);
                    }
                } else if (downloadCandidates.length > 0) {
                    List userChosen = MagnetClipboardListener.showStartDownloadsDialog(downloadCandidates);
                    for (MagnetOptions magnet : userChosen) {
                        DownloaderUtils.createDownloader(magnet);
                    }
                }
                boolean oneSearchStarted = false;
                for (int i = 0; i < magnets.length; ++i) {
                    String query;
                    SearchInformation info;
                    if (magnets[i].isDownloadable() || !magnets[i].isKeywordTopicOnly() || oneSearchStarted || SearchMediator.validateInfo(info = SearchInformation.createKeywordSearch(query = QueryUtils.createQueryString(magnets[i].getKeywordTopic()), null, MediaType.getAnyTypeMediaType())) != 0) continue;
                    oneSearchStarted = true;
                    SearchMediator.triggerSearch(info);
                }
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        };
        GUIMediator.safeInvokeLater(r);
    }

    private static MagnetOptions[] extractDownloadableMagnets(MagnetOptions[] magnets) {
        ArrayList<MagnetOptions> dls = new ArrayList<MagnetOptions>(magnets.length);
        for (int i = 0; i < magnets.length; ++i) {
            MagnetOptions magnet = magnets[i];
            if (magnet.isKeywordTopicOnly()) continue;
            dls.add(magnets[i]);
        }
        if (dls.size() == magnets.length) {
            return magnets;
        }
        return dls.toArray(new MagnetOptions[0]);
    }

    private static List<MagnetOptions> showStartDownloadsDialog(MagnetOptions[] opts) {
        CheckBoxListPanel<MagnetOptions> listPanel = new CheckBoxListPanel<MagnetOptions>(Arrays.asList(opts), new MagnetOptionsTextProvider(), true);
        listPanel.getList().setVisibleRowCount(5);
        Object[] content = new Object[]{new MultiLineLabel(I18n.tr("Would you like to start downloads from the following magnets?"), 400), Box.createVerticalStrut(6), listPanel, Box.createVerticalStrut(6), new MultiLineLabel(I18n.tr("All folders you select will also have their subfolders shared."), 400)};
        int response = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), content, I18n.tr("Message"), 0);
        List<MagnetOptions> selected = listPanel.getSelectedElements();
        if (response == 0) {
            return selected;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MagnetOptionsTextProvider
    implements CheckBoxList.TextProvider<MagnetOptions> {
        private MagnetOptionsTextProvider() {
        }

        @Override
        public String getText(MagnetOptions magnet) {
            String fileName = magnet.getDisplayName();
            if (fileName == null) {
                fileName = I18n.tr("No Filename");
            }
            return fileName;
        }

        @Override
        public String getToolTipText(MagnetOptions magnet) {
            return GUIUtils.restrictWidth(magnet.toString(), 400);
        }

        @Override
        public Icon getIcon(MagnetOptions magnet) {
            return null;
        }
    }
}

