/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.NoGroupTableRowFilter;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SharedSearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableRowFilter;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.search.HostDataImpl;
import com.limegroup.gnutella.settings.ChatSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.limewire.io.NetworkUtils;

public class MySharedFilesResultPanel
extends ResultPanel {
    protected static final String MY_SHARED_FILES_TABLE = "MY_SHARED_FILES_TABLE";
    private JLabel filesLabel;
    private final HostData blankHostData;
    private final FileEventListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MySharedFilesResultPanel(String title, FileManager fileManager) {
        super(title, MY_SHARED_FILES_TABLE);
        this.TABLE.setDragEnabled(false);
        this.TABLE.setTransferHandler(null);
        this.BUTTON_ROW.setButtonsEnabled(false);
        this.SOUTH_PANEL.setVisible(false);
        this.blankHostData = new HostDataImpl(GuiCoreMediator.getApplicationServices().getMyGUID(), this.guid.bytes(), ConnectionSettings.CONNECTION_SPEED.getValue(), !GuiCoreMediator.getNetworkManager().acceptedIncomingConnection(), false, false, ChatSettings.CHAT_ENABLED.getValue(), false, false, NetworkUtils.ip2string(GuiCoreMediator.getNetworkManager().getAddress()), GuiCoreMediator.getNetworkManager().getPort(), 0, "LIME", GuiCoreMediator.getConnectionManager().getPushProxies(), GuiCoreMediator.getNetworkManager().canDoFWT(), GuiCoreMediator.getNetworkManager().supportsFWTVersion(), SSLSettings.isIncomingTLSEnabled());
        FileManager fileManager2 = fileManager;
        synchronized (fileManager2) {
            int i = 0;
            while (fileManager.isValidSharedIndex(i)) {
                FileDesc fd = fileManager.get(i);
                if (fd != null && this.shouldDisplayAddedFile(fd)) {
                    this.addFile(fd);
                }
                ++i;
            }
        }
        this.listener = this.createUpdateListener();
    }

    public Action getUnshareAction(int num) {
        return new UnshareFileAction(num);
    }

    private boolean shouldDisplayAddedFile(FileDesc fd) {
        if (fd instanceof IncompleteFileDesc) {
            return false;
        }
        return !SharingUtils.isForcedShare(fd);
    }

    private void addFile(FileDesc fd) {
        Response response = GuiCoreMediator.getResponseFactory().createResponse(fd);
        List<LimeXMLDocument> docs = fd.getLimeXMLDocuments();
        if (docs.size() == 1) {
            response.setDocument(docs.get(0));
        }
        Set alts = Collections.emptySet();
        RemoteFileDesc rfd = response.toRemoteFileDesc(this.blankHostData, GuiCoreMediator.getRemoteFileDescFactory());
        SharedSearchResult searchResult = new SharedSearchResult(fd, rfd, alts);
        this.add(searchResult);
    }

    private void removeFile(FileDesc fd) {
        for (int i = 0; i < ((TableRowFilter)this.DATA_MODEL).getRowCount(); ++i) {
            TableLine line = this.getLine(i);
            SearchResult sr = (SearchResult)line.getInitializeObject();
            if (!(sr instanceof SharedSearchResult) || !((SharedSearchResult)sr).getFileDesc().equals(fd)) continue;
            this.remove(sr);
        }
    }

    protected void buildListeners() {
        super.buildListeners();
    }

    public JPopupMenu createPopupMenu() {
        TableLine[] lines = this.getAllSelectedLines();
        if (lines.length == 0) {
            return null;
        }
        return new SearchResultMenu(this).addToMenu(new JPopupMenu(), lines, true, false);
    }

    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
    }

    protected void setupDataModel() {
        this.DATA_MODEL = new NoGroupTableRowFilter(this.FILTER);
    }

    public void handleNoSelection() {
        this.BUTTON_ROW.setButtonsEnabled(false);
    }

    public void handleSelection(int i) {
        this.BUTTON_ROW.setButtonsEnabled(false);
    }

    public void handleActionKey() {
    }

    protected void setupMainPanel() {
        this.MAIN_PANEL.add(this.createMyFilesInfoPanel());
        this.setupMainPanelBase();
    }

    private void refreshNumFiles() {
        String info = I18n.tr("You are sharing {0} files. You can control which files LimeWire shares.", GuiCoreMediator.getFileManager().getNumFiles());
        this.filesLabel.setText("<html><font color=\"#7B5100\"><b>" + info + "</b></font></html>");
    }

    private JComponent createMyFilesInfoPanel() {
        JPanel panel = this.createWarningDitherPanel();
        String configure = I18n.tr("Configure");
        String library = I18n.tr("Library");
        panel.setLayout(new FlowLayout(0, 3, 3));
        panel.add(new JLabel(GUIMediator.getThemeImage("warn-triangle")));
        this.filesLabel = new JLabel();
        this.refreshNumFiles();
        panel.add(this.filesLabel);
        panel.add(Box.createHorizontalStrut(2));
        AbstractAction configureAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                OptionsMediator optionsMediator = OptionsMediator.instance();
                optionsMediator.setOptionsVisible(true, "OPTIONS_SHARED_MAIN_TITLE");
            }
        };
        configureAction.putValue("Name", "<b>" + configure + "</b>");
        configureAction.putValue("LimeColor", new Color(172, 113, 0));
        panel.add(new URLLabel(configureAction));
        panel.add(Box.createHorizontalStrut(2));
        AbstractAction libraryAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GUIMediator.instance().getMainFrame().setSelectedTab(GUIMediator.Tabs.LIBRARY);
            }
        };
        libraryAction.putValue("Name", "<b>" + library + "</b>");
        libraryAction.putValue("LimeColor", new Color(172, 113, 0));
        panel.add(new URLLabel(libraryAction));
        Dimension ps = panel.getPreferredSize();
        ps.width = Short.MAX_VALUE;
        panel.setMaximumSize(ps);
        return panel;
    }

    public void cleanup() {
        GuiCoreMediator.getFileManager().removeFileEventListener(this.listener);
    }

    private FileEventListener createUpdateListener() {
        FileEventListener listener = new FileEventListener(){

            public void handleFileEvent(final FileManagerEvent evt) {
                switch (evt.getType()) {
                    case ADD_FILE: 
                    case REMOVE_FILE: {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            public void run() {
                                if (evt.getType() == FileManagerEvent.Type.ADD_FILE) {
                                    if (MySharedFilesResultPanel.this.shouldDisplayAddedFile(evt.getFileDescs()[0])) {
                                        MySharedFilesResultPanel.this.addFile(evt.getFileDescs()[0]);
                                    }
                                } else {
                                    MySharedFilesResultPanel.this.removeFile(evt.getFileDescs()[0]);
                                }
                                MySharedFilesResultPanel.this.refreshNumFiles();
                            }
                        });
                    }
                }
            }
        };
        GuiCoreMediator.getFileManager().addFileEventListener(listener);
        return listener;
    }

    private class UnshareFileAction
    extends AbstractAction {
        public UnshareFileAction(int num) {
            this.putValue("Name", I18n.trn("Stop Sharing File", "Stop Sharing Files", num));
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            int[] sel = MySharedFilesResultPanel.this.TABLE.getSelectedRows();
            final FileDesc[] files = new FileDesc[sel.length];
            for (i = 0; i < sel.length; ++i) {
                FileDesc fd;
                TableLine line = MySharedFilesResultPanel.this.getLine(sel[i]);
                SearchResult sr = (SearchResult)line.getInitializeObject();
                files[i] = fd = ((SharedSearchResult)sr).getFileDesc();
            }
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (int i = 0; i < files.length; ++i) {
                        FileDesc fd = files[i];
                        GuiCoreMediator.getFileManager().stopSharingFile(fd.getFile());
                    }
                }
            });
            for (i = files.length - 1; i >= 0; --i) {
                ((TableRowFilter)MySharedFilesResultPanel.this.DATA_MODEL).remove(sel[i]);
            }
            MySharedFilesResultPanel.this.refreshNumFiles();
        }
    }
}

