/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedMediaType
implements IconAndNameHolder,
Comparable<NamedMediaType> {
    private static final Map<String, NamedMediaType> CACHED_TYPES = new HashMap<String, NamedMediaType>();
    private final MediaType _mediaType;
    private final String _name;
    private final Icon _icon;
    private final LimeXMLSchema _schema;

    public NamedMediaType(MediaType mt, LimeXMLSchema schema) {
        if (mt == null) {
            throw new NullPointerException("Null media type.");
        }
        this._mediaType = mt;
        this._schema = schema;
        this._name = NamedMediaType.constructName(this._mediaType, this._schema);
        this._icon = this.getIcon(this._mediaType, this._schema);
    }

    @Override
    public int compareTo(NamedMediaType other) {
        return this._name.compareTo(other._name);
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Icon getIcon() {
        return this._icon;
    }

    public String toString() {
        return this._name;
    }

    public MediaType getMediaType() {
        return this._mediaType;
    }

    public LimeXMLSchema getSchema() {
        return this._schema;
    }

    public static NamedMediaType getFromDescription(String description) {
        NamedMediaType type = CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        MediaType mt = !MediaType.isDefaultType(description) ? new MediaType(description) : MediaType.getMediaTypeForSchema(description);
        return NamedMediaType.getFromMediaType(mt);
    }

    public static NamedMediaType getFromExtension(String extension) {
        MediaType mt = MediaType.getMediaTypeForExtension(extension);
        if (mt == null) {
            return null;
        }
        String description = mt.getMimeType();
        return NamedMediaType.getFromDescription(description);
    }

    public static List<NamedMediaType> getAllNamedMediaTypes() {
        LinkedList<NamedMediaType> allSchemas = new LinkedList<NamedMediaType>();
        for (LimeXMLSchema schema : GuiCoreMediator.getLimeXMLSchemaRepository().getAvailableSchemas()) {
            allSchemas.add(NamedMediaType.getFromSchema(schema));
        }
        MediaType[] allTypes = MediaType.getDefaultMediaTypes();
        for (int i = 0; i < allTypes.length; ++i) {
            if (NamedMediaType.containsMediaType(allSchemas, allTypes[i])) continue;
            allSchemas.add(NamedMediaType.getFromMediaType(allTypes[i]));
        }
        return allSchemas;
    }

    private static NamedMediaType getFromSchema(LimeXMLSchema schema) {
        String description = schema.getDescription();
        NamedMediaType type = CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        MediaType mt = !MediaType.isDefaultType(description) ? new MediaType(description) : MediaType.getMediaTypeForSchema(description);
        type = new NamedMediaType(mt, schema);
        CACHED_TYPES.put(description, type);
        return type;
    }

    public static NamedMediaType getFromMediaType(MediaType media) {
        String description = media.getMimeType();
        NamedMediaType type = CACHED_TYPES.get(description);
        if (type != null) {
            return type;
        }
        type = new NamedMediaType(media, null);
        CACHED_TYPES.put(description, type);
        return type;
    }

    private static boolean containsMediaType(List<? extends NamedMediaType> named, MediaType type) {
        for (NamedMediaType namedMediaType : named) {
            if (!namedMediaType.getMediaType().equals(type)) continue;
            return true;
        }
        return false;
    }

    private Icon getIcon(MediaType type, LimeXMLSchema schema) {
        ImageIcon icon;
        if (type == MediaType.getAnyTypeMediaType()) {
            icon = GUIMediator.getThemeImage("lime");
        } else {
            String location = GuiCoreMediator.getLimeXMLProperties().getXMLImagesResourcePath() + type.getMimeType();
            icon = GUIMediator.getImageFromResourcePath(location);
            if (icon == null) {
                return new GUIUtils.EmptyIcon(this.getName(), 16, 16);
            }
        }
        icon.setDescription(this.getName());
        return icon;
    }

    private static String constructName(MediaType type, LimeXMLSchema schema) {
        String name = null;
        if (type.isDefault()) {
            String key = type.getDescriptionKey();
            try {
                if (key != null) {
                    name = I18n.tr(key);
                }
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
            if (name == null) {
                name = type.getMimeType();
                name = name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
            }
        } else {
            name = XMLUtils.getTitleForSchema(schema);
        }
        return name;
    }
}

