/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.gui.search.PromotionSearchResultFactory;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.settings.ThirdPartySearchResultsSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.HashMap;
import java.util.Map;
import org.limewire.promotion.containers.PromotionMessageContainer;

final class PromotionMessageContainerToSearchResultConverter {
    private final PromotionSearchResultFactory creator;
    private final ApplicationServices applicationServices;

    PromotionMessageContainerToSearchResultConverter(LimeXMLDocumentFactory limeXMLDocumentFactory, ApplicationServices applicationServices) {
        this.creator = new PromotionSearchResultFactory(limeXMLDocumentFactory);
        this.applicationServices = applicationServices;
    }

    public SearchResult convert(PromotionMessageContainer container, String query) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PromotionSearchResultFactory.Attr.DISPLAY_URL.getValue(), container.getURL());
        props.put(PromotionSearchResultFactory.Attr.URL.getValue(), this.getURL(container));
        props.put(PromotionSearchResultFactory.Attr.NAME.getValue(), container.getDescription());
        Map<String, String> containerProps = container.getProperties();
        for (String key : containerProps.keySet()) {
            String val = containerProps.get(key);
            if (!this.isNormalProperty(key)) {
                key = "xml_" + key;
            }
            props.put(key, val);
        }
        return this.creator.newSearchResult(props, query);
    }

    private boolean isNormalProperty(String s) {
        for (PromotionSearchResultFactory.Attr attr : PromotionSearchResultFactory.Attr.values()) {
            if (!s.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }

    private String getURL(PromotionMessageContainer container) {
        String url = ThirdPartySearchResultsSettings.REDIRECT_URL.getValue();
        url = url + "?url=" + container.getURL();
        url = url + "&now=" + System.currentTimeMillis() / 1000L;
        url = url + "&id=" + container.getUniqueID();
        return LimeWireUtils.addLWInfoToUrl(url, this.applicationServices.getMyGUID());
    }
}

