/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.PromotionSearchResult;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PromotionSearchResultFactory {
    private static final Log LOG = LogFactory.getLog(PromotionSearchResultFactory.class);
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    PromotionSearchResultFactory(LimeXMLDocumentFactory limeXMLDocumentFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
    }

    public SearchResult newSearchResult(Map<String, String> nameValuePairs, String query) {
        String url = nameValuePairs.get(Attr.URL.getValue());
        int size = (int)this.getOrDefaultWithMax(nameValuePairs, Attr.SIZE.getValue(), -1L, Integer.MAX_VALUE);
        long creationTime = this.getOrDefaultWithMax(nameValuePairs, Attr.CREATION_TIME.getValue(), 0L, Long.MAX_VALUE);
        String vendor = nameValuePairs.get(Attr.VENDOR.getValue());
        String name = nameValuePairs.get(Attr.NAME.getValue());
        String fileType = nameValuePairs.get(Attr.FILE_TYPE.getValue());
        String xmlSchema = nameValuePairs.get(Attr.XML_SCHEMA.getValue());
        String displayUrl = nameValuePairs.get(Attr.DISPLAY_URL.getValue());
        if (xmlSchema == null) {
            xmlSchema = "audio";
        }
        Collection<NameValue<String>> xmlValues = this.xmlValuesIn(nameValuePairs, xmlSchema);
        SearchResult sr = this.newSearchResult(name, fileType, xmlSchema, url, size, creationTime, vendor, xmlValues, query, displayUrl);
        return name != null ? sr : null;
    }

    private Collection<NameValue<String>> xmlValuesIn(Map<String, String> allNameValues, String xmlSchema) {
        String plural = xmlSchema + "s";
        ArrayList<NameValue<String>> xmlValues = new ArrayList<NameValue<String>>();
        for (Map.Entry<String, String> entry : allNameValues.entrySet()) {
            if (!entry.getKey().startsWith("xml_")) continue;
            xmlValues.add(new NameValue<String>(plural + "__" + xmlSchema + "__" + entry.getKey().substring(4) + "__", entry.getValue()));
        }
        return xmlValues;
    }

    private SearchResult newSearchResult(String name, String fileType, String xmlSchema, String url, int size, long creationTime, String vendor, Collection<NameValue<String>> xmlValues, String keyword, String displayUrl) {
        LimeXMLDocument xmlDoc = null;
        if (xmlValues.size() > 0) {
            try {
                xmlDoc = this.limeXMLDocumentFactory.createLimeXMLDocument(xmlValues, "http://www.limewire.com/schemas/" + xmlSchema + ".xsd");
            }
            catch (IllegalArgumentException iae) {
                LOG.error("error creating document", iae);
            }
        }
        return new PromotionSearchResult(name, fileType, url, size, creationTime, xmlDoc, vendor, keyword, displayUrl);
    }

    private long getOrDefaultWithMax(Map<String, String> nameValuePairs, String attr, long def, long max) {
        String value = nameValuePairs.get(attr);
        if (value == null) {
            return def;
        }
        try {
            return Math.min(max, Long.parseLong(value));
        }
        catch (NumberFormatException ignored) {
            return def;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attr {
        DISPLAY_URL("displayUrl"),
        XML_SCHEMA("xmlSchema"),
        URL("url"),
        SIZE("size"),
        CREATION_TIME("creation_time"),
        VENDOR("vendor"),
        NAME("name"),
        FILE_TYPE("fileType");

        private final String value;

        private Attr(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

