/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;

class PropertyFilter
implements TableLineFilter {
    private final TableLineFilter FILTER;

    PropertyFilter(String property, Object value) {
        if (property == null) {
            throw new NullPointerException("null property");
        }
        if (value == null) {
            throw new NullPointerException("null value");
        }
        if (Selector.PropertyType.TYPE.getKey().equals(property)) {
            this.FILTER = new ExtensionFilter(value);
        } else if (Selector.PropertyType.SPEED.getKey().equals(property)) {
            this.FILTER = new SpeedFilter(value);
        } else if (Selector.PropertyType.VENDOR.getKey().equals(property)) {
            this.FILTER = new VendorFilter(value);
        } else {
            throw new IllegalArgumentException("bad property: " + property);
        }
    }

    public boolean allow(TableLine line) {
        return this.FILTER.allow(line);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PropertyFilter)) {
            return false;
        }
        return this.FILTER.equals(((PropertyFilter)o).FILTER);
    }

    private static class VendorFilter
    implements TableLineFilter {
        private final String VENDOR;

        VendorFilter(Object value) {
            this.VENDOR = (String)value;
        }

        public boolean allow(TableLine line) {
            return this.VENDOR.equals(line.getVendor());
        }

        public boolean equals(Object o) {
            if (!(o instanceof VendorFilter)) {
                return false;
            }
            return this.VENDOR.equals(((VendorFilter)o).VENDOR);
        }
    }

    private static class SpeedFilter
    implements TableLineFilter {
        private final ResultSpeed SPEED;

        SpeedFilter(Object value) {
            this.SPEED = (ResultSpeed)value;
        }

        public boolean allow(TableLine line) {
            return this.SPEED.isSameSpeed(line.getSpeed());
        }

        public boolean equals(Object o) {
            if (!(o instanceof SpeedFilter)) {
                return false;
            }
            return this.SPEED.isSameSpeed(((SpeedFilter)o).SPEED);
        }
    }

    private static class ExtensionFilter
    implements TableLineFilter {
        private final String TYPE;

        ExtensionFilter(Object value) {
            this.TYPE = ((IconAndNameHolder)value).getName();
        }

        public boolean allow(TableLine line) {
            return this.TYPE.equalsIgnoreCase(line.getExtension());
        }

        public boolean equals(Object o) {
            if (!(o instanceof ExtensionFilter)) {
                return false;
            }
            return this.TYPE.equals(((ExtensionFilter)o).TYPE);
        }
    }
}

