/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.FileDetailsProvider;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.LicenseWindow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.actions.ActionUtils;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.banner.Ad;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.MulticastTransferHandler;
import com.limegroup.gnutella.gui.search.CompositeFilter;
import com.limegroup.gnutella.gui.search.DateRenderer;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.EndpointRenderer;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.PercentageRenderer;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.QualityRenderer;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.ResultPanelTransferHandler;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.SearchButtons;
import com.limegroup.gnutella.gui.search.SearchColumnPreferenceHandler;
import com.limegroup.gnutella.gui.search.SearchColumnSelectionMenu;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultMenu;
import com.limegroup.gnutella.gui.search.SearchTableColumns;
import com.limegroup.gnutella.gui.search.SpamFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.search.TableRowFilter;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.PopupUtils;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.OverlayLayout;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalBorders;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultPanel
extends AbstractTableMediator<TableRowFilter, TableLine, SearchResult>
implements VerificationListener,
FileDetailsProvider {
    protected static final String SEARCH_TABLE = "SEARCH_TABLE";
    protected static final GUID STOPPED_GUID = new GUID(GUID.makeGuid());
    private static final DateRenderer DATE_RENDERER = new DateRenderer();
    private static final QualityRenderer QUALITY_RENDERER = new QualityRenderer();
    private static final EndpointRenderer ENDPOINT_RENDERER = new EndpointRenderer();
    private static final ResultSpeedRenderer RESULT_SPEED_RENDERER = new ResultSpeedRenderer();
    private static final PercentageRenderer PERCENTAGE_RENDERER = new PercentageRenderer();
    static final TableSettings SEARCH_SETTINGS = new TableSettings("SEARCH_TABLE");
    private final SearchInformation SEARCH_INFO;
    private final SpamFilter SPAM_FILTER;
    protected volatile GUID guid;
    private BrowseHostHandler browseHandler = null;
    private long startTime = System.currentTimeMillis();
    CompositeFilter FILTER;
    ActionListener DOWNLOAD_LISTENER;
    ActionListener DOWNLOAD_AS_LISTENER;
    ActionListener CHAT_LISTENER;
    ActionListener BROWSE_HOST_LISTENER;
    ActionListener STOP_LISTENER;
    ActionListener MARK_AS_SPAM_LISTENER;
    ActionListener PROPERTIES_LISTENER;
    ActionListener MARK_AS_NOT_SPAM_LISTENER;
    private JButton SPAM_BUTTON;
    protected Box SOUTH_PANEL;
    private MouseInputListener ACTION_HIGHLIGHT_LISTENER;
    @InspectablePrimitive(value="spam button clicks")
    private static volatile int spamClicks;
    @InspectionPoint(value="sortedResultColumns")
    private static final InspectionHistogram<String> sortedResultColumns;

    ResultPanel(JPanel overlay) {
        super(SEARCH_TABLE);
        this.setupFakeTable(overlay);
        this.SEARCH_INFO = SearchInformation.createKeywordSearch("", null, MediaType.getAnyTypeMediaType());
        this.SPAM_FILTER = null;
        this.FILTER = null;
        this.guid = STOPPED_GUID;
        this.setButtonEnabled(2, false);
        this.TABLE.setDragEnabled(false);
        this.TABLE.setTransferHandler(null);
        this.SOUTH_PANEL.setVisible(false);
    }

    ResultPanel(String title, String id) {
        super(id);
        this.SPAM_FILTER = null;
        this.SEARCH_INFO = SearchInformation.createKeywordSearch(title, null, MediaType.getAnyTypeMediaType());
        this.guid = STOPPED_GUID;
    }

    ResultPanel(GUID guid, SearchInformation info) {
        super(SEARCH_TABLE);
        this.SEARCH_INFO = info;
        this.SPAM_FILTER = this.SEARCH_INFO.isBrowseHostSearch() || this.SEARCH_INFO.isWhatsNewSearch() ? null : new SpamFilter();
        this.guid = guid;
        this.setupRealTable();
        this.resetFilters();
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(QualityHolder.class, QUALITY_RENDERER);
        this.TABLE.setDefaultRenderer(EndpointHolder.class, ENDPOINT_RENDERER);
        this.TABLE.setDefaultRenderer(ResultSpeed.class, RESULT_SPEED_RENDERER);
        this.TABLE.setDefaultRenderer(Date.class, DATE_RENDERER);
        this.TABLE.setDefaultRenderer(Float.class, PERCENTAGE_RENDERER);
        this.TABLE.setDefaultRenderer(ResultNameHolder.class, LINK_RENDERER);
    }

    @Override
    protected void updateSplashScreen() {
    }

    protected void setupDataModel() {
        this.DATA_MODEL = new TableRowFilter(this.FILTER);
    }

    @Override
    protected void setupConstants() {
        this.FILTER = new CompositeFilter(4);
        this.MAIN_PANEL = new PPP();
        this.setupDataModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL){

            protected Color getEvenRowColor(int row) {
                return ResultPanel.this.getLine(row).getEvenRowColor();
            }

            protected Color getOddRowColor(int row) {
                return ResultPanel.this.getLine(row).getOddRowColor();
            }
        };
        ((ResultPanelModel)this.DATA_MODEL).setTable(this.TABLE);
        this.BUTTON_ROW = new SearchButtons(this).getComponent();
        this.SPAM_BUTTON = new IconButton(I18n.tr("Not Junk"), "SEARCH_SPAM");
        this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
        this.SPAM_BUTTON.setEnabled(false);
        this.SPAM_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableLine[] lines = ResultPanel.this.getAllSelectedLines();
                if (lines.length > 0) {
                    spamClicks++;
                    if (SpamFilter.isAboveSpamThreshold(lines[0])) {
                        ResultPanel.this.MARK_AS_NOT_SPAM_LISTENER.actionPerformed(e);
                    } else {
                        ResultPanel.this.MARK_AS_SPAM_LISTENER.actionPerformed(e);
                    }
                }
            }
        });
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new MulticastTransferHandler(new ResultPanelTransferHandler(this), DNDUtils.DEFAULT_TRANSFER_HANDLERS));
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = SEARCH_SETTINGS;
    }

    @Override
    protected JPopupMenu createColumnSelectionMenu() {
        return new SearchColumnSelectionMenu(this.TABLE).getComponent();
    }

    @Override
    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new SearchColumnPreferenceHandler(this.TABLE);
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addMouseMotionListener(this.ACTION_HIGHLIGHT_LISTENER);
        this.TABLE.addMouseListener(this.ACTION_HIGHLIGHT_LISTENER);
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.ACTION_HIGHLIGHT_LISTENER = new MouseInputAdapter(){
            private final Cursor DEFAULT = Cursor.getDefaultCursor();
            private final Cursor HAND = Cursor.getPredefinedCursor(12);
            private Cursor lastCursor = Cursor.getDefaultCursor();
            private boolean isCurrentlyHand;

            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                int column = ResultPanel.this.TABLE.columnAtPoint(p);
                int colModel = ResultPanel.this.TABLE.convertColumnIndexToModel(column);
                if (colModel == 4) {
                    int row = ResultPanel.this.TABLE.rowAtPoint(p);
                    TableLine line = (TableLine)((TableRowFilter)ResultPanel.this.DATA_MODEL).get(row);
                    if (line != null && line.isLink()) {
                        if (this.lastCursor != this.HAND) {
                            this.lastCursor = this.HAND;
                            ResultPanel.this.TABLE.getTopLevelAncestor().setCursor(this.HAND);
                            this.isCurrentlyHand = true;
                        }
                        return;
                    }
                }
                if (this.lastCursor != this.DEFAULT) {
                    this.isCurrentlyHand = false;
                    this.lastCursor = this.DEFAULT;
                    ResultPanel.this.TABLE.getTopLevelAncestor().setCursor(this.DEFAULT);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (this.lastCursor != this.DEFAULT) {
                    this.isCurrentlyHand = false;
                    this.lastCursor = this.DEFAULT;
                    ResultPanel.this.TABLE.getTopLevelAncestor().setCursor(this.DEFAULT);
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (this.isCurrentlyHand) {
                    Point p = e.getPoint();
                    int column = ResultPanel.this.TABLE.columnAtPoint(p);
                    int colModel = ResultPanel.this.TABLE.convertColumnIndexToModel(column);
                    if (colModel == 4) {
                        int row = ResultPanel.this.TABLE.rowAtPoint(p);
                        TableLine line = (TableLine)((TableRowFilter)ResultPanel.this.DATA_MODEL).get(row);
                        if (line != null && line.isLink()) {
                            SearchMediator.downloadFromPanel(ResultPanel.this, line);
                        }
                    }
                }
            }
        };
        this.DOWNLOAD_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.doDownload(ResultPanel.this);
            }
        };
        this.DOWNLOAD_AS_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.doDownloadAs(ResultPanel.this);
            }
        };
        this.CHAT_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.doChat();
            }
        };
        this.BROWSE_HOST_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.doBrowseHost(ResultPanel.this);
            }
        };
        this.STOP_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResultPanel.this.stopSearch();
            }
        };
        this.PROPERTIES_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchMediator.showProperties(ResultPanel.this);
            }
        };
        this.MARK_AS_SPAM_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableLine[] lines = ResultPanel.this.getAllSelectedLines();
                for (int i = 0; i < lines.length; ++i) {
                    ResultPanel.this.SPAM_FILTER.markAsSpamUser(lines[i], true);
                }
                if (SearchSettings.hideJunk()) {
                    ResultPanel.this.filtersChanged();
                } else {
                    ((TableRowFilter)ResultPanel.this.DATA_MODEL).refresh();
                    ResultPanel.this.transformSpamButton(I18n.tr("Not Junk"), I18n.tr("Mark selected search results as Not Junk"));
                }
            }
        };
        this.MARK_AS_NOT_SPAM_LISTENER = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableLine[] lines = ResultPanel.this.getAllSelectedLines();
                for (int i = 0; i < lines.length; ++i) {
                    ResultPanel.this.SPAM_FILTER.markAsSpamUser(lines[i], false);
                }
                ((TableRowFilter)ResultPanel.this.DATA_MODEL).refresh();
                ResultPanel.this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
            }
        };
    }

    @Override
    public JPopupMenu createPopupMenu() {
        return this.createPopupMenu(this.getAllSelectedLines());
    }

    protected JPopupMenu createPopupMenu(TableLine[] lines) {
        if (!this.isKillable()) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.createSearchAgainMenu(lines.length > 0 ? lines[0] : null));
        menu.addSeparator();
        PopupUtils.addMenuItem(SearchMediator.STOP_STRING, this.STOP_LISTENER, menu, !this.isStopped());
        PopupUtils.addMenuItem(SearchMediator.KILL_STRING, (ActionListener)new CancelListener(), menu, this.isKillable());
        boolean allSpam = true;
        boolean allNot = true;
        if (this.SPAM_FILTER != null) {
            for (int i = 0; i < lines.length; ++i) {
                if (!SpamFilter.isAboveSpamThreshold(lines[i])) {
                    allSpam = false;
                    continue;
                }
                allNot = false;
            }
        }
        return new SearchResultMenu(this).addToMenu(menu, lines, !allSpam, !allNot);
    }

    protected final JMenu createSearchAgainMenu(TableLine line) {
        LimeXMLDocument doc;
        JMenu menu = new JMenu(I18n.tr("Search More"));
        menu.add(new JMenuItem(new RepeatSearchAction()));
        menu.add(new JMenuItem(new RepeatSearchNoClearAction()));
        if (line == null) {
            menu.setEnabled(this.isRepeatSearchEnabled());
            return menu;
        }
        menu.addSeparator();
        String keywords = QueryUtils.createQueryString(line.getFilename());
        SearchInformation info = SearchInformation.createKeywordSearch(keywords, null, MediaType.getAnyTypeMediaType());
        if (SearchMediator.validateInfo(info) == 0) {
            menu.add(new JMenuItem(new SearchAction(info, I18nMarker.marktr("Search for Keywords: {0}"))));
        }
        if ((doc = line.getXMLDocument()) != null) {
            Action[] actions = ActionUtils.createSearchActions(doc);
            for (int i = 0; i < actions.length; ++i) {
                menu.add(new JMenuItem(actions[i]));
            }
        }
        return menu;
    }

    @Override
    public void removeSelection() {
    }

    @Override
    public void clearTable() {
        super.clearTable();
    }

    @Override
    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.SPAM_BUTTON.setEnabled(false);
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_FILTER != null) {
            this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
        }
    }

    @Override
    public void handleSelection(int i) {
        this.setButtonEnabled(0, true);
        TableLine line = (TableLine)((TableRowFilter)this.DATA_MODEL).get(i);
        this.setButtonEnabled(1, line.isBrowseHostEnabled());
        if (line.isLink()) {
            this.SPAM_BUTTON.setEnabled(false);
        } else if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_FILTER != null) {
            this.SPAM_BUTTON.setEnabled(true);
            if (SpamFilter.isAboveSpamThreshold(line)) {
                this.transformSpamButton(I18n.tr("Not Junk"), I18n.tr("Mark selected search results as Not Junk"));
            } else {
                this.transformSpamButton(I18n.tr("Junk"), I18n.tr("Mark selected search results as Junk"));
            }
        }
    }

    @Override
    public void handleActionKey() {
        this.DOWNLOAD_LISTENER.actionPerformed(null);
    }

    SearchInformation getSearchInformation() {
        return this.SEARCH_INFO;
    }

    String getQuery() {
        return this.SEARCH_INFO.getQuery();
    }

    String getTitle() {
        return this.SEARCH_INFO.getTitle();
    }

    String getRichQuery() {
        return this.SEARCH_INFO.getXML();
    }

    void stopSearch() {
        final GUID guidToStop = this.guid;
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                GuiCoreMediator.getSearchServices().stopQuery(guidToStop);
            }
        });
        this.setGUID(STOPPED_GUID);
        SearchMediator.checkToStopLime();
        this.setButtonEnabled(2, false);
    }

    void doChat() {
        TableLine line = this.getSelectedLine();
        if (line == null) {
            return;
        }
        if (!line.isChatEnabled()) {
            return;
        }
        line.doChat();
    }

    void blockHost() {
        TableLine[] lines = this.getAllSelectedLines();
        HashSet<String> uniqueHosts = new HashSet<String>();
        for (TableLine line : lines) {
            uniqueHosts.add(line.getHostname());
            for (SearchResult result : line.getOtherResults()) {
                uniqueHosts.add(result.getHost());
            }
        }
        int answer = GUIMediator.showConfirmListMessage(I18n.tr("Do you want to block search results from the following list of hosts?"), uniqueHosts.toArray(), 0, null);
        if (answer == 0) {
            String[] bannedIps = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
            uniqueHosts.addAll(Arrays.asList(bannedIps));
            FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue(uniqueHosts.toArray(new String[uniqueHosts.size()]));
            GuiCoreMediator.getSpamServices().reloadIPFilter();
        }
    }

    void showLicense() {
        TableLine line = this.getSelectedLine();
        if (line == null) {
            return;
        }
        URN urn = line.getSHA1Urn();
        LimeXMLDocument doc = line.getXMLDocument();
        LicenseWindow window = LicenseWindow.create(line.getLicense(), urn, doc, this);
        GUIUtils.centerOnScreen(window);
        window.setVisible(true);
    }

    @Override
    public void licenseVerified(License license) {
        if (license.isValid(null)) {
            ((ResultPanelModel)this.DATA_MODEL).slowRefresh();
        }
    }

    boolean isStopped() {
        return this.guid.equals(STOPPED_GUID);
    }

    boolean isEmpty() {
        return ((TableRowFilter)this.DATA_MODEL).getRowCount() == 0;
    }

    boolean isKillable() {
        return this.FILTER != null;
    }

    boolean filterChanged(TableLineFilter filter, int depth) {
        int i;
        if (!this.FILTER.setFilter(depth, filter)) {
            return false;
        }
        int[] rows = this.TABLE.getSelectedRows();
        TableLine[] lines = new TableLine[rows.length];
        LinkedList<TableLine> inView = new LinkedList<TableLine>();
        for (i = 0; i < rows.length; ++i) {
            TableLine line;
            int row = rows[i];
            lines[i] = line = (TableLine)((TableRowFilter)this.DATA_MODEL).get(row);
            if (!this.TABLE.isRowVisible(row)) continue;
            inView.add(line);
        }
        ((TableRowFilter)this.DATA_MODEL).filtersChanged();
        for (i = 0; i < rows.length; ++i) {
            TableLine line = lines[i];
            int row = ((TableRowFilter)this.DATA_MODEL).getRow(line);
            if (row == -1) continue;
            this.TABLE.addRowSelectionInterval(row, row);
            if (inView == null || !inView.contains(line)) continue;
            this.TABLE.ensureRowVisible(row);
            inView = null;
        }
        SearchMediator.setTabDisplayCount(this);
        return true;
    }

    int totalSources() {
        return ((ResultPanelModel)this.DATA_MODEL).getTotalSources();
    }

    int filteredSources() {
        return ((TableRowFilter)this.DATA_MODEL).getFilteredSources();
    }

    boolean isRepeatSearchEnabled() {
        return this.FILTER != null;
    }

    void repeatSearch() {
        this.repeatSearch(true);
    }

    void repeatSearch(boolean clearTable) {
        if (clearTable) {
            this.clearTable();
            this.resetFilters();
        }
        this.startTime = System.currentTimeMillis();
        SearchMediator.setTabDisplayCount(this);
        SearchMediator.repeatSearch(this, this.SEARCH_INFO, clearTable);
        this.setButtonEnabled(2, true);
    }

    void resetFilters() {
        this.FILTER.reset();
        if (!this.SEARCH_INFO.isBrowseHostSearch() && !this.SEARCH_INFO.isWhatsNewSearch()) {
            ((TableRowFilter)this.DATA_MODEL).setJunkFilter(this.SPAM_FILTER);
        } else {
            ((TableRowFilter)this.DATA_MODEL).setJunkFilter(null);
        }
    }

    private void filtersChanged() {
        ((TableRowFilter)this.DATA_MODEL).filtersChanged();
        SearchMediator.setTabDisplayCount(this);
    }

    MetadataModel getMetadataModel() {
        return ((ResultPanelModel)this.DATA_MODEL).getMetadataModel();
    }

    boolean matches(GUID otherGuid) {
        return this.guid.equals(otherGuid);
    }

    void setGUID(GUID guid) {
        this.guid = guid;
    }

    byte[] getGUID() {
        return this.guid.bytes();
    }

    MediaType getMediaType() {
        return this.SEARCH_INFO.getMediaType();
    }

    void setBrowseHostHandler(BrowseHostHandler bhh) {
        this.browseHandler = bhh;
    }

    TableLine[] getAllSelectedLines() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows == null) {
            return new TableLine[0];
        }
        TableLine[] lines = new TableLine[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            lines[i] = (TableLine)((TableRowFilter)this.DATA_MODEL).get(rows[i]);
        }
        return lines;
    }

    TableLine getSelectedLine() {
        int selected = this.TABLE.getSelectedRow();
        if (selected != -1) {
            return (TableLine)((TableRowFilter)this.DATA_MODEL).get(selected);
        }
        return null;
    }

    final TableLine getLine(int index) {
        return (TableLine)((TableRowFilter)this.DATA_MODEL).get(index);
    }

    double calculatePercentage(long currentTime) {
        if (this.guid.equals(STOPPED_GUID)) {
            return 1.0;
        }
        if (this.SEARCH_INFO.isBrowseHostSearch()) {
            if (this.browseHandler != null) {
                return this.browseHandler.getPercentComplete(currentTime);
            }
            return 0.0;
        }
        int ideal = 150;
        double resultPerc = (double)this.totalSources() / (double)ideal;
        long spent = currentTime - this.startTime;
        double timePerc = (double)spent / 200000.0;
        if (resultPerc >= 1.0) {
            return 1.0;
        }
        return resultPerc + (timePerc *= 1.0 - resultPerc);
    }

    private void setupRealTable() {
        SearchTableColumns columns = ((ResultPanelModel)this.DATA_MODEL).getColumns();
        LimeTableColumn countColumn = columns.getColumn(1);
        if (this.SETTINGS.REAL_TIME_SORT.getValue() && this.TABLE.isColumnVisible(countColumn.getId())) {
            ((TableRowFilter)this.DATA_MODEL).sort(1);
            ((TableRowFilter)this.DATA_MODEL).sort(1);
        }
        MouseListener filterDisplayer = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                e.consume();
                SearchMediator.panelSelected(ResultPanel.this);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        };
        this.MAIN_PANEL.addMouseListener(filterDisplayer);
        this.SCROLL_PANE.addMouseListener(filterDisplayer);
        this.TABLE.addMouseListener(filterDisplayer);
        this.TABLE.getTableHeader().addMouseListener(filterDisplayer);
    }

    protected void setupMainPanelBase() {
        if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            this.addButtonRow();
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        } else {
            super.setupMainPanel();
        }
    }

    @Override
    protected void setupMainPanel() {
        this.MAIN_PANEL.add(this.createSecurityWarning());
        this.setupMainPanelBase();
    }

    private JComponent createSecurityWarning() {
        Ad ad = SearchMediator.getAd();
        String wholeWarning = ad.getText();
        String warningOne = "Only search results with a";
        String warningTwo = "are official LimeWire communications.";
        int lockIdx = wholeWarning.indexOf("{0}");
        if (lockIdx != -1) {
            warningOne = wholeWarning.substring(0, lockIdx - 1);
            warningTwo = wholeWarning.substring(lockIdx + 4);
        }
        String moreInfo = I18n.tr("More Info...");
        JPanel jp = this.createWarningDitherPanel();
        jp.setLayout(new FlowLayout(0, 3, 3));
        jp.add(new JLabel(GUIMediator.getThemeImage("warn-triangle")));
        jp.add(new JLabel("<html><font color=\"#7B5100\"><b>" + warningOne + "</b></font></html>"));
        jp.add(new JLabel(GUIMediator.getThemeImage("limehires")));
        jp.add(new JLabel("<html><font color=\"#7B5100\"><b>" + warningTwo + "</b></font></html>"));
        jp.add(Box.createHorizontalStrut(2));
        URLLabel urlLabel = new URLLabel(LimeWireUtils.addLWInfoToUrl(ad.getURI(), GuiCoreMediator.getApplicationServices().getMyGUID()), "<b>" + moreInfo + "</b>");
        urlLabel.setColor(new Color(172, 113, 0));
        jp.add(urlLabel);
        Dimension ps = jp.getPreferredSize();
        ps.width = Short.MAX_VALUE;
        jp.setMaximumSize(ps);
        return jp;
    }

    protected JPanel createWarningDitherPanel() {
        return new DitherPanel(new Ditherer(6, new Color(255, 209, 86), new Color(255, 183, 44))){

            public void updateUI() {
                super.updateUI();
                Border border = UIManager.getBorder("ScrollPane.border");
                if (border != null && border.getClass() == MetalBorders.ScrollPaneBorder.class) {
                    this.setBorder(new WarningBorder(UIManager.getColor("SplitPane.darkShadow"), 1));
                } else if (OSUtils.isMacOSX()) {
                    this.setBorder(new WarningBorder(Color.lightGray, 0));
                } else {
                    this.setBorder(new WarningBorder(UIManager.getColor("TextField.darkShadow"), 0));
                }
            }
        };
    }

    private void setupFakeTable(JPanel overlay) {
        this.MAIN_PANEL.removeAll();
        JPanel background = new JPanel();
        background.setLayout(new OverlayLayout(background));
        BoxPanel overlayPanel = new BoxPanel(1);
        overlayPanel.setOpaque(false);
        overlayPanel.add(Box.createVerticalStrut(20));
        overlayPanel.add(overlay);
        overlayPanel.setMinimumSize(new Dimension(0, 0));
        JComponent table = this.getScrolledTablePane();
        table.setOpaque(false);
        background.add(overlayPanel);
        background.add(table);
        this.MAIN_PANEL.add(background);
        this.addButtonRow();
        this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
    }

    private void addButtonRow() {
        if (this.BUTTON_ROW != null) {
            this.SOUTH_PANEL = Box.createVerticalBox();
            this.SOUTH_PANEL.setOpaque(false);
            this.SOUTH_PANEL.add(Box.createVerticalStrut(6));
            if (SearchSettings.ENABLE_SPAM_FILTER.getValue() && this.SPAM_BUTTON != null) {
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new GridBagLayout());
                GridBagConstraints gbc = null;
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 10;
                gbc.fill = 0;
                gbc.gridwidth = -1;
                gbc.weightx = 1.0;
                buttonPanel.add((Component)this.BUTTON_ROW, gbc);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.anchor = 13;
                gbc.fill = 0;
                gbc.gridwidth = 0;
                buttonPanel.add((Component)this.SPAM_BUTTON, gbc);
                buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 64));
                this.SOUTH_PANEL.add(buttonPanel);
            } else {
                this.SOUTH_PANEL.add(this.BUTTON_ROW);
            }
            this.MAIN_PANEL.add(this.SOUTH_PANEL);
        }
    }

    @Override
    public FileDetails[] getFileDetails() {
        int[] sel = this.TABLE.getSelectedRows();
        ArrayList<RemoteFileDesc> list = new ArrayList<RemoteFileDesc>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            TableLine line = (TableLine)((TableRowFilter)this.DATA_MODEL).get(sel[i]);
            RemoteFileDesc rfd = line.getNonFirewalledRFD();
            if (rfd != null) {
                list.add(rfd);
                continue;
            }
            rfd = line.getRemoteFileDesc();
            if (rfd == null) continue;
            list.add(rfd);
        }
        if (list.isEmpty()) {
            return new FileDetails[0];
        }
        return list.toArray(new FileDetails[0]);
    }

    public void cleanup() {
    }

    @Override
    protected void sortAndMaintainSelection(int columnToSort) {
        if (columnToSort != -1) {
            LimeTableColumn column = ((TableRowFilter)this.DATA_MODEL).getTableColumn(columnToSort);
            sortedResultColumns.count(column.getId());
        }
        super.sortAndMaintainSelection(columnToSort);
    }

    private void transformSpamButton(String text, String tip) {
        Dimension oldDim = this.SPAM_BUTTON.getPreferredSize();
        this.SPAM_BUTTON.setText(text);
        this.SPAM_BUTTON.setToolTipText(tip);
        Dimension newDim = this.SPAM_BUTTON.getPreferredSize();
        newDim.width = Math.max(oldDim.width, newDim.width);
        this.SPAM_BUTTON.setPreferredSize(newDim);
    }

    static {
        sortedResultColumns = new InspectionHistogram();
    }

    protected final class CancelListener
    extends AbstractAction {
        protected CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchMediator.killSearch();
        }
    }

    private final class RepeatSearchNoClearAction
    extends AbstractAction {
        public RepeatSearchNoClearAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_NO_CLEAR_STRING);
            this.setEnabled(ResultPanel.this.isRepeatSearchEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            ResultPanel.this.repeatSearch(false);
        }
    }

    private final class RepeatSearchAction
    extends AbstractAction {
        public RepeatSearchAction() {
            this.putValue("Name", SearchMediator.REPEAT_SEARCH_STRING);
            this.setEnabled(ResultPanel.this.isRepeatSearchEnabled());
        }

        public void actionPerformed(ActionEvent e) {
            ResultPanel.this.repeatSearch(true);
        }
    }

    public class WarningBorder
    extends AbstractBorder {
        private Color lineColor;
        private int offset;

        public WarningBorder(Color lineColor, int offset) {
            this.lineColor = lineColor;
            this.offset = offset;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.lineColor);
            g.drawLine(x, y, x + width - 1 - this.offset, y);
            g.drawLine(x, y, x, y + height);
            g.drawLine(x + width - 1 - this.offset, y, x + width - 1 - this.offset, y + height);
            if (this.offset > 0) {
                g.setColor(c.getParent().getBackground());
                for (int i = 0; i < this.offset; ++i) {
                    g.drawLine(x + width - 1 - i, y, x + width - 1 - i, y + height);
                }
            }
            g.setColor(oldColor);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 0, 1 + this.offset);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class PPP
    extends PaddedPanel
    implements ProgTabUIFactory.Progressor {
        private PPP() {
        }

        public double calculatePercentage(long now) {
            return ResultPanel.this.calculatePercentage(now);
        }
    }
}

