/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.KeyProcessingTextField;
import com.limegroup.gnutella.gui.MySharedFilesButton;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SchemaBox;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.xml.InputPanel;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchInputPanel
extends JPanel {
    private final JLabel WHATSNEW_SEARCH_LABEL = new JLabel();
    private final JLabel SEARCH_TYPE_LABEL = new JLabel();
    private final SearchField SEARCH_FIELD = new SearchField(14);
    private final JTextArea IP_TEXT = new JTextArea();
    private final AutoCompleteTextField BROWSE_HOST_FIELD = new ClearableAutoCompleteTextField();
    private final JButton WHATSNEW = new JButton(I18n.tr("What's New"));
    private final JTabbedPane PANE = new JTabbedPane(3);
    private final CardLayout META_CARDS = new CardLayout();
    private final JPanel META_PANEL = new JPanel(this.META_CARDS);
    private static final String DEFAULT_PANEL_KEY = "defaultPanel";
    private final SchemaBox SCHEMA_BOX = new SchemaBox();
    private final Ditherer DITHERER = new Ditherer(62, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
    private JPanel searchEntry;
    private final ActionListener SEARCH_LISTENER = new SearchListener();
    private Set<String> inputPanelKeys = null;
    private Map<NamedMediaType, Dimension> inputPanelDimensions = new HashMap<NamedMediaType, Dimension>();
    private final NetworkManager networkManager;
    private final NetworkInstanceUtils networkInstanceUtils;
    @InspectionPoint(value="whatsNewByType")
    private static final InspectionHistogram<String> whatsNewSearches = new InspectionHistogram();
    @InspectionPoint(value="searchByType")
    private static final InspectionHistogram<String> regularSearches = new InspectionHistogram();
    @InspectionPoint(value="numberOfXMLFields")
    private static final InspectionHistogram<Integer> numberOfXmlFields = new InspectionHistogram();

    SearchInputPanel(NetworkManager networkManager, NetworkInstanceUtils networkInstanceUtils) {
        super(new BorderLayout(0, 5));
        this.networkManager = networkManager;
        this.networkInstanceUtils = networkInstanceUtils;
        SchemaListener schemaListener = new SchemaListener();
        this.SCHEMA_BOX.addSelectionListener(schemaListener);
        this.add((Component)this.SCHEMA_BOX, "North");
        this.searchEntry = this.createSearchEntryPanel();
        JPanel whatsnew = this.createWhatIsNewPanel();
        JPanel browseHost = this.createBrowseHostPanel();
        this.panelize(this.searchEntry);
        this.panelize(whatsnew);
        this.panelize(browseHost);
        this.PANE.add(I18n.tr("Keyword"), this.searchEntry);
        this.PANE.add(I18n.tr("What's New"), whatsnew);
        this.PANE.add(I18n.tr("Direct Connect"), browseHost);
        this.PANE.setRequestFocusEnabled(false);
        this.PANE.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                SearchInputPanel.this.requestSearchFocusImmediately();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        if (!ThemeSettings.isNativeTheme()) {
            this.PANE.setBorder(new LineBorder(ThemeFileHandler.SEARCH_GRID_COLOR.getValue()){

                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    try {
                        Component sel = SearchInputPanel.this.PANE.getSelectedComponent();
                        if (sel != null) {
                            height = sel.getBounds().height + 4;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        // empty catch block
                    }
                    super.paintBorder(c, g, x, y, width, height);
                }
            });
        }
        this.add((Component)this.PANE, "Center");
        BoxPanel viewSharedFilesPanel = new BoxPanel(0);
        viewSharedFilesPanel.add(new JLabel(GUIMediator.getThemeImage("shared_folder")));
        viewSharedFilesPanel.add(Box.createHorizontalStrut(5));
        viewSharedFilesPanel.add(new MySharedFilesButton());
        viewSharedFilesPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 0));
        this.add((Component)viewSharedFilesPanel, "South");
        this.WHATSNEW_SEARCH_LABEL.setFont(UIManager.getFont("Table.font.bold"));
        Font bold = UIManager.getFont("Table.font.bold");
        Font bolder = new Font(bold.getName(), bold.getStyle(), bold.getSize() + 5);
        this.SEARCH_TYPE_LABEL.setFont(bolder);
        this.SEARCH_TYPE_LABEL.setPreferredSize(new Dimension(100, 20));
        schemaListener.actionPerformed(null);
    }

    KeyProcessingTextField getForwardingSearchField() {
        if (this.isNormalSearchType()) {
            if (this.SCHEMA_BOX.getSelectedSchema() != null) {
                return this.getInputPanel().getFirstTextField();
            }
            return this.SEARCH_FIELD;
        }
        if (this.isBrowseHostSearchType()) {
            return this.BROWSE_HOST_FIELD;
        }
        return null;
    }

    boolean isKeyEventForwardable() {
        return this.isNormalSearchType() || this.isBrowseHostSearchType();
    }

    boolean isBrowseHostSearchType() {
        return this.PANE.getSelectedIndex() == 2;
    }

    boolean isWhatIsNewSearchType() {
        return this.PANE.getSelectedIndex() == 1;
    }

    boolean isNormalSearchType() {
        return this.PANE.getSelectedIndex() == 0;
    }

    void addressChanged() {
        this.updateIpText();
        this.invalidate();
        this.revalidate();
    }

    void requestSearchFocusImmediately() {
        if (this.isNormalSearchType()) {
            if (this.SCHEMA_BOX.getSelectedSchema() != null) {
                this.getInputPanel().requestFirstFocus();
            } else {
                this.SEARCH_FIELD.requestFocus();
            }
        } else if (this.isWhatIsNewSearchType()) {
            this.WHATSNEW.requestFocus();
        } else if (this.isBrowseHostSearchType()) {
            this.BROWSE_HOST_FIELD.requestFocus();
        }
    }

    void requestSearchFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchInputPanel.this.requestSearchFocusImmediately();
            }
        });
    }

    private void panelize(JComponent c) {
        GUIUtils.setOpaque(false, c);
        if (!ThemeSettings.isNativeTheme()) {
            c.setOpaque(true);
        }
        c.setBackground(ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        c.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
    }

    private JPanel createBrowseHostPanel() {
        this.BROWSE_HOST_FIELD.addActionListener(this.SEARCH_LISTENER);
        DitherPanel panel = new DitherPanel(this.DITHERER);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        JLabel label = new JLabel(I18n.tr("Got Friends?"));
        label.setFont(UIManager.getFont("Table.font.bold"));
        panel.add((Component)label, c);
        JTextArea text1 = new JTextArea(I18n.tr("Enter the IP address and port number (i.e. ip:port) of a friend you'd like to connect to, click 'Direct Connect', and LimeWire will try to browse that user's shared files."));
        text1.setLineWrap(true);
        text1.setWrapStyleWord(true);
        text1.setColumns(15);
        text1.setEditable(false);
        text1.setFont(UIManager.getFont("Table.font"));
        text1.setForeground(label.getForeground());
        c.insets = new Insets(15, 0, 0, 0);
        panel.add((Component)text1, c);
        this.updateIpText();
        this.IP_TEXT.setLineWrap(true);
        this.IP_TEXT.setWrapStyleWord(true);
        this.IP_TEXT.setColumns(15);
        this.IP_TEXT.setEditable(false);
        this.IP_TEXT.setFont(UIManager.getFont("Table.font"));
        this.IP_TEXT.setForeground(label.getForeground());
        panel.add((Component)this.IP_TEXT, c);
        c.fill = 2;
        panel.add((Component)this.BROWSE_HOST_FIELD, c);
        JButton search = new JButton(I18n.tr("Direct Connect"));
        search.addActionListener(this.SEARCH_LISTENER);
        c.fill = 0;
        panel.add((Component)search, c);
        c.weighty = 1.0;
        panel.add(Box.createVerticalGlue(), c);
        return panel;
    }

    private void updateIpText() {
        if (this.networkManager.acceptedIncomingConnection() && !this.networkInstanceUtils.isPrivate()) {
            this.IP_TEXT.setText(I18n.tr("When your friends want to connect to you, they should enter") + " \"" + NetworkUtils.ip2string(this.networkManager.getAddress()) + ":" + this.networkManager.getPort() + "\"");
        } else {
            this.IP_TEXT.setText(I18n.tr("Your computer is behind a firewall or router and cannot receive direct connections."));
        }
    }

    private JPanel createWhatIsNewPanel() {
        DitherPanel panel = new DitherPanel(this.DITHERER);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        JLabel label = new JLabel(I18n.tr("Don't Know"));
        label.setFont(UIManager.getFont("Table.font.bold"));
        panel.add((Component)label, c);
        JLabel label2 = new JLabel(I18n.tr("What To Look For?"));
        label2.setFont(UIManager.getFont("Table.font.bold"));
        panel.add((Component)label2, c);
        JTextArea text = new JTextArea(I18n.tr("A \"What's New\" search will search for files that have been recently added to the network."));
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        text.setColumns(15);
        text.setEditable(false);
        text.setFont(UIManager.getFont("Table.font"));
        text.setForeground(label.getForeground());
        c.insets = new Insets(15, 0, 30, 0);
        panel.add((Component)text, c);
        JTextArea type = new JTextArea(I18n.tr("Current Search:") + "  ");
        type.setFont(UIManager.getFont("Table.font"));
        type.setEditable(false);
        type.setForeground(label.getForeground());
        c.anchor = 13;
        c.gridwidth = -1;
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)type, c);
        c.anchor = 17;
        c.gridwidth = 0;
        panel.add((Component)this.WHATSNEW_SEARCH_LABEL, c);
        this.WHATSNEW.addActionListener(this.SEARCH_LISTENER);
        c.insets = new Insets(5, 0, 30, 0);
        c.anchor = 10;
        panel.add((Component)this.WHATSNEW, c);
        final JCheckBox hideAdult = new JCheckBox(I18n.tr("Hide Adult Content"), FilterSettings.FILTER_WHATS_NEW_ADULT.getValue());
        hideAdult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(hideAdult.isSelected());
            }
        });
        c.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)hideAdult, c);
        hideAdult.setVisible(!FilterSettings.FILTER_ADULT.getValue());
        c.weighty = 1.0;
        panel.add(Box.createVerticalGlue(), c);
        return panel;
    }

    private JPanel createSearchEntryPanel() {
        this.SEARCH_FIELD.addActionListener(this.SEARCH_LISTENER);
        this.META_PANEL.add((Component)this.createDefaultSearchPanel(), DEFAULT_PANEL_KEY);
        DitherPanel search = new DitherPanel(this.DITHERER);
        search.setLayout(new BoxLayout(search, 1));
        search.add(GUIUtils.left(this.SEARCH_TYPE_LABEL));
        search.add(Box.createVerticalStrut(5));
        search.add(this.META_PANEL);
        return search;
    }

    private void createInputPanelForNamedMediaType(NamedMediaType nmt) {
        String name = nmt.getName();
        LimeXMLSchema schema = nmt.getSchema();
        if (schema == null) {
            throw new NullPointerException("named mediatype has no schema");
        }
        InputPanel panel = new InputPanel(schema, this.SEARCH_LISTENER, this.SEARCH_FIELD.getDocument(), this.SEARCH_FIELD.getUndoManager());
        panel.addMoreOptionsListener(new MoreOptionsListener());
        JScrollPane pane = new JScrollPane(panel, 20, 31);
        this.cleanupPaneActions(pane.getActionMap());
        pane.setOpaque(false);
        pane.setBorder(BorderFactory.createEmptyBorder());
        pane.getViewport().setBorder(null);
        JPanel outerPanel = new JPanel(new BorderLayout());
        outerPanel.add((Component)pane, "Center");
        outerPanel.add((Component)this.createSearchButtonPanel(), "South");
        int paneWidth = (int)pane.getPreferredSize().getWidth();
        int paneHeight = (int)pane.getPreferredSize().getHeight();
        Dimension dim = new Dimension(paneWidth + 70, paneHeight + 30);
        outerPanel.setMaximumSize(dim);
        this.inputPanelDimensions.put(nmt, dim);
        JPanel holdingPanel = new JPanel();
        holdingPanel.setLayout(new BoxLayout(holdingPanel, 1));
        holdingPanel.add(outerPanel);
        this.getInputPanelKeys().add(name);
        this.META_PANEL.add((Component)holdingPanel, name);
        this.panelize(this.searchEntry);
    }

    private void cleanupPaneActions(ActionMap map) {
        if (map == null) {
            return;
        }
        Object[] keys = map.allKeys();
        for (int i = 0; i < keys.length; ++i) {
            Action action = map.get(keys[i]);
            if (action == null) continue;
            Object o = action.getValue("Name");
            if (!(o instanceof String)) {
                return;
            }
            String name = (String)o;
            if (!name.equals("scrollHome") && !name.equals("scrollEnd") && !name.equals("scrollLeft") && !name.equals("scrollRight") && !name.equals("unitScrollLeft") && !name.equals("unitScrollRight")) continue;
            map.remove(keys[i]);
            if (map.get(keys[i]) == null) continue;
            this.cleanupPaneActions(map.getParent());
        }
    }

    private Set<String> getInputPanelKeys() {
        if (this.inputPanelKeys == null) {
            this.inputPanelKeys = new HashSet<String>();
        }
        return this.inputPanelKeys;
    }

    private JPanel createDefaultSearchPanel() {
        JPanel label = this.createLabel(I18n.tr("Filename"));
        BoxPanel fullPanel = new BoxPanel(1);
        fullPanel.add(label);
        fullPanel.add(Box.createVerticalStrut(3));
        fullPanel.add(GUIUtils.left(this.SEARCH_FIELD));
        fullPanel.add(Box.createVerticalStrut(5));
        fullPanel.add(this.createSearchButtonPanel());
        return GUIUtils.left(fullPanel);
    }

    private JPanel createLabel(String text) {
        BoxPanel labelPanel = new BoxPanel(0);
        labelPanel.setOpaque(false);
        labelPanel.add(new JLabel(text));
        labelPanel.add(Box.createHorizontalGlue());
        return labelPanel;
    }

    private JPanel createSearchButtonPanel() {
        JPanel b = new JPanel(new FlowLayout(0, 0, 0));
        JButton searchButton = new JButton(I18n.tr("Search"));
        searchButton.setToolTipText(I18n.tr("Search the Network for the Given Words"));
        searchButton.addActionListener(this.SEARCH_LISTENER);
        b.add(Box.createHorizontalGlue());
        b.add(searchButton);
        return b;
    }

    private JComponent getVisibleComponent() {
        for (int i = 0; i < this.META_PANEL.getComponentCount(); ++i) {
            Component current = this.META_PANEL.getComponent(i);
            if (!current.isVisible()) continue;
            return (JComponent)current;
        }
        return null;
    }

    private JScrollPane getVisibleScrollPane() {
        JComponent parent = (JComponent)this.getVisibleComponent().getComponent(0);
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component current = parent.getComponent(i);
            if (!current.isVisible() || !(current instanceof JScrollPane)) continue;
            return (JScrollPane)current;
        }
        return null;
    }

    private InputPanel getInputPanel() {
        JScrollPane pane = this.getVisibleScrollPane();
        if (pane == null) {
            return null;
        }
        return (InputPanel)pane.getViewport().getView();
    }

    private class MoreOptionsListener
    implements ActionListener {
        private MoreOptionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JCheckBox box = (JCheckBox)e.getSource();
            JComponent c = (JComponent)SearchInputPanel.this.getVisibleComponent().getComponent(0);
            JComponent pane = (JComponent)((JComponent)c.getComponent(0)).getComponent(0);
            if (c instanceof JPanel && pane instanceof JViewport) {
                if (box.isSelected()) {
                    c.setMaximumSize(null);
                } else {
                    Dimension dim = (Dimension)SearchInputPanel.this.inputPanelDimensions.get(SearchInputPanel.this.SCHEMA_BOX.getSelectedMedia());
                    if (dim != null) {
                        c.setMaximumSize(dim);
                    }
                }
            }
            SearchInputPanel.this.invalidate();
            SearchInputPanel.this.revalidate();
            SearchInputPanel.this.repaint();
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SearchInformation info;
            MediaType mt = SearchInputPanel.this.SCHEMA_BOX.getSelectedMediaType();
            InputPanel panel = null;
            if (SearchInputPanel.this.isWhatIsNewSearchType()) {
                info = SearchInformation.createWhatsNewSearch(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem(), mt);
                whatsNewSearches.count(mt != null ? mt.getMimeType() : "all");
            } else if (SearchInputPanel.this.isNormalSearchType()) {
                String query = null;
                String xml = null;
                String title = null;
                if (SearchInputPanel.this.SCHEMA_BOX.getSelectedSchema() != null) {
                    panel = SearchInputPanel.this.getInputPanel();
                    query = panel.getStandardQuery();
                    xml = panel.getInput(true);
                    if (xml == null && mt != null) {
                        numberOfXmlFields.count(0);
                    } else {
                        numberOfXmlFields.count(panel.getNumberOfFieldsWithInput());
                    }
                    title = panel.getTitleForQuery();
                } else {
                    title = query = SearchInputPanel.this.SEARCH_FIELD.getText();
                }
                info = SearchInformation.createTitledKeywordSearch(query, xml, mt, title);
                regularSearches.count(mt != null ? mt.getMimeType() : "all");
            } else if (SearchInputPanel.this.isBrowseHostSearchType()) {
                String user = SearchInputPanel.this.BROWSE_HOST_FIELD.getText();
                if (!NetworkUtils.isAddress(user)) {
                    GUIMediator.showError(I18n.tr("The address format is incorrect, please use host:port."));
                    return;
                }
                info = SearchInformation.createBrowseHostSearch(user);
                mt = MediaType.getAnyTypeMediaType();
            } else {
                throw new IllegalStateException("Invalid search: " + e);
            }
            if (SearchMediator.triggerSearch(info) != null) {
                if (info.isKeywordSearch()) {
                    if (panel != null) {
                        panel.storeInput();
                        panel.clear();
                    } else {
                        SearchInputPanel.this.SEARCH_FIELD.addToDictionary();
                    }
                    SearchInputPanel.this.SEARCH_FIELD.setText("");
                } else if (info.isBrowseHostSearch()) {
                    SearchInputPanel.this.BROWSE_HOST_FIELD.addToDictionary();
                    SearchInputPanel.this.BROWSE_HOST_FIELD.setText("");
                }
            }
        }
    }

    private class SchemaListener
    implements ActionListener {
        private SchemaListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (SearchInputPanel.this.SCHEMA_BOX.getSelectedSchema() != null) {
                String key = SearchInputPanel.this.SCHEMA_BOX.getSelectedItem();
                if (!SearchInputPanel.this.getInputPanelKeys().contains(key)) {
                    SearchInputPanel.this.createInputPanelForNamedMediaType(SearchInputPanel.this.SCHEMA_BOX.getSelectedMedia());
                }
                SearchInputPanel.this.META_CARDS.show(SearchInputPanel.this.META_PANEL, key);
            } else {
                SearchInputPanel.this.META_CARDS.show(SearchInputPanel.this.META_PANEL, SearchInputPanel.DEFAULT_PANEL_KEY);
            }
            SearchInputPanel.this.WHATSNEW_SEARCH_LABEL.setText(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            SearchInputPanel.this.WHATSNEW_SEARCH_LABEL.setPreferredSize(new Dimension(GUIUtils.width(SearchInputPanel.this.WHATSNEW_SEARCH_LABEL), 20));
            SearchInputPanel.this.SEARCH_TYPE_LABEL.setText(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            SearchInputPanel.this.requestSearchFocus();
        }
    }
}

