/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.banner.Ad;
import com.limegroup.gnutella.gui.banner.Banner;
import com.limegroup.gnutella.gui.download.DownloaderUtils;
import com.limegroup.gnutella.gui.download.SearchResultDownloaderFactory;
import com.limegroup.gnutella.gui.search.GnutellaSearchResult;
import com.limegroup.gnutella.gui.search.PromotionMessageContainerToSearchResultConverter;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchInputManager;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.ThirdPartySearchResultsSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.promotion.PromotionSearcher;
import org.limewire.promotion.containers.PromotionMessageContainer;
import org.limewire.service.ErrorService;
import org.limewire.setting.FileSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchMediator {
    public static final int QUERY_VALID = 0;
    public static final int QUERY_EMPTY = 1;
    public static final int QUERY_TOO_SHORT = 2;
    public static final int QUERY_TOO_LONG = 3;
    public static final int QUERY_XML_TOO_LONG = 4;
    public static final int QUERY_INVALID_CHARACTERS = 5;
    static final String DOWNLOAD_STRING = I18n.tr("Download");
    static final String KILL_STRING = I18n.tr("Close Search");
    static final String STOP_STRING = I18n.tr("Stop Search");
    static final String LAUNCH_STRING = I18n.tr("Launch Action");
    static final String BROWSE_STRING = I18n.tr("Browse Host");
    static final String CHAT_STRING = I18n.tr("Chat With Host");
    static final String REPEAT_SEARCH_STRING = I18n.tr("Repeat Search");
    static final String BROWSE_HOST_STRING = I18n.tr("Browse Host");
    static final String BITZI_LOOKUP_STRING = I18n.tr("Lookup File with Bitzi");
    static final String BLOCK_STRING = I18n.tr("Block Hosts");
    static final String MARK_AS_STRING = I18n.tr("Mark As");
    static final String SPAM_STRING = I18n.tr("Junk");
    static final String NOT_SPAM_STRING = I18n.tr("Not Junk");
    static final String REPEAT_SEARCH_NO_CLEAR_STRING = I18n.tr("Get More Results");
    public static final String SEARCH_INFORMATION_KEY = "searchInformationMap";
    private static final SearchInputManager INPUT_MANAGER = new SearchInputManager();
    static final SearchResultDisplayer RESULT_DISPLAYER = new SearchResultDisplayer();
    private static volatile Banner banner;

    public SearchMediator() {
        String splashScreenString = I18n.tr("Loading Search Window...");
        GUIMediator.setSplashScreenString(splashScreenString);
        GUIMediator.addRefreshListener(RESULT_DISPLAYER);
        RESULT_DISPLAYER.setSearchListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ResultPanel panel = RESULT_DISPLAYER.getSelectedResultPanel();
                if (panel == null) {
                    INPUT_MANAGER.clearFilters();
                } else {
                    INPUT_MANAGER.setFiltersFor(panel);
                }
            }
        });
        SearchMediator.initBanner();
    }

    private static void initBanner() {
        SearchMediator.reloadBanner();
        SearchSettings.SEARCH_WARNING.addSettingListener(new SettingListener(){

            public void settingChanged(SettingEvent evt) {
                if (evt.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                    SearchMediator.reloadBanner();
                }
            }
        });
    }

    private static void reloadBanner() {
        Banner newBanner = banner;
        try {
            newBanner = new Banner(SearchSettings.SEARCH_WARNING.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (newBanner == null) {
            newBanner = Banner.getDefaultBanner();
        }
        banner = newBanner;
    }

    public static void rebuildInputPanel() {
        INPUT_MANAGER.rebuild();
    }

    public static void addressChanged() {
        INPUT_MANAGER.addressChanged();
    }

    public static void showSearchInput() {
        INPUT_MANAGER.goToSearch();
    }

    public static void requestSearchFocus() {
        INPUT_MANAGER.requestSearchFocus();
    }

    public static void updateResults() {
        RESULT_DISPLAYER.updateResults();
    }

    static byte[] repeatSearch(ResultPanel rp, SearchInformation info) {
        return SearchMediator.repeatSearch(rp, info, true);
    }

    static byte[] repeatSearch(ResultPanel rp, SearchInformation info, boolean clearingResults) {
        if (!SearchMediator.validate(info)) {
            return null;
        }
        byte[] guidBytes = GuiCoreMediator.getSearchServices().newQueryGUID();
        GUID newGuid = new GUID(guidBytes);
        GuiCoreMediator.getSearchServices().stopQuery(new GUID(rp.getGUID()));
        rp.setGUID(newGuid);
        if (clearingResults) {
            INPUT_MANAGER.panelReset(rp);
        }
        if (info.isBrowseHostSearch()) {
            IpPort ipport = info.getIpPort();
            String host = ipport.getAddress();
            int port = ipport.getPort();
            if (host != null && port != 0) {
                GUIMediator.instance().setSearching(true);
                SearchMediator.reBrowseHost(new ConnectableImpl(ipport, false), rp);
            }
        } else {
            GUIMediator.instance().setSearching(true);
            SearchMediator.doSearch(guidBytes, info);
        }
        return guidBytes;
    }

    static void doBrowseHost(ResultPanel rp) {
        TableLine line = rp.getSelectedLine();
        if (line == null) {
            return;
        }
        RemoteFileDesc rfd = line.getBrowseHostEnabledRFD();
        if (rfd == null) {
            return;
        }
        byte[] serventIDBytes = rfd.getClientGUID();
        Set<IpPort> proxies = rfd.isReplyToMulticast() ? IpPort.EMPTY_SET : rfd.getPushProxies();
        GUID serventID = new GUID(serventIDBytes);
        SearchMediator.doBrowseHost2(rfd, serventID, proxies, rfd.supportsFWTransfer());
    }

    public static void doBrowseHost(RemoteFileDesc rfd) {
        SearchMediator.doBrowseHost2(rfd, new GUID(rfd.getClientGUID()), rfd.getPushProxies(), rfd.supportsFWTransfer());
    }

    public static void doBrowseHost(Connectable connectable, GUID guid) {
        SearchMediator.doBrowseHost2(connectable, guid, null, false);
    }

    private static void reBrowseHost(Connectable host, ResultPanel in) {
        GUID guid = new GUID(GUID.makeGuid());
        in.setGUID(guid);
        BrowseHostHandler bhh = GuiCoreMediator.getSearchServices().doAsynchronousBrowseHost(host, guid, new GUID(GUID.makeGuid()), null, false);
        in.setBrowseHostHandler(bhh);
        INPUT_MANAGER.panelReset(in);
    }

    public static void doBrowseHost(PushEndpoint pushEndpoint) {
        InetSocketAddress inetSocketAddress = pushEndpoint.getInetSocketAddress();
        ConnectableImpl host = inetSocketAddress != null ? new ConnectableImpl(inetSocketAddress, false) : null;
        SearchMediator.doBrowseHost2(host, new GUID(pushEndpoint.getClientGUID()), pushEndpoint.getProxies(), pushEndpoint.getFWTVersion() >= 1);
    }

    private static void doBrowseHost2(Connectable host, GUID serventID, Set<? extends IpPort> proxies, boolean canDoFWTransfer) {
        GUID guid = new GUID(GUID.makeGuid());
        String title = host != null ? host.getAddress() + ":" + host.getPort() : I18n.tr("Firewalled Host");
        ResultPanel rp = SearchMediator.addBrowseHostTab(guid, title);
        BrowseHostHandler bhh = GuiCoreMediator.getSearchServices().doAsynchronousBrowseHost(host, guid, serventID, proxies, canDoFWTransfer);
        rp.setBrowseHostHandler(bhh);
    }

    public static void browseHostFailed(GUID guid) {
        RESULT_DISPLAYER.browseHostFailed(guid);
    }

    public static byte[] triggerSearch(SearchInformation info) {
        if (!SearchMediator.validate(info)) {
            return null;
        }
        byte[] guid = GuiCoreMediator.getSearchServices().newQueryGUID();
        if (!info.isBrowseHostSearch()) {
            SearchMediator.addResultTab(new GUID(guid), info);
        }
        SearchMediator.doSearch(guid, info);
        SearchMediator.doPromoSearch(guid, info);
        return guid;
    }

    private static final boolean isPromotionalResultsDisabled() {
        return LimeWireUtils.isPro() && SearchSettings.DISABLE_PROMOTIONAL_RESULTS.getValue() || !ThirdPartySearchResultsSettings.PROMOTION_SYSTEM_IS_ENABLED.getValue();
    }

    private static void doPromoSearch(final byte[] guid, final SearchInformation info) {
        if (!SearchMediator.isPromotionalResultsDisabled() && GuiCoreMediator.getPromotionServices().isRunning()) {
            final PromotionSearcher promotionDatabase = GuiCoreMediator.getPromotionSearcher();
            final PromotionMessageContainerToSearchResultConverter promoMessageConverter = new PromotionMessageContainerToSearchResultConverter(GuiCoreMediator.getLimeXMLDocumentFactory(), GuiCoreMediator.getApplicationServices());
            GuiCoreMediator.getCoreBackgroundExecutor().execute(new Runnable(){

                public void run() {
                    final String query = info.getQuery();
                    promotionDatabase.search(query, new PromotionSearcher.PromotionSearchResultsCallback(){

                        public void process(final PromotionMessageContainer result) {
                            try {
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        ResultPanel rp = SearchMediator.getResultPanelForGUID(new GUID(guid));
                                        if (rp == null) {
                                            return;
                                        }
                                        SearchResult sr = promoMessageConverter.convert(result, query);
                                        if (sr != null) {
                                            RESULT_DISPLAYER.addQueryResult(guid, sr, rp);
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                ErrorService.error(e, "invokeAndWait for store song result");
                            }
                            catch (InvocationTargetException e) {
                                ErrorService.error(e, "invokeAndWait for store song result");
                            }
                        }
                    }, GuiCoreMediator.getCachedGeoLocation().getGeocodeInformation());
                }
            });
        }
    }

    public static byte[] triggerSearch(String query) {
        return SearchMediator.triggerSearch(SearchInformation.createKeywordSearch(query, null, MediaType.getAnyTypeMediaType()));
    }

    public static void showMyFiles(String title) {
        SearchMediator.addMyFilesResultTab(title);
    }

    private static boolean validate(SearchInformation info) {
        switch (SearchMediator.validateInfo(info)) {
            case 1: {
                return false;
            }
            case 2: {
                GUIMediator.showError(I18n.tr("Your search must be at least three characters to avoid congesting the network."));
                return false;
            }
            case 3: {
                String xml = info.getXML();
                if (xml == null || xml.length() == 0) {
                    GUIMediator.showError(I18n.tr("Your search is too long. Please make your search smaller and try again."));
                } else {
                    GUIMediator.showError(I18n.tr("Your search is too specific. Please make your search smaller and try again."));
                }
                return false;
            }
            case 4: {
                GUIMediator.showError(I18n.tr("Your search is too specific. Please make your search smaller and try again."));
                return false;
            }
        }
        if (!GuiCoreMediator.getLifecycleManager().isStarted()) {
            GUIMediator.showMessage(I18n.tr("Please wait, LimeWire must finish loading before a search can be started."));
            return false;
        }
        if (!info.isBrowseHostSearch() && !GuiCoreMediator.getConnectionServices().isConnected()) {
            if (!GuiCoreMediator.getConnectionServices().isConnecting()) {
                GUIMediator.showMessage(I18n.tr("You are not connected to the network. To connect, select \"Connect\" from the \"File\" menu. Your search may not return any results until you connect."), QuestionsHandler.NO_NOT_CONNECTED);
            } else {
                GUIMediator.showMessage(I18n.tr("LimeWire is currently connecting to the network. Your search may not return many results until you are fully connected to the network."), QuestionsHandler.NO_STILL_CONNECTING);
            }
        }
        return true;
    }

    public static int validateInfo(SearchInformation info) {
        String query = I18NConvert.instance().getNorm(info.getQuery());
        String xml = info.getXML();
        if (query.length() == 0) {
            return 1;
        }
        if (!(query.length() > 2 || query.length() == 2 && (Character.isDigit(query.charAt(0)) && Character.isLetter(query.charAt(1)) || Character.isLetter(query.charAt(0)) && Character.isDigit(query.charAt(1))))) {
            return 2;
        }
        if (query.length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            return 3;
        }
        if (xml != null && xml.length() > SearchSettings.MAX_XML_QUERY_LENGTH.getValue()) {
            return 4;
        }
        if (StringUtils.containsCharacters(query, SearchSettings.ILLEGAL_CHARS.getValue())) {
            return 5;
        }
        return 0;
    }

    private static void doSearch(byte[] guid, SearchInformation info) {
        String query = info.getQuery();
        String xml = info.getXML();
        MediaType media = info.getMediaType();
        if (info.isXMLSearch()) {
            GuiCoreMediator.getSearchServices().query(guid, query, xml, media);
        } else if (info.isKeywordSearch()) {
            GuiCoreMediator.getSearchServices().query(guid, query, media);
        } else if (info.isWhatsNewSearch()) {
            GuiCoreMediator.getSearchServices().queryWhatIsNew(guid, media);
        } else if (info.isBrowseHostSearch()) {
            IpPort ipport = info.getIpPort();
            SearchMediator.doBrowseHost(new ConnectableImpl(ipport, false), null);
        }
    }

    private static ResultPanel addResultTab(GUID guid, SearchInformation info) {
        return RESULT_DISPLAYER.addResultTab(guid, info);
    }

    private static ResultPanel addMyFilesResultTab(String title) {
        return RESULT_DISPLAYER.addMyFilesResultTab(title);
    }

    private static ResultPanel addBrowseHostTab(GUID guid, String desc) {
        return RESULT_DISPLAYER.addResultTab(guid, SearchInformation.createBrowseHostSearch(desc));
    }

    public static void handleQueryResult(RemoteFileDesc rfd, HostData data, Set<? extends IpPort> alts) {
        byte[] replyGUID = data.getMessageGUID();
        ResultPanel rp = SearchMediator.getResultPanelForGUID(new GUID(replyGUID));
        if (rp != null) {
            RESULT_DISPLAYER.addQueryResult(replyGUID, new GnutellaSearchResult(rfd, data, alts), rp);
        }
    }

    public static void downloadFromPanel(ResultPanel rp, TableLine ... lines) {
        SearchMediator.downloadAll(lines, new GUID(rp.getGUID()), rp.getSearchInformation());
        rp.refresh();
    }

    static void doDownload(final ResultPanel rp) {
        final TableLine[] lines = rp.getAllSelectedLines();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.downloadAll(lines, new GUID(rp.getGUID()), rp.getSearchInformation());
                rp.refresh();
            }
        });
    }

    static void doDownloadAs(ResultPanel panel) {
        TableLine[] lines = panel.getAllSelectedLines();
        if (lines.length != 1) {
            throw new IllegalStateException("There should only be one search result selected: " + lines.length);
        }
        SearchMediator.downloadLine(lines[0], new GUID(panel.getGUID()), null, null, true, panel.getSearchInformation());
    }

    static void showProperties(ResultPanel panel) {
        TableLine[] lines = panel.getAllSelectedLines();
        if (lines.length > 0) {
            GUIMediator.showProperties(lines[0]);
        }
    }

    private static void downloadAll(TableLine[] lines, GUID guid, SearchInformation searchInfo) {
        for (int i = 0; i < lines.length; ++i) {
            SearchMediator.downloadLine(lines[i], guid, null, null, false, searchInfo);
        }
    }

    private static void downloadLine(TableLine line, GUID guid, File saveDir, String fileName, boolean saveAs, SearchInformation searchInfo) {
        if (line == null) {
            throw new NullPointerException("Tried to download null line");
        }
        line.takeAction(line, guid, saveDir, fileName, saveAs, searchInfo);
    }

    public static void downloadGnutellaLine(TableLine line, GUID guid, File saveDir, String fileName, boolean saveAs, SearchInformation searchInfo) {
        FileSetting fs;
        if (line == null) {
            throw new NullPointerException("Tried to download null line");
        }
        if (!(line.isLicenseAvailable() || line.isSecure() || GUIMediator.showFirstDownloadDialog())) {
            return;
        }
        IpPortSet alts = new IpPortSet();
        LinkedList<RemoteFileDesc> otherRFDs = new LinkedList<RemoteFileDesc>();
        RemoteFileDesc[] rfds = line.getAllRemoteFileDescs();
        alts.addAll(line.getAlts());
        RemoteFileDesc sha1RFD = null;
        for (int i = 0; i < rfds.length; ++i) {
            IpPort next = rfds[i];
            next.setRetryAfter(0);
            if (next.getSHA1Urn() != null) {
                sha1RFD = next;
            }
            alts.remove(next);
        }
        if (sha1RFD == null) {
            sha1RFD = rfds[0];
        }
        for (IpPort next : alts) {
            otherRFDs.add(GuiCoreMediator.getRemoteFileDescFactory().createRemoteFileDesc(sha1RFD, next));
        }
        if (saveDir == null && line.getNamedMediaType() != null && !(fs = SharingSettings.getFileSettingForMediaType(line.getNamedMediaType().getMediaType())).isDefault()) {
            saveDir = fs.getValue();
        }
        SearchMediator.downloadWithOverwritePrompt(rfds, otherRFDs, guid, saveDir, fileName, saveAs, searchInfo);
    }

    private static void downloadWithOverwritePrompt(RemoteFileDesc[] rfds, List<? extends RemoteFileDesc> alts, GUID queryGUID, File saveDir, String fileName, boolean saveAs, SearchInformation searchInfo) {
        Downloader dl;
        String action;
        LimeXMLDocument doc;
        int actLine;
        if (rfds.length < 1) {
            return;
        }
        if (SearchMediator.containsExe(rfds) && !SearchMediator.userWantsExeDownload()) {
            return;
        }
        boolean pureFound = false;
        for (actLine = 0; actLine < rfds.length; ++actLine) {
            if (rfds[actLine].getIndex() != 0xFFFFFFFFL) continue;
            pureFound = true;
            break;
        }
        if (pureFound && (doc = rfds[actLine].getXMLDocument()) != null && (action = doc.getAction()) != null && !action.equals("")) {
            if (doc.actionDetailRequested()) {
                action = LimeWireUtils.addLWInfoToUrl(action, GuiCoreMediator.getApplicationServices().getMyGUID());
            }
            if (action.length() > 255) {
                action = action.substring(0, 255);
            }
            GUIMediator.openURL(action);
            return;
        }
        SearchResultDownloaderFactory factory = new SearchResultDownloaderFactory(rfds, alts, queryGUID, saveDir, fileName);
        Downloader downloader = dl = saveAs ? DownloaderUtils.createDownloaderAs(factory) : DownloaderUtils.createDownloader(factory);
        if (dl != null) {
            SearchMediator.setAsDownloading(rfds);
            if (SearchMediator.validateInfo(searchInfo) == 0) {
                dl.setAttribute(SEARCH_INFORMATION_KEY, searchInfo.toMap(), false);
            }
        }
    }

    private static void setAsDownloading(RemoteFileDesc[] rfds) {
        for (int i = 0; i < rfds.length; ++i) {
            rfds[i].setDownloading(true);
        }
    }

    private static boolean containsExe(RemoteFileDesc[] rfd) {
        for (int i = 0; i < rfd.length; ++i) {
            if (!rfd[i].getFileName().toLowerCase(Locale.US).endsWith("exe")) continue;
            return true;
        }
        return false;
    }

    private static boolean userWantsExeDownload() {
        DialogOption response = GUIMediator.showYesNoMessage(I18n.tr("One of the selected files is an executable program and could contain a virus. Are you sure you want to download it?"), QuestionsHandler.PROMPT_FOR_EXE, DialogOption.NO);
        return response == DialogOption.YES;
    }

    static void setTabDisplayCount(ResultPanel rp) {
        RESULT_DISPLAYER.setTabDisplayCount(rp);
    }

    static void killSearch() {
        RESULT_DISPLAYER.killSearch();
    }

    static void panelSelected(ResultPanel panel) {
        INPUT_MANAGER.setFiltersFor(panel);
    }

    static void searchKilled(ResultPanel panel) {
        INPUT_MANAGER.panelRemoved(panel);
        ResultPanel rp = RESULT_DISPLAYER.getSelectedResultPanel();
        if (rp != null) {
            INPUT_MANAGER.setFiltersFor(rp);
        }
        panel.cleanup();
    }

    static void checkToStopLime() {
        RESULT_DISPLAYER.checkToStopLime();
    }

    static ResultPanel getResultPanelForGUID(GUID rguid) {
        return RESULT_DISPLAYER.getResultPanelForGUID(rguid);
    }

    public static boolean queryIsAlive(GUID guid) {
        return SearchMediator.getResultPanelForGUID(guid) != null;
    }

    public static JComponent getSearchComponent() {
        return INPUT_MANAGER.getComponent();
    }

    public static JComponent getResultComponent() {
        return RESULT_DISPLAYER.getComponent();
    }

    public static synchronized Ad getAd() {
        if (banner == null) {
            SearchMediator.initBanner();
        }
        return banner.getAd();
    }
}

