/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.MySharedFilesResultPanel;
import com.limegroup.gnutella.gui.search.OverlayAd;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.util.DebugRunnable;

final class SearchResultDisplayer
implements ThemeObserver,
RefreshListener {
    private final JPanel MAIN_PANEL = new BoxPanel(1);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private static final List<ResultPanel> entries = new ArrayList<ResultPanel>();
    private final JPanel results = new JPanel();
    private final CardLayout switcher = new CardLayout();
    private final ResultPanel DUMMY;
    private final OverlayAd OVERLAY;
    private ChangeListener _activeSearchListener;
    private final PaneListener PANE_LISTENER = new PaneListener();
    @InspectablePrimitive(value="selectedResultTabsCount")
    private static volatile int selectedResultTabsCount = 0;

    SearchResultDisplayer() {
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        this.OVERLAY = new OverlayAd();
        this.DUMMY = new ResultPanel(this.OVERLAY);
        JPanel mainScreen = new JPanel(new BorderLayout());
        mainScreen.add((Component)this.DUMMY.getComponent(), "Center");
        this.results.add("dummy", mainScreen);
        this.switcher.first(this.results);
        this.setupTabbedPane();
        this.MAIN_PANEL.add(this.results);
        ThemeMediator.addThemeObserver(this);
        CancelSearchIconProxy.updateTheme();
    }

    void setSearchListener(ChangeListener listener) {
        this._activeSearchListener = listener;
    }

    void updateResults() {
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).refresh();
        }
    }

    ResultPanel addResultTab(GUID guid, SearchInformation info) {
        ResultPanel panel = new ResultPanel(guid, info);
        return this.addResultPanelInternal(panel, info.getTitle());
    }

    ResultPanel addMyFilesResultTab(String title) {
        FileManager fileManager = GuiCoreMediator.getFileManager();
        MySharedFilesResultPanel panel = new MySharedFilesResultPanel(title, fileManager);
        return this.addResultPanelInternal(panel, title);
    }

    private void setupTabbedPane() {
        if (this.tabbedPane != null) {
            this.tabbedPane.removeMouseListener(this.PANE_LISTENER);
            this.tabbedPane.removeMouseMotionListener(this.PANE_LISTENER);
            this.tabbedPane.removeChangeListener(this.PANE_LISTENER);
        }
        this.tabbedPane = new JTabbedPane();
        ProgTabUIFactory.extendUI(this.tabbedPane);
        this.tabbedPane.setRequestFocusEnabled(false);
        this.results.add("tabbedPane", this.tabbedPane);
        this.tabbedPane.addMouseListener(this.PANE_LISTENER);
        this.tabbedPane.addMouseMotionListener(this.PANE_LISTENER);
        this.tabbedPane.addChangeListener(this.PANE_LISTENER);
    }

    private void resetTabbedPane() {
        int i;
        ArrayList<ResultPanel> ents = new ArrayList<ResultPanel>();
        ArrayList<Component> tabs = new ArrayList<Component>();
        ArrayList<String> titles = new ArrayList<String>();
        for (i = 0; i < this.tabbedPane.getTabCount() && i < entries.size(); ++i) {
            tabs.add(this.tabbedPane.getComponent(i));
            titles.add(this.tabbedPane.getTitleAt(i));
            ents.add(entries.get(i));
        }
        this.tabbedPane.removeAll();
        entries.clear();
        this.setupTabbedPane();
        for (i = 0; i < tabs.size(); ++i) {
            entries.add((ResultPanel)ents.get(i));
            this.tabbedPane.addTab((String)titles.get(i), (Component)tabs.get(i));
        }
    }

    private ResultPanel addResultPanelInternal(ResultPanel panel, String title) {
        entries.add(panel);
        try {
            this.tabbedPane.addTab(title, CancelSearchIconProxy.createSelected(), panel.getComponent());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.resetTabbedPane();
            entries.add(panel);
            this.tabbedPane.addTab(title, CancelSearchIconProxy.createSelected(), panel.getComponent());
        }
        try {
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.resetTabbedPane();
            this.tabbedPane.setSelectedIndex(entries.size() - 1);
        }
        if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
            this.killSearchAtIndex(0);
        }
        GUIMediator.instance().setSearching(true);
        this.OVERLAY.searchPerformed();
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return panel;
    }

    void addQueryResult(byte[] replyGUID, SearchResult line, ResultPanel rp) {
        if (!rp.matches(new GUID(replyGUID))) {
            throw new IllegalArgumentException("guids don't match");
        }
        rp.add(line);
        int resultPanelIndex = -1;
        resultPanelIndex = entries.indexOf(rp);
        if (resultPanelIndex == -1) {
            return;
        }
        this.tabbedPane.setTitleAt(resultPanelIndex, this.titleOf(rp));
    }

    void addChangeListener(ChangeListener listener) {
        this.tabbedPane.addChangeListener(listener);
    }

    void addFocusListener(FocusListener listener) {
        this.tabbedPane.addFocusListener(listener);
    }

    void showMenu(MouseEvent e) {
        ResultPanel rp = this.getSelectedResultPanel();
        if (rp != null) {
            JPopupMenu menu = rp.createPopupMenu(new TableLine[0]);
            Point p = e.getPoint();
            if (menu != null) {
                try {
                    menu.show(this.MAIN_PANEL, p.x + 1, p.y - 6);
                }
                catch (IllegalComponentStateException icse) {
                    // empty catch block
                }
            }
        }
    }

    ResultPanel getSelectedResultPanel() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i == -1) {
            return null;
        }
        try {
            return entries.get(i);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    ResultPanel getResultPanelForGUID(GUID rguid) {
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel rp = entries.get(i);
            if (!rp.matches(rguid)) continue;
            return rp;
        }
        return null;
    }

    ResultPanel getPanelAtIndex(int index) {
        return entries.get(index);
    }

    int getIndexForGUID(GUID rguid) {
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel rp = entries.get(i);
            if (!rp.matches(rguid)) continue;
            return i;
        }
        return -1;
    }

    int getIndexForPoint(int x, int y) {
        TabbedPaneUI ui = this.tabbedPane.getUI();
        return ui.tabForCoordinate(this.tabbedPane, x, y);
    }

    void killSearch() {
        int i = this.tabbedPane.getSelectedIndex();
        if (i >= entries.size()) {
            this.resetTabbedPane();
            i = this.tabbedPane.getSelectedIndex();
        }
        if (i == -1) {
            return;
        }
        this.killSearchAtIndex(i);
    }

    void killSearchAtIndex(int i) {
        ResultPanel killed = entries.remove(i);
        final GUID killedGUID = new GUID(killed.getGUID());
        BackgroundExecutorService.schedule(new DebugRunnable(new Runnable(){

            public void run() {
                GuiCoreMediator.getSearchServices().stopQuery(killedGUID);
            }
        }));
        try {
            this.tabbedPane.removeTabAt(i);
        }
        catch (IllegalArgumentException iae) {
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            this.resetTabbedPane();
            this.tabbedPane.removeTabAt(i);
        }
        this.fixIcons();
        SearchMediator.searchKilled(killed);
        ThemeMediator.removeThemeObserver(killed);
        if (entries.size() == 0) {
            try {
                this.switcher.first(this.results);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                // empty catch block
            }
            GUIMediator.instance().setSearching(false);
        } else {
            this.checkToStopLime();
        }
    }

    void browseHostFailed(GUID guid) {
        int i = this.getIndexForGUID(guid);
        if (i > -1) {
            ResultPanel rp = this.getPanelAtIndex(i);
            this.killSearchAtIndex(i);
            GUIMediator.showError(I18n.tr("Could not browse host {0}.", rp.getTitle()), QuestionsHandler.BROWSE_HOST_FAILED);
        }
    }

    void checkToStopLime() {
        long now = System.currentTimeMillis();
        boolean stopLime = true;
        for (int i = 0; i < entries.size(); ++i) {
            ResultPanel panel = entries.get(i);
            stopLime &= panel.isStopped() || panel.calculatePercentage(now) >= 1.0;
        }
        if (stopLime) {
            GUIMediator.instance().setSearching(false);
        }
    }

    void setTabDisplayCount(ResultPanel rp) {
        int i;
        boolean found = false;
        for (i = 0; i < entries.size(); ++i) {
            ResultPanel panel = entries.get(i);
            if (panel != rp) continue;
            found = true;
            break;
        }
        if (found) {
            this.tabbedPane.setTitleAt(i, this.titleOf(rp));
        }
    }

    private void fixIcons() {
        int sel = this.tabbedPane.getSelectedIndex();
        for (int i = 0; i < entries.size() && i < this.tabbedPane.getTabCount(); ++i) {
            this.tabbedPane.setIconAt(i, i == sel ? CancelSearchIconProxy.createSelected() : CancelSearchIconProxy.createPlain());
        }
    }

    ResultPanel getDummyResultPanel() {
        return this.DUMMY;
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void updateTheme() {
        ProgTabUIFactory.extendUI(this.tabbedPane);
        this.DUMMY.updateTheme();
        this.OVERLAY.updateTheme();
        CancelSearchIconProxy.updateTheme();
        this.fixIcons();
        for (ResultPanel curPanel : entries) {
            curPanel.updateTheme();
        }
    }

    public void refresh() {
        this.checkToStopLime();
        if (this.tabbedPane.isVisible() && this.tabbedPane.isShowing()) {
            Rectangle allBounds = this.tabbedPane.getBounds();
            Component comp = null;
            try {
                comp = this.tabbedPane.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                this.resetTabbedPane();
                comp = this.tabbedPane.getSelectedComponent();
            }
            if (comp != null) {
                Rectangle compBounds = comp.getBounds();
                Rectangle allTabs = new Rectangle(allBounds.x, allBounds.y, allBounds.width, compBounds.y - 1);
                this.tabbedPane.repaint(allTabs);
            }
        }
    }

    private String titleOf(ResultPanel rp) {
        int total;
        int current = rp.filteredSources();
        if (current < (total = rp.totalSources())) {
            return rp.getTitle() + " (" + current + "/" + total + ")";
        }
        return rp.getTitle() + " (" + total + ")";
    }

    private class PaneListener
    implements MouseListener,
    MouseMotionListener,
    ChangeListener {
        private int lastIdx = -1;
        private int lastClickedIndex = -1;

        private PaneListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.tryPopup(e)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                int y;
                int x = e.getX();
                int idx = this.shouldKillIndex(x, y = e.getY());
                if (idx != -1) {
                    this.lastIdx = -1;
                    SearchResultDisplayer.this.killSearchAtIndex(idx);
                } else {
                    int index = SearchResultDisplayer.this.getIndexForPoint(x, y);
                    if (index != this.lastClickedIndex) {
                        this.lastClickedIndex = index;
                        ++selectedResultTabsCount;
                    }
                }
                if (idx == -1) {
                    this.stateChanged(null);
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            int y;
            int x = e.getX();
            int idx = this.shouldKillIndex(x, y = e.getY());
            if (idx != this.lastIdx && this.lastIdx != -1) {
                this.resetIcon();
            }
            if (idx != -1) {
                SearchResultDisplayer.this.tabbedPane.setIconAt(idx, CancelSearchIconProxy.createArmed());
                this.lastIdx = idx;
            }
        }

        private int shouldKillIndex(int x, int y) {
            Icon icon;
            int idx = SearchResultDisplayer.this.getIndexForPoint(x, y);
            if (idx != -1 && (icon = SearchResultDisplayer.this.tabbedPane.getIconAt(idx)) != null && icon instanceof CancelSearchIconProxy && ((CancelSearchIconProxy)icon).shouldKill(x, y)) {
                return idx;
            }
            return -1;
        }

        private void resetIcon() {
            if (this.lastIdx != -1 && this.lastIdx < SearchResultDisplayer.this.tabbedPane.getTabCount()) {
                if (this.lastIdx == SearchResultDisplayer.this.tabbedPane.getSelectedIndex()) {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createSelected());
                } else {
                    SearchResultDisplayer.this.tabbedPane.setIconAt(this.lastIdx, CancelSearchIconProxy.createPlain());
                }
                this.lastIdx = -1;
            }
        }

        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.resetIcon();
        }

        public void mouseDragged(MouseEvent e) {
        }

        private boolean tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int idx = SearchResultDisplayer.this.getIndexForPoint(e.getX(), e.getY());
                if (idx != -1) {
                    try {
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(idx);
                    }
                    catch (ArrayIndexOutOfBoundsException aioobe) {
                        SearchResultDisplayer.this.resetTabbedPane();
                        SearchResultDisplayer.this.tabbedPane.setSelectedIndex(idx);
                    }
                }
                SearchResultDisplayer.this.showMenu(e);
                return true;
            }
            return false;
        }

        public void stateChanged(ChangeEvent e) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(e);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

