/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.xml.XMLUtils;
import org.limewire.util.StringUtils;

class Selector {
    public static final int SCHEMA = 1;
    public static final int FIELD = 2;
    public static final int PROPERTY = 3;
    private static final String S_SCHEMA = "schema";
    private static final String S_FIELD = "field";
    private static final String S_PROPERTY = "property";
    private final String _SCHEMA;
    private final String _VALUE;
    private final int _TYPE;
    private final PropertyType propertyType;
    private boolean _minimized = false;
    private int cachedHashCode;

    private Selector(String schema, String value, int type) {
        this._SCHEMA = schema;
        this._VALUE = value;
        this._TYPE = type;
        this.propertyType = null;
    }

    private Selector(String schema, PropertyType type) {
        this._SCHEMA = schema;
        this._VALUE = type.getKey();
        this._TYPE = 3;
        this.propertyType = type;
    }

    public static Selector createSchemaSelector() {
        return new Selector("", "", 1);
    }

    public static Selector createFieldSelector(String schema, String field) {
        return new Selector(schema, field, 2);
    }

    public static Selector createPropertySelector(String property) throws IllegalArgumentException {
        PropertyType type = PropertyType.fromKey(property);
        return new Selector("", type);
    }

    public static Selector createPropertySelector(PropertyType propertyType) {
        return new Selector("", propertyType);
    }

    public static Selector createFromString(String value) {
        Selector selector;
        String right;
        String left;
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        int pipe = (value = value.toLowerCase()).indexOf("|");
        if (pipe == -1 || pipe == value.length()) {
            left = value.trim();
            right = "";
        } else {
            left = value.substring(0, pipe).trim();
            right = value.substring(pipe + 1).trim();
        }
        String[] data = StringUtils.split(left, ",");
        if (data.length == 0) {
            throw new IllegalArgumentException(value);
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i].trim();
        }
        if (S_SCHEMA.equals(data[0])) {
            selector = Selector.createSchemaSelector();
            if (data.length != 1) {
                throw new IllegalArgumentException(value);
            }
        } else if (S_FIELD.equals(data[0])) {
            if (data.length != 3) {
                throw new IllegalArgumentException(value);
            }
            String schema = data[1];
            String info = data[2];
            selector = Selector.createFieldSelector(schema, info);
        } else if (S_PROPERTY.equals(data[0])) {
            if (data.length != 2) {
                throw new IllegalArgumentException(value);
            }
            String info = data[1].toUpperCase();
            selector = Selector.createPropertySelector(info);
        } else {
            throw new IllegalArgumentException(value);
        }
        data = StringUtils.split(right, ",");
        for (int i = 0; i < data.length; ++i) {
            data[i] = data[i].trim();
        }
        if (data.length > 0) {
            selector.setMinimized(data[0].equals("true"));
        }
        return selector;
    }

    public String toString() {
        String value;
        switch (this._TYPE) {
            case 1: {
                value = S_SCHEMA;
                break;
            }
            case 2: {
                value = "field, " + this._SCHEMA + ", " + this._VALUE;
                break;
            }
            case 3: {
                value = "property, " + this._VALUE;
                break;
            }
            default: {
                throw new IllegalStateException("invalid type: " + this._TYPE);
            }
        }
        return value + " | " + this._minimized;
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        this._minimized = minimized;
    }

    public String getTitle() {
        switch (this._TYPE) {
            case 1: {
                return I18n.tr("Media");
            }
            case 2: {
                return XMLUtils.getResource(this._VALUE);
            }
            case 3: {
                return this.propertyType.getTitle();
            }
        }
        throw new IllegalArgumentException("invalid type: " + this._TYPE);
    }

    public boolean isSchemaSelector() {
        return this._TYPE == 1;
    }

    public boolean isFieldSelector() {
        return this._TYPE == 2;
    }

    public boolean isPropertySelector() {
        return this._TYPE == 3;
    }

    public int getSelectorType() {
        return this._TYPE;
    }

    public String getSchema() {
        if (this._TYPE != 2) {
            throw new IllegalStateException("invalid type: " + this._TYPE);
        }
        return this._SCHEMA;
    }

    public String getValue() {
        if (this._TYPE != 2 && this._TYPE != 3) {
            throw new IllegalStateException("invalid type: " + this._TYPE);
        }
        return this._VALUE;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Selector) {
            Selector f = (Selector)o;
            return f._TYPE == this._TYPE && f._SCHEMA.equals(this._SCHEMA) && f._VALUE.equals(this._VALUE);
        }
        return false;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this._TYPE + 31 * this._SCHEMA.hashCode() + 961 * this._VALUE.hashCode();
        }
        return this.cachedHashCode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyType {
        TYPE("RESULT_PANEL_TYPE", I18n.tr("Type")),
        SPEED("RESULT_PANEL_SPEED", I18n.tr("Speed")),
        VENDOR("RESULT_PANEL_VENDOR", I18n.tr("Vendor"));

        private final String key;
        private final String title;

        private PropertyType(String key, String title) {
            this.key = key;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public String getKey() {
            return this.key;
        }

        public static PropertyType fromKey(String key) throws IllegalArgumentException {
            for (PropertyType type : PropertyType.values()) {
                if (!key.equals(type.key)) continue;
                return type;
            }
            throw new IllegalArgumentException("not a key for a type: " + key);
        }
    }
}

