/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchResult;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.limewire.collection.ApproximateMatcher;
import org.limewire.collection.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableLineGrouper {
    private SortedMap<Long, List<SearchResult>> map = new TreeMap<Long, List<SearchResult>>(Comparators.longComparator());
    private final ApproximateMatcher matcher = new ApproximateMatcher(120);

    public TableLineGrouper() {
        this.matcher.setIgnoreCase(true);
        this.matcher.setIgnoreWhitespace(true);
        this.matcher.setCompareBackwards(true);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    private int matchHelper(List<SearchResult> list, SearchResult line) {
        assert (list != null) : "Trying to match null list";
        assert (line != null) : "Trying to match null line";
        for (int j = 0; j < list.size(); ++j) {
            SearchResult line2 = list.get(j);
            int match = line2.match(line, this.matcher);
            if (match == 0) {
                return j;
            }
            if (match != 2) continue;
            return -2;
        }
        return -1;
    }

    public SearchResult match(SearchResult line) {
        Long key = line.getSize();
        for (List<SearchResult> lines : this.map.tailMap(key).values()) {
            int ret = this.matchHelper(lines, line);
            if (ret >= 0) {
                return lines.get(ret);
            }
            if (ret != -2) continue;
            break;
        }
        SortedMap<Long, List<SearchResult>> map = this.map.headMap(key);
        while (true) {
            Long key2;
            try {
                key2 = map.lastKey();
            }
            catch (NoSuchElementException e) {
                break;
            }
            List lines = (List)map.get(key2);
            int ret = this.matchHelper(lines, line);
            if (ret >= 0) {
                return (SearchResult)lines.get(ret);
            }
            if (ret == -2) break;
            map = map.headMap(key2);
        }
        return null;
    }

    public void add(SearchResult line) {
        assert (line != null) : "Attempting to add null line";
        Long key = line.getSize();
        LinkedList<SearchResult> lines = (LinkedList<SearchResult>)this.map.get(key);
        if (lines == null) {
            lines = new LinkedList<SearchResult>();
            this.map.put(key, lines);
        }
        lines.add(line);
    }
}

