/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.shell.FileTypeAssociation;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.gui.shell.MagnetAssociation;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeAssociations {
    public static final int CURRENT_ASSOCIATIONS = 2;
    private static final String PROGRAM = OSUtils.isWindows() ? "LimeWire" : (OSUtils.isUnix() ? System.getProperty("unix.executable", "") : "");
    private static final String UNSUPPORTED_PLATFORM = "";
    private static Collection<LimeAssociationOption> options;

    public static synchronized Collection<LimeAssociationOption> getSupportedAssociations() {
        if (options == null) {
            options = LimeAssociations.getSupportedAssociationsImpl();
        }
        return options;
    }

    public static synchronized boolean anyAssociationsSupported() {
        return !LimeAssociations.getSupportedAssociations().isEmpty();
    }

    private static Collection<LimeAssociationOption> getSupportedAssociationsImpl() {
        String runningPath;
        if (!ResourceManager.instance().isJdicLibraryLoaded()) {
            return Collections.emptyList();
        }
        ArrayList<LimeAssociationOption> ret = new ArrayList<LimeAssociationOption>();
        String fileOpener = null;
        String fileIcon = null;
        String protocolOpener = null;
        if (OSUtils.isWindows() && (runningPath = SystemUtils.getRunningPath()) != null && runningPath.endsWith(PROGRAM + ".exe")) {
            protocolOpener = runningPath;
            fileOpener = "\"" + runningPath + "\" \"%1\"";
            fileIcon = runningPath + ",1";
        }
        if (fileOpener != null) {
            FileTypeAssociation file = new FileTypeAssociation("torrent", "application/x-bittorrent", fileOpener, "open", "LimeWire Torrent", fileIcon);
            LimeAssociationOption torrent = new LimeAssociationOption(file, ApplicationSettings.HANDLE_TORRENTS, ".torrent", I18n.tr("\".torrent\" files"));
            ret.add(torrent);
        }
        if (protocolOpener != null) {
            MagnetAssociation mag = new MagnetAssociation(PROGRAM, protocolOpener);
            LimeAssociationOption magOption = new LimeAssociationOption(mag, ApplicationSettings.HANDLE_MAGNETS, "magnet:", I18n.tr("\"magnet:\" links"));
            ret.add(magOption);
        }
        return Collections.unmodifiableCollection(ret);
    }
}

