/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.shell.LimeAssociationOption;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.util.Collection;
import org.limewire.i18n.I18nMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellAssociationManager {
    private final Collection<LimeAssociationOption> associations;

    public ShellAssociationManager(Collection<LimeAssociationOption> associations) {
        this.associations = associations;
    }

    public boolean checkAndGrab(boolean prompt) {
        boolean ret = true;
        for (LimeAssociationOption association : this.associations) {
            if (!association.isAllowed()) continue;
            if (association.isAvailable()) {
                association.setEnabled(true);
                continue;
            }
            if (association.isEnabled()) continue;
            ret = false;
        }
        if (!ret && prompt) {
            DialogOption answer = GUIMediator.showYesNoOtherMessage(I18n.tr("One or more files or protocols that LimeWire uses are no longer associated with LimeWire. Would you like LimeWire to re-associate them?"), QuestionsHandler.GRAB_ASSOCIATIONS, I18n.tr("Details"));
            if (answer == DialogOption.YES) {
                for (LimeAssociationOption association : this.associations) {
                    if (!association.isAllowed() || association.isEnabled()) continue;
                    association.setEnabled(true);
                }
            } else if (answer == DialogOption.OTHER) {
                new ConfigureOptionsAction(I18nMarker.marktr("File Associations")).actionPerformed(null);
            }
        }
        return ret;
    }
}

