/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.WindowsAssociation;
import java.io.IOException;
import org.limewire.util.SystemUtils;

public class WindowsProtocolShellAssociation
extends WindowsAssociation {
    private static final String HKCU = "HKEY_CURRENT_USER";
    private final String protocol;
    private final String name;

    public WindowsProtocolShellAssociation(String executable, String protocol, String name) {
        super(executable);
        this.protocol = "Software\\Classes\\" + protocol;
        this.name = name;
    }

    protected String get() throws IOException {
        String command = SystemUtils.registryReadText(HKCU, this.protocol + "\\shell\\open\\command", "");
        return WindowsProtocolShellAssociation.parsePath(command);
    }

    public void register() {
        SystemUtils.registryWriteText(HKCU, this.protocol, "", "URL:" + this.name);
        SystemUtils.registryWriteText(HKCU, this.protocol, "URL Protocol", "");
        SystemUtils.registryWriteText(HKCU, this.protocol + "\\DefaultIcon", "", "\"" + this.executable + "\",0");
        SystemUtils.registryWriteText(HKCU, this.protocol + "\\shell\\open\\command", "", "\"" + this.executable + "\" \"%1\"");
    }

    public void unregister() {
        SystemUtils.registryDelete(HKCU, this.protocol);
    }
}

