/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.startup;

import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImagePanel
extends JComponent
implements ComponentListener {
    private Image backgroundImage;
    private String text;
    private int labelWidth;
    private MultiLineLabel label;
    private final Dimension labelSize = new Dimension(250, 100);
    private final Point labelPosition = new Point(100, 8);
    private final float pos = 0.275f;

    public ImagePanel() {
        this(null);
    }

    public ImagePanel(String text, int labelWidth) {
        this(null, text, labelWidth);
    }

    public ImagePanel(ImageIcon image) {
        this(image, "", 0);
    }

    public ImagePanel(ImageIcon image, String text, int labelWidth) {
        this.backgroundImage = image == null ? null : image.getImage();
        this.text = text;
        this.labelWidth = labelWidth;
        this.setLayout(null);
        this.initLabel();
        this.addComponentListener(this);
    }

    private void initLabel() {
        this.label = new MultiLineLabel(this.text, this.labelWidth, true);
        this.label.setFont(new Font("Dialog", 0, 12));
        this.label.setForeground(Color.BLACK);
        this.label.setLocation(this.labelPosition);
        this.label.setSize(this.labelSize);
        this.add(this.label);
    }

    public void paintComponent(Graphics g) {
        super.paintComponents(g);
        if (this.backgroundImage != null && this.backgroundImage.getWidth(this) > 0 && this.backgroundImage.getHeight(this) > 0) {
            g.drawImage(this.backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.repaint();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setLabelWidth(int width) {
        this.labelWidth = width;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        int labelStartPos = (int)((float)this.getWidth() * 0.275f);
        this.label.setLocation(labelStartPos, this.labelPosition.y);
        this.label.setSize(new Dimension(this.getWidth() - labelStartPos - 5, this.getHeight()));
    }
}

