/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.swtbrowser;

import java.awt.Canvas;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SWTBrowser {
    private final Display display;
    private final Shell shell;
    private final Browser browser;

    public SWTBrowser(Canvas canvas, int width, int height, LocationListener lis) {
        try {
            this.display = new Display();
            this.shell = SWT_AWT.new_Shell((Display)this.display, (Canvas)canvas);
            this.shell.setLayout((Layout)new GridLayout());
            this.browser = new Browser((Composite)this.shell, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            if (lis != null) {
                this.browser.addLocationListener(lis);
            }
            this.browser.addTitleListener(new TitleListener(){

                public void changed(TitleEvent event) {
                    SWTBrowser.this.shell.setText(event.title);
                }
            });
            this.shell.setSize(width, height);
            this.shell.open();
        }
        catch (Throwable e) {
            this.cleanUp();
            throw new IllegalStateException("Browser could not be initialized", e);
        }
    }

    public void start(String url) {
        this.setUrl(url);
        while (!this.shell.isDisposed()) {
            try {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            catch (ArrayIndexOutOfBoundsException e) {
            }
            catch (StackOverflowError stackOverflowError) {}
        }
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.shell != null) {
            this.shell.dispose();
        }
        if (this.browser != null) {
            this.browser.dispose();
        }
    }

    public final void setUrl(final String u) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                SWTBrowser.this.browser.setUrl(u);
            }
        });
    }

    public final void stop() {
        this.display.asyncExec(new Runnable(){

            public void run() {
                SWTBrowser.this.browser.stop();
            }
        });
    }

    public final void back() {
        this.display.asyncExec(new Runnable(){

            public void run() {
                SWTBrowser.this.browser.back();
            }
        });
    }

    public void forward() {
        this.display.asyncExec(new Runnable(){

            public void run() {
                SWTBrowser.this.browser.forward();
            }
        });
    }

    public void addProgressListener(ProgressListener listener) {
        this.browser.addProgressListener(listener);
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.browser.addStatusTextListener(listener);
    }

    public boolean isBackEnabled() {
        return this.browser.isBackEnabled();
    }

    public boolean isForwardEnabled() {
        return this.browser.isForwardEnabled();
    }
}

