/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.tables.CenteredHolder;
import com.limegroup.gnutella.gui.tables.CenteredRenderer;
import com.limegroup.gnutella.gui.tables.ChatHolder;
import com.limegroup.gnutella.gui.tables.ChatRenderer;
import com.limegroup.gnutella.gui.tables.ColorRenderer;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.ColumnSelectionMenu;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.DateRenderer;
import com.limegroup.gnutella.gui.tables.DefaultColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.DeletableCellEditor;
import com.limegroup.gnutella.gui.tables.FlexibleColumnResizeAdapter;
import com.limegroup.gnutella.gui.tables.HeaderMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.IconAndNameRenderer;
import com.limegroup.gnutella.gui.tables.IconRenderer;
import com.limegroup.gnutella.gui.tables.KeyTypedMover;
import com.limegroup.gnutella.gui.tables.LicenseRenderer;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LinkRenderer;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.RemoveListener;
import com.limegroup.gnutella.gui.tables.SelectionListener;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.licenses.License;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableMediator<T extends DataLineModel<E, I>, E extends DataLine<I>, I>
implements ComponentMediator<I>,
HeaderMouseObserver,
ThemeObserver {
    protected final String ID;
    protected PaddedPanel MAIN_PANEL;
    protected T DATA_MODEL;
    protected LimeJTable TABLE;
    protected ButtonRow BUTTON_ROW;
    public ActionListener REMOVE_LISTENER;
    public MouseListener DEFAULT_LISTENER;
    public MouseInputListener HEADER_LISTENER;
    public ListSelectionListener SELECTION_LISTENER;
    public KeyListener AUTO_NAVIGATION_KEY_LISTENER;
    public TableSettings SETTINGS;
    protected static final TableCellRenderer SPEED_RENDERER = new SpeedRenderer();
    protected static final TableCellRenderer PROGRESS_BAR_RENDERER = new ProgressBarRenderer();
    protected static final TableCellRenderer CHAT_RENDERER = new ChatRenderer();
    protected static final TableCellRenderer COLOR_RENDERER = new ColorRenderer();
    protected static final TableCellRenderer ICON_RENDERER = new IconRenderer();
    protected static final TableCellRenderer ICON_AND_NAME_RENDERER = new IconAndNameRenderer();
    protected static final TableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    protected static final TableCellRenderer CENTER_RENDERER = new CenteredRenderer();
    protected static final TableCellRenderer LICENSE_RENDERER = new LicenseRenderer();
    protected static final TableCellRenderer DATE_RENDERER = new DateRenderer();
    protected static final TableCellRenderer LINK_RENDERER = new LinkRenderer();
    protected static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    protected Resorter RESORTER = new Resorter();
    protected JComponent TABLE_PANE;
    protected JScrollPane SCROLL_PANE;
    protected boolean isResorting = false;

    protected AbstractTableMediator(String id) {
        this.ID = id;
        this.updateSplashScreen();
        this.buildSettings();
        this.buildListeners();
        this.setupConstants();
        assert (this.DATA_MODEL != null) : "DATA_MODEL not set.";
        assert (this.TABLE != null) : "TABLE not set.";
        this.setupTable();
        this.setupDragAndDrop();
        this.addActions();
        this.addListeners();
        this.setDefaultRenderers();
        this.setDefaultEditors();
        this.setupMainPanel();
        this.setupTableHeaders();
        this.handleNoSelection();
    }

    protected void setupDragAndDrop() {
    }

    protected abstract void updateSplashScreen();

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID);
    }

    protected abstract void setupConstants();

    protected void buildListeners() {
        this.DEFAULT_LISTENER = new DefaultMouseListener(this);
        this.SELECTION_LISTENER = new SelectionListener(this);
        this.HEADER_LISTENER = new HeaderMouseListener(this);
        this.REMOVE_LISTENER = new RemoveListener(this);
        this.AUTO_NAVIGATION_KEY_LISTENER = new KeyTypedMover();
    }

    protected void addListeners() {
        this.TABLE.addMouseListener(this.DEFAULT_LISTENER);
        this.TABLE.getSelectionModel().addListSelectionListener(this.SELECTION_LISTENER);
        this.TABLE.getTableHeader().addMouseListener(this.HEADER_LISTENER);
        this.TABLE.getTableHeader().addMouseMotionListener(this.HEADER_LISTENER);
        this.TABLE.addKeyListener(this.AUTO_NAVIGATION_KEY_LISTENER);
    }

    protected void setupTable() {
        this.TABLE.setRowHeight(this.TABLE.getRowHeight() + 1);
        this.TABLE.setShowGrid(false);
        this.TABLE.setIntercellSpacing(ZERO_DIMENSION);
        this.TABLE.setColumnSelectionAllowed(false);
        this.TABLE.setTableSettings(this.SETTINGS);
        this.TABLE.getTableHeader().addMouseListener(new FlexibleColumnResizeAdapter());
    }

    protected void addActions() {
        InputMap map = this.TABLE.getInputMap(1);
        AbstractAction enter = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AbstractTableMediator.this.handleActionKey();
            }
        };
        this.installAction(map, enter, 10, "limewire.action");
        AbstractAction delete = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (!AbstractTableMediator.this.TABLE.isEditing() || AbstractTableMediator.this.TABLE.getCellEditor() instanceof DeletableCellEditor) {
                    AbstractTableMediator.this.removeSelection();
                }
            }
        };
        this.installAction(map, delete, 8, "limewire.delete");
        this.installAction(map, delete, 127, "limewire.delete");
    }

    private void installAction(InputMap map, Action action, int key, String sig) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key, 0);
        Object obj = map.get(stroke);
        if (obj != null) {
            this.TABLE.getActionMap().put(obj, action);
        } else {
            map.put(stroke, sig);
            this.TABLE.getActionMap().put(sig, action);
        }
    }

    protected void setDefaultRenderers() {
        this.TABLE.setDefaultRenderer(ProgressBarHolder.class, PROGRESS_BAR_RENDERER);
        this.TABLE.setDefaultRenderer(ChatHolder.class, CHAT_RENDERER);
        this.TABLE.setDefaultRenderer(ColoredCell.class, COLOR_RENDERER);
        this.TABLE.setDefaultRenderer(Icon.class, ICON_RENDERER);
        this.TABLE.setDefaultRenderer(IconAndNameHolder.class, ICON_AND_NAME_RENDERER);
        this.TABLE.setDefaultRenderer(Object.class, DEFAULT_RENDERER);
        this.TABLE.setDefaultRenderer(CenteredHolder.class, CENTER_RENDERER);
        this.TABLE.setDefaultRenderer(License.class, LICENSE_RENDERER);
        this.TABLE.setDefaultRenderer(SpeedRenderer.class, SPEED_RENDERER);
        this.TABLE.setDefaultRenderer(Date.class, DATE_RENDERER);
    }

    protected void setDefaultEditors() {
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            if (this.BUTTON_ROW != null) {
                this.MAIN_PANEL.add(Box.createVerticalStrut(6));
                this.MAIN_PANEL.add(this.BUTTON_ROW);
            }
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        }
    }

    protected void setupTableHeaders() {
        ColumnPreferenceHandler cph = this.createDefaultColumnPreferencesHandler();
        cph.setWidths();
        cph.setOrder();
        cph.setVisibility();
        this.TABLE.setColumnPreferenceHandler(cph);
    }

    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new DefaultColumnPreferenceHandler(this.TABLE);
    }

    protected JComponent getScrolledTablePane() {
        if (this.TABLE_PANE != null) {
            return this.TABLE_PANE;
        }
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BoxLayout(tablePane, 1));
        this.SCROLL_PANE = new JScrollPane(this.TABLE);
        JPanel corner = new JPanel();
        corner.setBackground(this.TABLE.getTableHeader().getBackground());
        corner.setBorder(BorderFactory.createBevelBorder(0));
        this.SCROLL_PANE.setCorner("UPPER_RIGHT_CORNER", corner);
        tablePane.add(this.SCROLL_PANE);
        this.TABLE_PANE = tablePane;
        this.updateTheme();
        return tablePane;
    }

    @Override
    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        if (this.TABLE_PANE == null) {
            return;
        }
        this.TABLE_PANE.setBackground(tableColor);
        this.TABLE.setBackground(tableColor);
        this.TABLE.setOpaque(true);
        this.SCROLL_PANE.getViewport().setBackground(tableColor);
    }

    @Override
    public void add(I o) {
        this.add(o, -1);
    }

    public void add(I o, int index) {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        boolean inView = this.TABLE.isSelectionVisible();
        int addedAt = this.SETTINGS.REAL_TIME_SORT.getValue() && this.DATA_MODEL.isSorted() ? this.DATA_MODEL.addSorted(o) : (index >= 0 && index < this.DATA_MODEL.getRowCount() ? this.DATA_MODEL.add(o, index) : this.DATA_MODEL.add(o));
        this.fixSelection(addedAt, inView);
    }

    public void addUnsorted(I o) {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        boolean inView = this.TABLE.isSelectionVisible();
        int addedAt = this.DATA_MODEL.add(o);
        this.fixSelection(addedAt, inView);
    }

    protected void fixSelection(int addedAt, boolean inView) {
        if (addedAt >= 0 && addedAt < this.DATA_MODEL.getRowCount()) {
            this.TABLE.removeRowSelectionInterval(addedAt, addedAt);
            int selected = this.TABLE.getSelectedRow();
            if (selected >= 0 && selected < this.DATA_MODEL.getRowCount()) {
                this.TABLE.addRowSelectionInterval(selected, selected);
                if (inView) {
                    this.TABLE.ensureRowVisible(selected);
                }
            }
        }
    }

    @Override
    public void remove(I o) {
        int idx = this.DATA_MODEL.getRow(o);
        if (idx != -1) {
            this.removeRow(idx);
        }
    }

    public void removeRow(int row) {
        this.DATA_MODEL.remove(row);
    }

    public void moveRow(int oldLocation, int newLocation) {
        if (oldLocation < 0 || oldLocation >= this.DATA_MODEL.getRowCount()) {
            throw new IllegalArgumentException("index " + oldLocation + " must be >= 0 and < TABLE.getRowCount()");
        }
        if (newLocation < 0 || newLocation >= this.DATA_MODEL.getRowCount()) {
            throw new IllegalArgumentException("add index " + newLocation + " must be >= 0 and < TABLE.getRowCount()");
        }
        Object e = this.DATA_MODEL.get((int)oldLocation);
        this.DATA_MODEL.remove(oldLocation);
        this.DATA_MODEL.add(e, newLocation);
    }

    @Override
    public void refresh() {
        if (this.TABLE.isShowing()) {
            this.doRefresh();
            this.resort();
        }
    }

    protected void doRefresh() {
        this.DATA_MODEL.refresh();
    }

    @Override
    public void update(I o) {
        this.DATA_MODEL.update(o);
        this.resort();
    }

    public void resort() {
        this.RESORTER.doResort(false);
    }

    public void forceResort() {
        this.RESORTER.doResort(true);
    }

    @Override
    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    @Override
    public void removeSelection() {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        for (int counter = sel.length - 1; counter >= 0; --counter) {
            int i = sel[counter];
            this.DATA_MODEL.remove(i);
        }
        this.clearSelection();
    }

    protected JPopupMenu createColumnSelectionMenu() {
        return new ColumnSelectionMenu(this.TABLE).getComponent();
    }

    @Override
    public void handleMouseDoubleClick(MouseEvent e) {
        this.handleActionKey();
    }

    @Override
    public void handleRightMouseClick(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.TABLE.rowAtPoint(p);
        if (row < 0) {
            return;
        }
        if (!this.TABLE.getSelectionModel().isSelectedIndex(row)) {
            this.TABLE.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    @Override
    public void handlePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        this.handleRightMouseClick(e);
        JPopupMenu menu = this.createPopupMenu();
        if (menu != null) {
            try {
                menu.show(this.TABLE, p.x + 1, p.y - 6);
            }
            catch (IllegalComponentStateException icse) {
                // empty catch block
            }
        }
    }

    @Override
    public void handleHeaderColumnLeftClick(Point p) {
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        int c = this.TABLE.convertColumnIndexToModel(col);
        int oldC = this.DATA_MODEL.getSortColumn();
        if (c != -1) {
            this.sortAndMaintainSelection(c);
            th.repaint(th.getHeaderRect(col));
            if (oldC != -1 && oldC != c) {
                int oldCol = this.TABLE.convertColumnIndexToView(oldC);
                th.repaint(th.getHeaderRect(oldCol));
            }
        }
    }

    @Override
    public void handleHeaderPopupMenu(Point p) {
        this.createColumnSelectionMenu().show(this.TABLE.getTableHeader(), p.x + 1, p.y - 6);
    }

    @Override
    public void handleHeaderColumnPressed(Point p) {
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        int c = this.TABLE.convertColumnIndexToModel(col);
        if (c != -1) {
            this.TABLE.setPressedColumnIndex(c);
            th.repaint(th.getHeaderRect(col));
        }
    }

    @Override
    public void handleHeaderColumnReleased(Point p) {
        this.TABLE.setPressedColumnIndex(-1);
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        if (col != -1) {
            th.repaint(th.getHeaderRect(col));
        }
    }

    @Override
    public void setButtonEnabled(int buttonIdx, boolean enabled) {
        if (this.BUTTON_ROW != null) {
            this.BUTTON_ROW.setButtonEnabled(buttonIdx, enabled);
        }
    }

    public int getSize() {
        return this.DATA_MODEL.getRowCount();
    }

    public void clearTable() {
        this.DATA_MODEL.clear();
        this.handleNoSelection();
    }

    protected void clearSelection() {
        this.TABLE.clearSelection();
        this.handleNoSelection();
    }

    protected void sortAndMaintainSelection(int columnToSort) {
        int i;
        int[] rows = this.TABLE.getSelectedRows();
        DataLine[] dls = new DataLine[rows.length];
        DataLine inView = null;
        for (i = 0; i < rows.length; ++i) {
            dls[i] = this.DATA_MODEL.get((int)rows[i]);
            if (inView != null || !this.TABLE.isRowVisible(rows[i])) continue;
            inView = dls[i];
        }
        if (columnToSort == -1) {
            this.DATA_MODEL.resort();
        } else {
            this.DATA_MODEL.sort(columnToSort);
        }
        for (i = 0; i < rows.length; ++i) {
            int sel = this.DATA_MODEL.getRow((DataLine)dls[i]);
            this.TABLE.addRowSelectionInterval(sel, sel);
            if (inView != dls[i]) continue;
            this.TABLE.ensureRowVisible(sel);
            inView = null;
        }
    }

    protected abstract JPopupMenu createPopupMenu();

    static int compare(Object o1, Object o2) {
        int retval = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1.getClass() == String.class ? StringUtils.compareFullPrimary((String)o1, (String)o2) : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0))));
        return retval;
    }

    boolean isResorting() {
        return this.isResorting;
    }

    protected final class Resorter
    implements Runnable {
        private boolean active = false;
        private boolean force = false;

        protected Resorter() {
        }

        public void doResort(boolean isForce) {
            if (!this.active && AbstractTableMediator.this.SETTINGS.REAL_TIME_SORT.getValue() && AbstractTableMediator.this.TABLE.isShowing()) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
            this.force |= isForce;
        }

        public void run() {
            try {
                if (!AbstractTableMediator.this.TABLE.isEditing() && (this.force || AbstractTableMediator.this.DATA_MODEL.needsResort())) {
                    AbstractTableMediator.this.isResorting = true;
                    AbstractTableMediator.this.sortAndMaintainSelection(-1);
                    AbstractTableMediator.this.isResorting = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.active = false;
            this.force = false;
        }
    }
}

