/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SimpleColumnListener;
import com.limegroup.gnutella.settings.TablesHandler;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class DefaultColumnPreferenceHandler
implements ColumnPreferenceHandler,
TableColumnModelListener,
MouseListener {
    protected final LimeJTable table;
    protected SimpleColumnListener listener = null;
    protected boolean marginChanged;

    public DefaultColumnPreferenceHandler(LimeJTable t) {
        this.table = t;
        this.startListening();
    }

    public void setSimpleColumnListener(SimpleColumnListener scl) {
        this.listener = scl;
    }

    public void columnAdded(TableColumnModelEvent e) {
        LimeTableColumn addedColumn;
        LimeTableColumn ltc = addedColumn = this.getToColumn(e);
        this.setVisibility(ltc, true);
        TableColumnModel tcm = this.table.getColumnModel();
        int order = this.getOrder(ltc);
        int current = tcm.getColumnIndex(ltc.getId());
        int max = tcm.getColumnCount();
        if (order != current) {
            this.stopListening();
            order = Math.min(order, max - 1);
            tcm.moveColumn(current, order);
            for (current = order + 1; current < max; ++current) {
                ltc = (LimeTableColumn)tcm.getColumn(current);
                this.setOrder(ltc, current);
            }
            Iterator<LimeTableColumn> i = this.table.getHiddenColumns();
            while (i.hasNext()) {
                ltc = i.next();
                current = this.getOrder(ltc);
                if (current <= order) continue;
                this.setOrder(ltc, current + 1);
            }
            this.startListening();
        }
        if (this.listener != null) {
            this.listener.columnAdded(addedColumn, this.table);
        }
        this.save();
    }

    public void columnMarginChanged(ChangeEvent e) {
        if (this.table.getTableHeader().getResizingColumn() == null) {
            return;
        }
        this.marginChanged = true;
    }

    public void columnMoved(TableColumnModelEvent e) {
        if (e.getFromIndex() == e.getToIndex()) {
            return;
        }
        LimeTableColumn from = this.getFromColumn(e);
        LimeTableColumn to = this.getToColumn(e);
        this.setOrder(from, e.getFromIndex());
        this.setOrder(to, e.getToIndex());
        this.save();
    }

    public void columnRemoved(TableColumnModelEvent e) {
        LimeTableColumn removedColumn;
        LimeTableColumn ltc;
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            ltc = (LimeTableColumn)tcm.getColumn(i);
            this.setOrder(ltc, i);
        }
        ltc = removedColumn = this.table.getLastRemovedColumn();
        this.setVisibility(ltc, false);
        int order = this.getOrder(ltc);
        Iterator<LimeTableColumn> i = this.table.getHiddenColumns();
        while (i.hasNext()) {
            ltc = i.next();
            int current = this.getOrder(ltc);
            if (current <= order) continue;
            this.setOrder(ltc, current - 1);
        }
        if (this.listener != null) {
            this.listener.columnRemoved(removedColumn, this.table);
        }
        this.save();
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.marginChanged) {
            return;
        }
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            LimeTableColumn ltc = (LimeTableColumn)tcm.getColumn(i);
            this.setWidth(ltc, ltc.getWidth());
        }
        this.marginChanged = false;
        this.save();
    }

    public void revertToDefault() {
        LimeTableColumn ltc;
        int i;
        this.stopListening();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        for (int i2 = 0; i2 < dlm.getColumnCount(); ++i2) {
            LimeTableColumn ltc2 = dlm.getTableColumn(i2);
            this.setVisibility(ltc2, ltc2.getDefaultVisibility());
            this.setOrder(ltc2, ltc2.getDefaultOrder());
            this.setWidth(ltc2, ltc2.getDefaultWidth());
            try {
                if (this.table.isColumnVisible(ltc2.getId())) continue;
                this.table.setColumnVisible(ltc2.getId(), true);
                if (this.listener == null) continue;
                this.listener.columnAdded(ltc2, this.table);
                continue;
            }
            catch (LastColumnException impossible) {
                // empty catch block
            }
        }
        TableColumnModel tcm = this.table.getColumnModel();
        for (i = 0; i < dlm.getColumnCount(); ++i) {
            ltc = dlm.getTableColumn(i);
            int order = this.getOrder(ltc);
            int current = tcm.getColumnIndex(ltc.getId());
            if (current != order) {
                tcm.moveColumn(current, order);
            }
            ltc.setPreferredWidth(ltc.getDefaultWidth());
        }
        for (i = 0; i < dlm.getColumnCount(); ++i) {
            ltc = dlm.getTableColumn(i);
            boolean wantVis = this.getVisibility(ltc);
            try {
                if (wantVis) continue;
                this.table.setColumnVisible(ltc.getId(), false);
                if (this.listener == null) continue;
                this.listener.columnRemoved(ltc, this.table);
                continue;
            }
            catch (LastColumnException ignored) {
                // empty catch block
            }
        }
        this.startListening();
        this.save();
    }

    public boolean isDefault() {
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dlm.getColumnCount(); ++i) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            if (!this.isDefaultWidth(ltc)) {
                return false;
            }
            if (!this.isDefaultOrder(ltc)) {
                return false;
            }
            if (this.isDefaultVisibility(ltc)) continue;
            return false;
        }
        return true;
    }

    public void setWidths() {
        this.stopListening();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dlm.getColumnCount(); ++i) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            int width = this.getWidth(ltc);
            if (width == -1) continue;
            ltc.setPreferredWidth(width);
        }
        this.startListening();
    }

    public void setOrder() {
        this.stopListening();
        boolean changed = false;
        TableColumnModel tcm = this.table.getColumnModel();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        int max = dlm.getColumnCount();
        for (int i = 0; i < max; ++i) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            int order = this.getOrder(ltc);
            if (!this.table.isColumnVisible(ltc.getId())) continue;
            int current = tcm.getColumnIndex(ltc.getId());
            if (order >= max) {
                order = max - 1;
                this.setOrder(ltc, order);
                changed = true;
            }
            if (current == order) continue;
            tcm.moveColumn(current, order);
        }
        if (changed) {
            TablesHandler.instance().save();
        }
        this.startListening();
    }

    public void setVisibility() {
        this.stopListening();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dlm.getColumnCount(); ++i) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            boolean wantVis = this.getVisibility(ltc);
            boolean isVis = this.table.isColumnVisible(ltc.getId());
            try {
                if (wantVis && !isVis) {
                    this.table.setColumnVisible(ltc.getId(), true);
                    if (this.listener == null) continue;
                    this.listener.columnAdded(ltc, this.table);
                    continue;
                }
                if (wantVis || !isVis) continue;
                this.table.setColumnVisible(ltc.getId(), false);
                if (this.listener == null) continue;
                this.listener.columnRemoved(ltc, this.table);
                continue;
            }
            catch (LastColumnException ee) {
                // empty catch block
            }
        }
        this.startListening();
    }

    protected void save() {
        TablesHandler.instance().save();
    }

    protected void startListening() {
        this.table.getTableHeader().addMouseListener(this);
        this.table.getColumnModel().addColumnModelListener(this);
    }

    protected void stopListening() {
        this.table.getTableHeader().removeMouseListener(this);
        this.table.getColumnModel().removeColumnModelListener(this);
    }

    protected LimeTableColumn getToColumn(TableColumnModelEvent e) {
        return (LimeTableColumn)this.table.getColumnModel().getColumn(e.getToIndex());
    }

    protected LimeTableColumn getFromColumn(TableColumnModelEvent e) {
        return (LimeTableColumn)this.table.getColumnModel().getColumn(e.getFromIndex());
    }

    protected void setVisibility(LimeTableColumn col, boolean vis) {
        TablesHandler.getVisibility(col.getId(), col.getDefaultVisibility()).setValue(vis);
    }

    protected void setOrder(LimeTableColumn col, int order) {
        TablesHandler.getOrder(col.getId(), col.getDefaultOrder()).setValue(order);
    }

    protected void setWidth(LimeTableColumn col, int width) {
        TablesHandler.getWidth(col.getId(), col.getDefaultWidth()).setValue(width);
    }

    protected boolean getVisibility(LimeTableColumn col) {
        return TablesHandler.getVisibility(col.getId(), col.getDefaultVisibility()).getValue();
    }

    protected int getOrder(LimeTableColumn col) {
        return TablesHandler.getOrder(col.getId(), col.getDefaultOrder()).getValue();
    }

    protected int getWidth(LimeTableColumn col) {
        return TablesHandler.getWidth(col.getId(), col.getDefaultWidth()).getValue();
    }

    protected boolean isDefaultVisibility(LimeTableColumn col) {
        return TablesHandler.getVisibility(col.getId(), col.getDefaultVisibility()).isDefault();
    }

    protected boolean isDefaultOrder(LimeTableColumn col) {
        return TablesHandler.getOrder(col.getId(), col.getDefaultOrder()).isDefault();
    }

    protected boolean isDefaultWidth(LimeTableColumn col) {
        return TablesHandler.getWidth(col.getId(), col.getDefaultWidth()).isDefault();
    }
}

