/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.limewire.util.NameValue;

class LicenseRenderer
extends DefaultTableCellRenderer
implements ThemeObserver {
    private Icon CC_NOT_VALIDATED = null;
    private Icon WEED_NOT_VALIDATED = null;
    private Icon UNKNOWN_NOT_VALIDATED = null;

    public LicenseRenderer() {
        this.setHorizontalAlignment(0);
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this.CC_NOT_VALIDATED = null;
        this.WEED_NOT_VALIDATED = null;
        this.UNKNOWN_NOT_VALIDATED = null;
    }

    private Icon getIcon(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals("Creative Commons License")) {
            return GUIMediator.getThemeImage("cc");
        }
        if (s.equals("Weed License")) {
            return GUIMediator.getThemeImage("weed");
        }
        if (s.equals("Unknown License")) {
            return GUIMediator.getThemeImage("forms_small");
        }
        return null;
    }

    private Icon getDisabledIcon(String s) {
        if (s == null) {
            return null;
        }
        if (s.equals("Creative Commons License")) {
            if (this.CC_NOT_VALIDATED == null) {
                this.CC_NOT_VALIDATED = ImageManipulator.gray(this.getIcon(s));
            }
            return this.CC_NOT_VALIDATED;
        }
        if (s.equals("Weed License")) {
            if (this.WEED_NOT_VALIDATED == null) {
                this.WEED_NOT_VALIDATED = ImageManipulator.gray(this.getIcon(s));
            }
            return this.WEED_NOT_VALIDATED;
        }
        if (s.equals("Unknown License")) {
            if (this.UNKNOWN_NOT_VALIDATED == null) {
                this.UNKNOWN_NOT_VALIDATED = ImageManipulator.gray(this.getIcon(s));
            }
            return this.UNKNOWN_NOT_VALIDATED;
        }
        return null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        NameValue nv = (NameValue)value;
        super.getTableCellRendererComponent(table, value, isSel, hasFocus, row, column);
        this.setText(null);
        if (nv != null) {
            Integer e = (Integer)nv.getValue();
            int i = e;
            switch (i) {
                case 2: {
                    this.setIcon(this.getIcon(nv.getName()));
                    break;
                }
                case 0: {
                    this.setIcon(this.getDisabledIcon(nv.getName()));
                    break;
                }
                default: {
                    this.setIcon(null);
                    break;
                }
            }
        } else {
            this.setIcon(null);
        }
        return this;
    }
}

