/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tabs.Tab;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;

abstract class AbstractTab
implements Tab {
    private String title;
    private String toolTip;
    private Icon icon;
    private String iconFile;
    private final PropertyChangeSupport propertyChangeSupport;

    AbstractTab(String title, String tooltip, String icon) {
        this.title = title;
        this.toolTip = tooltip;
        this.iconFile = icon;
        this.icon = GUIMediator.getThemeImage(this.iconFile);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public abstract void storeState(boolean var1);

    public abstract JComponent getComponent();

    public String getTitle() {
        return this.title;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getIconName() {
        return this.iconFile;
    }

    public String toString() {
        return this.title + " tab";
    }

    void changeTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        this.propertyChangeSupport.firePropertyChange("title", oldTitle, newTitle);
    }

    void changeTooltip(String newTooltip) {
        String oldTooltip = this.toolTip;
        this.toolTip = newTooltip;
        this.propertyChangeSupport.firePropertyChange("tooltip", oldTooltip, newTooltip);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void mouseClicked() {
    }
}

