/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.swtbrowser.SWTBrowserPanel;
import com.limegroup.gnutella.gui.tabs.AbstractTab;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SWTBrowserSettings;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

public final class SWTBrowserSearchTab
extends AbstractTab {
    private final SWTBrowserPanel COMPONENT = new SWTBrowserPanel();

    public SWTBrowserSearchTab() {
        super(I18n.tr(GUIUtils.stripAmpersand(SWTBrowserSettings.getTitleSetting().getValue())), I18n.tr(SWTBrowserSettings.getTooltipSetting().getValue()), "browser_tab");
        SettingListener listener = new SettingListener(){

            public void settingChanged(final SettingEvent evt) {
                if (evt.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (evt.getSetting() == SWTBrowserSettings.getTitleSetting()) {
                                SWTBrowserSearchTab.this.changeTitle(I18n.tr(GUIUtils.stripAmpersand(SWTBrowserSettings.getTitleSetting().getValue())));
                            } else if (evt.getSetting() == SWTBrowserSettings.getTooltipSetting()) {
                                SWTBrowserSearchTab.this.changeTooltip(I18n.tr(SWTBrowserSettings.getTooltipSetting().getValue()));
                            }
                        }
                    });
                }
            }
        };
        SWTBrowserSettings.getTitleSetting().addSettingListener(listener);
        SWTBrowserSettings.getTooltipSetting().addSettingListener(listener);
    }

    public final void storeState(boolean visible) {
        ApplicationSettings.SWT_BROWSER_VIEW_ENABLED.setValue(visible);
        if (visible) {
            this.COMPONENT.createBrowser();
        } else {
            this.COMPONENT.destroyBrowser();
        }
    }

    public final JComponent getComponent() {
        return this.COMPONENT;
    }

    public void mouseClicked() {
        this.COMPONENT.createBrowser();
    }
}

