/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.setting.ColorSetting;
import org.limewire.setting.FontNameSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class ThemeFileHandler {
    private static Log LOG = LogFactory.getLog(ThemeFileHandler.class);
    private static final int CURRENT_VERSION = 2;
    private static SettingsFactory FACTORY;
    public static final FontNameSetting CONTROL_TEXT_FONT_NAME;
    public static final IntSetting CONTROL_TEXT_FONT_STYLE;
    public static final IntSetting CONTROL_TEXT_FONT_SIZE;
    public static final FontNameSetting SYSTEM_TEXT_FONT_NAME;
    public static final IntSetting SYSTEM_TEXT_FONT_STYLE;
    public static final IntSetting SYSTEM_TEXT_FONT_SIZE;
    public static final FontNameSetting USER_TEXT_FONT_NAME;
    public static final IntSetting USER_TEXT_FONT_STYLE;
    public static final IntSetting USER_TEXT_FONT_SIZE;
    public static final FontNameSetting MENU_TEXT_FONT_NAME;
    public static final IntSetting MENU_TEXT_FONT_STYLE;
    public static final IntSetting MENU_TEXT_FONT_SIZE;
    public static final FontNameSetting WINDOW_TITLE_FONT_NAME;
    public static final IntSetting WINDOW_TITLE_FONT_STYLE;
    public static final IntSetting WINDOW_TITLE_FONT_SIZE;
    public static final FontNameSetting SUB_TEXT_FONT_NAME;
    public static final IntSetting SUB_TEXT_FONT_STYLE;
    public static final IntSetting SUB_TEXT_FONT_SIZE;
    public static final ColorSetting PRIMARY1_COLOR;
    public static final ColorSetting PRIMARY2_COLOR;
    public static final ColorSetting PRIMARY3_COLOR;
    public static final ColorSetting SECONDARY1_COLOR;
    public static final ColorSetting SECONDARY2_COLOR;
    public static final ColorSetting SECONDARY3_COLOR;
    public static final ColorSetting WINDOW1_COLOR;
    public static final ColorSetting WINDOW2_COLOR;
    public static final ColorSetting WINDOW3_COLOR;
    public static final ColorSetting WINDOW4_COLOR;
    public static final ColorSetting WINDOW5_COLOR;
    public static final ColorSetting WINDOW6_COLOR;
    public static final ColorSetting WINDOW7_COLOR;
    public static final ColorSetting WINDOW8_COLOR;
    public static final ColorSetting WINDOW9_COLOR;
    public static final ColorSetting WINDOW10_COLOR;
    public static final ColorSetting WINDOW11_COLOR;
    public static final ColorSetting WINDOW12_COLOR;
    public static final ColorSetting TABLE_HEADER_BACKGROUND_COLOR;
    public static final ColorSetting TABLE_BACKGROUND_COLOR;
    public static final ColorSetting TABLE_ALTERNATE_COLOR;
    public static final ColorSetting TABLE_SPECIAL_BACKGROUND_COLOR;
    public static final ColorSetting TABLE_SPECIAL_ALTERNATE_COLOR;
    public static final ColorSetting NOT_SHARING_LABEL_COLOR;
    public static final ColorSetting SEARCH_RESULT_SPEED_COLOR;
    public static final ColorSetting SEARCH_SPAM_RESULT_COLOR;
    public static final ColorSetting PLAYING_SONG_COLOR;
    public static final ColorSetting SEARCH_IP_COLOR;
    public static final ColorSetting SEARCH_PRIVATE_IP_COLOR;
    public static final ColorSetting SEARCH_SELECTED_PRIVATE_IP_COLOR;
    public static final ColorSetting FILTER_TITLE_TOP_COLOR;
    public static final ColorSetting FILTER_TITLE_COLOR;
    public static final ColorSetting SEARCH_GRID_COLOR;
    public static final ColorSetting SEARCH_PANEL_BG_1;
    public static final ColorSetting SEARCH_PANEL_BG_2;
    public static final IntSetting VERSION;

    private ThemeFileHandler() {
    }

    public static void reload(boolean force) {
        String contents;
        File themeFile = ThemeSettings.THEME_FILE.getValue();
        if (!ThemeSettings.isThemeFile(themeFile)) {
            ThemeSettings.THEME_FILE.revertToDefault();
        }
        themeFile = ThemeSettings.THEME_FILE.getValue();
        File themeDir = ThemeSettings.extractThemeDir(themeFile);
        boolean forceNewLWTP = false;
        File themeVersionFile = new File(themeDir, "version.txt");
        if (!(force || !themeDir.isDirectory() || (contents = ThemeFileHandler.contentsOf(themeVersionFile)) != null && contents.equals(LimeWireUtils.getLimeWireVersion()))) {
            force = true;
            forceNewLWTP = true;
        }
        if (force || !themeDir.isDirectory()) {
            if (forceNewLWTP || !themeFile.exists()) {
                if (!ThemeSettings.JAR_THEME_NAMES.contains(themeFile.getName())) {
                    ThemeSettings.THEME_FILE.revertToDefault();
                    themeFile = ThemeSettings.THEME_FILE.getValue();
                    themeDir = ThemeSettings.extractThemeDir(themeFile);
                }
                try {
                    CommonUtils.copyResourceFile(themeFile.getName(), themeFile, true);
                }
                catch (IOException iox) {
                    LOG.warn("Couldn't extract theme!", iox);
                }
            }
            if (themeFile.exists() && !ThemeSettings.expandTheme(themeFile, themeDir, force, false)) {
                ThemeSettings.THEME_FILE.revertToDefault();
                themeFile = ThemeSettings.THEME_FILE.getValue();
                themeDir = ThemeSettings.extractThemeDir(themeFile);
                if (!themeDir.isDirectory()) {
                    ThemeSettings.expandTheme(themeFile, themeDir, false, true);
                }
            }
        }
        File THEME_PROPS = new File(themeDir, "theme.txt");
        ThemeFileHandler.handleFactory(THEME_PROPS);
        ThemeSettings.THEME_DIR.setValue(themeDir);
        if (forceNewLWTP) {
            ThemeFileHandler.writeVersion(themeVersionFile);
        }
        if (OSUtils.isMacOSX()) {
            File f = new File(CommonUtils.getUserSettingsDir(), "useBrushedMetal");
            if (ThemeSettings.isBrushedMetalTheme()) {
                try {
                    FileUtils.touch(f);
                }
                catch (IOException oops) {}
            } else {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void writeVersion(File file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(LimeWireUtils.getLimeWireVersion().getBytes("UTF8"));
            fos.flush();
        }
        catch (IOException iOException) {
            IOUtils.close(fos);
            catch (Throwable throwable) {
                IOUtils.close(fos);
                throw throwable;
            }
        }
        IOUtils.close(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String contentsOf(File file) {
        String string;
        if (!file.exists()) {
            return "";
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            byte[] bytes = new byte[(int)Math.min(file.length(), 20L)];
            raf.readFully(bytes);
            string = new String(bytes, "UTF8");
        }
        catch (IOException iox) {
            String string2;
            try {
                string2 = "";
            }
            catch (Throwable throwable) {
                IOUtils.close(raf);
                throw throwable;
            }
            IOUtils.close(raf);
            return string2;
        }
        IOUtils.close(raf);
        return string;
    }

    public static boolean isCurrent() {
        return 2 <= VERSION.getValue();
    }

    private static void handleFactory(File file) {
        if (FACTORY == null) {
            FACTORY = new SettingsFactory(file);
        } else {
            FACTORY.changeFile(file);
            ThemeFileHandler.fixFontSettings();
        }
    }

    private static void fixFontSettings() {
        ThemeFileHandler.checkFontSetting(CONTROL_TEXT_FONT_NAME, CONTROL_TEXT_FONT_STYLE, CONTROL_TEXT_FONT_SIZE);
        ThemeFileHandler.checkFontSetting(SYSTEM_TEXT_FONT_NAME, SYSTEM_TEXT_FONT_STYLE, SYSTEM_TEXT_FONT_SIZE);
        ThemeFileHandler.checkFontSetting(USER_TEXT_FONT_NAME, USER_TEXT_FONT_STYLE, USER_TEXT_FONT_SIZE);
        ThemeFileHandler.checkFontSetting(MENU_TEXT_FONT_NAME, MENU_TEXT_FONT_STYLE, MENU_TEXT_FONT_SIZE);
        ThemeFileHandler.checkFontSetting(WINDOW_TITLE_FONT_NAME, WINDOW_TITLE_FONT_STYLE, WINDOW_TITLE_FONT_SIZE);
        ThemeFileHandler.checkFontSetting(SUB_TEXT_FONT_NAME, SUB_TEXT_FONT_STYLE, SUB_TEXT_FONT_SIZE);
    }

    private static void checkFontSetting(FontNameSetting font, IntSetting style, IntSetting size) {
        if (font.getValue().toLowerCase(Locale.US).equals("verdana") && style.getValue() == 1 && size.getValue() == 10) {
            font.setValue("dialog");
            style.setValue(0);
            size.setValue(11);
        }
    }

    static {
        ThemeFileHandler.reload(false);
        CONTROL_TEXT_FONT_NAME = FACTORY.createFontNameSetting("CONTROL_TEXT_FONT_NAME", "dialog");
        CONTROL_TEXT_FONT_STYLE = FACTORY.createIntSetting("CONTROL_TEXT_FONT_STYLE", 1);
        CONTROL_TEXT_FONT_SIZE = FACTORY.createIntSetting("CONTROL_TEXT_FONT_SIZE", 11);
        SYSTEM_TEXT_FONT_NAME = FACTORY.createFontNameSetting("SYSTEM_TEXT_FONT_NAME", "dialog");
        SYSTEM_TEXT_FONT_STYLE = FACTORY.createIntSetting("SYSTEM_TEXT_FONT_STYLE", 0);
        SYSTEM_TEXT_FONT_SIZE = FACTORY.createIntSetting("SYSTEM_TEXT_FONT_SIZE", 11);
        USER_TEXT_FONT_NAME = FACTORY.createFontNameSetting("USER_TEXT_FONT_NAME", "dialog");
        USER_TEXT_FONT_STYLE = FACTORY.createIntSetting("USER_TEXT_FONT_STYLE", 0);
        USER_TEXT_FONT_SIZE = FACTORY.createIntSetting("USER_TEXT_FONT_SIZE", 11);
        MENU_TEXT_FONT_NAME = FACTORY.createFontNameSetting("MENU_TEXT_FONT_NAME", "dialog");
        MENU_TEXT_FONT_STYLE = FACTORY.createIntSetting("MENU_TEXT_FONT_STYLE", 1);
        MENU_TEXT_FONT_SIZE = FACTORY.createIntSetting("MENU_TEXT_FONT_SIZE", 11);
        WINDOW_TITLE_FONT_NAME = FACTORY.createFontNameSetting("WINDOW_TITLE_FONT_NAME", "dialog");
        WINDOW_TITLE_FONT_STYLE = FACTORY.createIntSetting("WINDOW_TITLE_FONT_STYLE", 1);
        WINDOW_TITLE_FONT_SIZE = FACTORY.createIntSetting("WINDOW_TITLE_FONT_SIZE", 11);
        SUB_TEXT_FONT_NAME = FACTORY.createFontNameSetting("SUB_TEXT_FONT_NAME", "dialog");
        SUB_TEXT_FONT_STYLE = FACTORY.createIntSetting("SUB_TEXT_FONT_STYLE", 0);
        SUB_TEXT_FONT_SIZE = FACTORY.createIntSetting("SUB_TEXT_FONT_SIZE", 10);
        PRIMARY1_COLOR = FACTORY.createColorSetting("PRIMARY1_COLOR", new Color(74, 110, 188));
        PRIMARY2_COLOR = FACTORY.createColorSetting("PRIMARY2_COLOR", new Color(135, 145, 170));
        PRIMARY3_COLOR = FACTORY.createColorSetting("PRIMARY3_COLOR", new Color(216, 225, 244));
        SECONDARY1_COLOR = FACTORY.createColorSetting("SECONDARY1_COLOR", new Color(50, 68, 107));
        SECONDARY2_COLOR = FACTORY.createColorSetting("SECONDARY2_COLOR", new Color(167, 173, 190));
        SECONDARY3_COLOR = FACTORY.createColorSetting("SECONDARY3_COLOR", new Color(199, 201, 209));
        WINDOW1_COLOR = FACTORY.createColorSetting("WINDOW1_COLOR", new Color(0, 0, 0));
        WINDOW2_COLOR = FACTORY.createColorSetting("WINDOW2_COLOR", new Color(199, 201, 209));
        WINDOW3_COLOR = FACTORY.createColorSetting("WINDOW3_COLOR", new Color(199, 201, 209));
        WINDOW4_COLOR = FACTORY.createColorSetting("WINDOW4_COLOR", new Color(0, 0, 0));
        WINDOW5_COLOR = FACTORY.createColorSetting("WINDOW5_COLOR", new Color(0, 0, 0));
        WINDOW6_COLOR = FACTORY.createColorSetting("WINDOW6_COLOR", new Color(255, 255, 255));
        WINDOW7_COLOR = FACTORY.createColorSetting("WINDOW7_COLOR", new Color(255, 255, 255));
        WINDOW8_COLOR = FACTORY.createColorSetting("WINDOW8_COLOR", new Color(0, 0, 0));
        WINDOW9_COLOR = FACTORY.createColorSetting("WINDOW9_COLOR", new Color(0, 0, 0));
        WINDOW10_COLOR = FACTORY.createColorSetting("WINDOW10_COLOR", new Color(0, 0, 0));
        WINDOW11_COLOR = FACTORY.createColorSetting("WINDOW11_COLOR", new Color(0, 0, 0));
        WINDOW12_COLOR = FACTORY.createColorSetting("WINDOW12_COLOR", new Color(199, 201, 209));
        TABLE_HEADER_BACKGROUND_COLOR = FACTORY.createColorSetting("TABLE_HEADER_BACKGROUND_COLOR", new Color(117, 142, 197));
        TABLE_BACKGROUND_COLOR = FACTORY.createColorSetting("TABLE_BACKGROUND_COLOR", new Color(255, 255, 255));
        TABLE_ALTERNATE_COLOR = FACTORY.createColorSetting("TABLE_ALTERNATE_COLOR", new Color(248, 248, 255));
        TABLE_SPECIAL_BACKGROUND_COLOR = FACTORY.createColorSetting("TABLE_SPECIAL_BACKGROUND_COLOR", new Color(255, 243, 193));
        TABLE_SPECIAL_ALTERNATE_COLOR = FACTORY.createColorSetting("TABLE_SPECIAL_ALTERNATE_COLOR", new Color(255, 222, 102));
        NOT_SHARING_LABEL_COLOR = FACTORY.createColorSetting("NOT_SHARING_LABEL_COLOR", new Color(208, 0, 5));
        SEARCH_RESULT_SPEED_COLOR = FACTORY.createColorSetting("SEARCH_RESULT_SPEED_COLOR", new Color(7, 170, 0));
        SEARCH_SPAM_RESULT_COLOR = FACTORY.createColorSetting("SEARCH_SPAM_RESAULT_COLOR", new Color(255, 125, 125));
        PLAYING_SONG_COLOR = FACTORY.createColorSetting("PLAYING_SONG_COLOR", new Color(7, 170, 0));
        SEARCH_IP_COLOR = FACTORY.createColorSetting("SEARCH_IP_COLOR", new Color(0, 0, 0));
        SEARCH_PRIVATE_IP_COLOR = FACTORY.createColorSetting("SEARCH_PRIVATE_IP_COLOR", new Color(255, 0, 0));
        SEARCH_SELECTED_PRIVATE_IP_COLOR = FACTORY.createColorSetting("SEARCH_SELECTED_PRIVATE_IP_COLOR", SEARCH_PRIVATE_IP_COLOR.getValue());
        FILTER_TITLE_TOP_COLOR = FACTORY.createColorSetting("SEARCH_FILTER_TITLE_TOP_COLOR", TABLE_HEADER_BACKGROUND_COLOR.getValue());
        FILTER_TITLE_COLOR = FACTORY.createColorSetting("SEARCH_FILTER_TITLE_COLOR", TABLE_HEADER_BACKGROUND_COLOR.getValue());
        SEARCH_GRID_COLOR = FACTORY.createColorSetting("SEARCH_GRID_COLOR", new Color(0, 0, 0));
        SEARCH_PANEL_BG_1 = FACTORY.createColorSetting("SEARCH_PANEL_BG_1", TABLE_HEADER_BACKGROUND_COLOR.getValue());
        SEARCH_PANEL_BG_2 = FACTORY.createColorSetting("SEARCH_PANEL_BG_2", TABLE_HEADER_BACKGROUND_COLOR.getValue());
        VERSION = FACTORY.createIntSetting("THEME_VERSION", 0);
        ThemeFileHandler.fixFontSettings();
    }
}

