/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.themes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.util.Expand;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThemeSettings
extends LimeProps {
    private static final Log LOG;
    public static final String EXTENSION = "lwtp";
    public static final File THEME_DIR_FILE;
    public static final String LIMEWIRE_THEME_NAME = "limewire_theme.lwtp";
    public static final String PINSTRIPES_OSX_THEME_NAME = "pinstripes_theme_osx.lwtp";
    public static final String BRUSHED_METAL_OSX_THEME_NAME = "brushed_metal_theme_osx.lwtp";
    public static final String WINDOWS_LAF_THEME_NAME = "windows_theme.lwtp";
    public static final String GTK_LAF_THEME_NAME = "GTK_theme.lwtp";
    public static final String PRO_THEME_NAME = "limewirePro_theme.lwtp";
    public static final String OTHER_THEME_NAME = "other_theme.lwtp";
    public static final File LIMEWIRE_THEME_FILE;
    static final File PINSTRIPES_OSX_THEME_FILE;
    static final File BRUSHED_METAL_OSX_THEME_FILE;
    static final File WINDOWS_LAF_THEME_FILE;
    static final File GTK_LAF_THEME_FILE;
    static final File PRO_THEME_FILE;
    static final File OTHER_THEME_FILE;
    public static final File THEME_DEFAULT;
    public static final File THEME_DEFAULT_DIR;
    public static final FileSetting THEME_FILE;
    public static final FileSetting THEME_DIR;
    public static final List<String> JAR_THEME_NAMES;
    public static final IntSetting FONT_SIZE_INCREMENT;

    private ThemeSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> scanJarFileForThemes(File jarFile) {
        ArrayList<String> themeFiles = new ArrayList<String>();
        ZipFile zf = null;
        try {
            long jarMod = jarFile.lastModified();
            zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String name = ze.getName();
                if (!name.endsWith(".lwtp")) continue;
                themeFiles.add(name);
                File existingFile = new File(THEME_DIR_FILE, name);
                File existingDir = ThemeSettings.extractThemeDir(existingFile);
                if (!existingFile.isFile() && !existingDir.isDirectory() || jarMod <= existingFile.lastModified() && jarMod <= existingDir.lastModified()) continue;
                ThemeSettings.deleteZipWithOldTimestamp(existingFile);
            }
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Collections.unmodifiableList(themeFiles);
    }

    private static File getThemesJar() {
        String url;
        URL themeURL = ThemeSettings.class.getClassLoader().getResource(LIMEWIRE_THEME_NAME);
        if (themeURL != null && (url = themeURL.toExternalForm()) != null && url.startsWith("jar:file:")) {
            url = url.substring("jar:file:".length(), url.length());
            url = url.substring(0, url.length() - LIMEWIRE_THEME_NAME.length() - "!/".length());
            return new File(url);
        }
        return null;
    }

    private static void deleteZipWithOldTimestamp(File themeFile) {
        File themeDir = ThemeSettings.extractThemeDir(themeFile);
        if (themeDir.exists()) {
            String[] children = themeDir.list();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    new File(themeDir, children[i]).delete();
                }
            }
            themeDir.delete();
        }
        themeFile.delete();
    }

    static boolean expandTheme(File themeFile, File themeDir, boolean overwrite, boolean showError) {
        themeDir.mkdirs();
        try {
            FileUtils.setWriteable(themeDir);
            Expand.expandFile(themeFile, themeDir, overwrite);
        }
        catch (ZipException ze) {
            GUIMediator.showError(I18n.tr("The theme you are applying is invalid. LimeWire will revert to the default theme."));
            return false;
        }
        catch (IOException e) {
            if (showError) {
                ErrorService.error(e);
            }
            return false;
        }
        return true;
    }

    static File extractThemeDir(File themeFile) {
        String dirName = themeFile.getName();
        dirName = dirName.substring(0, dirName.length() - 5);
        return new File(new File(CommonUtils.getUserSettingsDir(), "themes"), dirName);
    }

    static boolean isThemeFile(File f) {
        return f.getName().toLowerCase(Locale.US).endsWith(".lwtp");
    }

    public static boolean isDefaultTheme() {
        return THEME_FILE.getValue().equals(THEME_DEFAULT);
    }

    public static boolean isGTKTheme() {
        return THEME_FILE.getValue().equals(GTK_LAF_THEME_FILE);
    }

    public static boolean isWindowsTheme() {
        return THEME_FILE.getValue().equals(WINDOWS_LAF_THEME_FILE);
    }

    public static boolean isBrushedMetalTheme() {
        return THEME_FILE.getValue().equals(BRUSHED_METAL_OSX_THEME_FILE);
    }

    public static boolean isPinstripesTheme() {
        return THEME_FILE.getValue().equals(PINSTRIPES_OSX_THEME_FILE);
    }

    public static boolean isNativeOSXTheme() {
        return OSUtils.isMacOSX() && (ThemeSettings.isPinstripesTheme() || ThemeSettings.isBrushedMetalTheme());
    }

    public static boolean isNativeTheme() {
        return ThemeSettings.isNativeOSXTheme() || ThemeSettings.isWindowsTheme() || ThemeSettings.isGTKTheme();
    }

    public static boolean isOtherTheme() {
        return THEME_FILE.getValue().equals(OTHER_THEME_FILE);
    }

    public static boolean isValid() {
        if (ThemeSettings.isOtherTheme()) {
            String name = ThemeSettings.getOtherLF();
            if (name != null) {
                try {
                    Class.forName(name);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOtherLF() {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(new File(THEME_DIR_FILE, "other_theme/name.txt"))));
            String classname = in.readLine();
            if (classname != null) {
                String string = classname.trim();
                return string;
            }
        }
        catch (IOException ignored) {
            LOG.warn("Ignoring IOX", ignored);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOtherLF(String classname) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(new File(THEME_DIR_FILE, "other_theme/name.txt"), false));
            out.write(classname);
            out.flush();
        }
        catch (IOException ignored) {
            LOG.warn("Ignoring IOX", ignored);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String formatName(String name) {
        name = name.substring(0, name.length() - 5);
        StringBuilder formatted = new StringBuilder(name.length());
        StringTokenizer st = new StringTokenizer(name, "_");
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            String lower = next.toLowerCase(Locale.US);
            if (lower.equals("osx")) {
                next = "(OSX)";
            } else if (lower.equals("limewire")) {
                next = "LimeWire";
            } else if (lower.equals("limewirepro")) {
                next = "LimeWire PRO";
            }
            formatted.append(" " + next.substring(0, 1).toUpperCase(Locale.US));
            if (next.length() <= 1) continue;
            formatted.append(next.substring(1));
        }
        return formatted.toString().trim();
    }

    static {
        File dir;
        File theme;
        LOG = LogFactory.getLog(ThemeSettings.class);
        THEME_DIR_FILE = new File(CommonUtils.getUserSettingsDir(), "themes");
        LIMEWIRE_THEME_FILE = new File(THEME_DIR_FILE, LIMEWIRE_THEME_NAME);
        PINSTRIPES_OSX_THEME_FILE = new File(THEME_DIR_FILE, PINSTRIPES_OSX_THEME_NAME);
        BRUSHED_METAL_OSX_THEME_FILE = new File(THEME_DIR_FILE, BRUSHED_METAL_OSX_THEME_NAME);
        WINDOWS_LAF_THEME_FILE = new File(THEME_DIR_FILE, WINDOWS_LAF_THEME_NAME);
        GTK_LAF_THEME_FILE = new File(THEME_DIR_FILE, GTK_LAF_THEME_NAME);
        PRO_THEME_FILE = new File(THEME_DIR_FILE, PRO_THEME_NAME);
        OTHER_THEME_FILE = new File(THEME_DIR_FILE, OTHER_THEME_NAME);
        File themesJar = ThemeSettings.getThemesJar();
        JAR_THEME_NAMES = themesJar == null || !themesJar.isFile() ? Collections.emptyList() : ThemeSettings.scanJarFileForThemes(themesJar);
        if (OSUtils.isMacOSX()) {
            theme = PINSTRIPES_OSX_THEME_FILE;
            dir = new File(THEME_DIR_FILE, "pinstripes_theme_osx");
        } else if (LimeWireUtils.isPro()) {
            theme = PRO_THEME_FILE;
            dir = new File(THEME_DIR_FILE, "limewirePro_theme");
        } else if (OSUtils.isNativeThemeWindows()) {
            theme = WINDOWS_LAF_THEME_FILE;
            dir = new File(THEME_DIR_FILE, "windows_theme");
        } else if (OSUtils.isLinux()) {
            theme = GTK_LAF_THEME_FILE;
            dir = new File(THEME_DIR_FILE, "GTK_theme");
        } else {
            theme = LIMEWIRE_THEME_FILE;
            dir = new File(THEME_DIR_FILE, "limewire_theme");
        }
        THEME_DEFAULT = theme;
        THEME_DEFAULT_DIR = dir;
        THEME_FILE = FACTORY.createFileSetting("THEME_FILE", THEME_DEFAULT);
        THEME_DIR = FACTORY.createFileSetting("THEME_DIR", THEME_DEFAULT_DIR);
        FONT_SIZE_INCREMENT = FACTORY.createIntSetting("FONT_SIZE_INCREMENT", 0);
    }
}

