/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.ProgressBarHolder;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.upload.BrowseListener;
import com.limegroup.gnutella.gui.upload.ChatListener;
import com.limegroup.gnutella.gui.upload.ClearListener;
import com.limegroup.gnutella.gui.upload.UploadButtons;
import com.limegroup.gnutella.gui.upload.UploadDataLine;
import com.limegroup.gnutella.gui.upload.UploadModel;
import com.limegroup.gnutella.gui.upload.UploadPopupMenu;
import com.limegroup.gnutella.gui.upload.UploadProgressBarRenderer;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JPopupMenu;
import org.limewire.io.ConnectableImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UploadMediator
extends AbstractTableMediator<UploadModel, UploadDataLine, Uploader> {
    private static int _totalUploads = 0;
    private static final ProgressBarRenderer PROGRESS_BAR_RENDERER = new UploadProgressBarRenderer();
    ActionListener CHAT_LISTENER;
    ActionListener CLEAR_LISTENER;
    ActionListener BROWSE_LISTENER;
    private static final String UPLOAD_TITLE = I18n.tr("Uploads");
    private static final String ACTIVE = I18n.tr("Active");
    private static final String QUEUED = I18n.tr("Queued");
    private static UploadMediator _instance = new UploadMediator();
    private static boolean _chatEnabled;
    private static boolean _browseEnabled;

    public static UploadMediator instance() {
        return _instance;
    }

    @Override
    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ChatListener(this);
        this.CLEAR_LISTENER = new ClearListener(this);
        this.BROWSE_LISTENER = new BrowseListener(this);
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(UPLOAD_TITLE);
        this.DATA_MODEL = new UploadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new UploadButtons(this).getComponent();
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(ProgressBarHolder.class, PROGRESS_BAR_RENDERER);
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Upload Window..."));
    }

    public UploadMediator() {
        super("UPLOAD_MEDIATOR");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
    }

    @Override
    public void doRefresh() {
        boolean inactivePresent = (Boolean)((UploadModel)this.DATA_MODEL).refresh();
        this.setButtonEnabled(2, inactivePresent);
        this.MAIN_PANEL.setTitle(UPLOAD_TITLE + " (" + GuiCoreMediator.getUploadServices().getNumUploads() + " " + ACTIVE + ", " + GuiCoreMediator.getUploadServices().getNumQueuedUploads() + " " + QUEUED + ")");
    }

    public int getTotalUploads() {
        return _totalUploads;
    }

    public int getCurrentUploads() {
        return ((UploadModel)this.DATA_MODEL).getCurrentUploads();
    }

    public int getActiveUploads() {
        return ((UploadModel)this.DATA_MODEL).getRowCount();
    }

    public double getActiveUploadsBandwidth() {
        return ((UploadModel)this.DATA_MODEL).getActiveUploadsBandwidth();
    }

    @Override
    public void add(Uploader uploader) {
        int idx;
        if (!((UploadModel)this.DATA_MODEL).contains(uploader) && (idx = ((UploadModel)this.DATA_MODEL).update(uploader)) == -1) {
            ++_totalUploads;
            super.add(uploader);
        }
    }

    @Override
    public void remove(Uploader uploader) {
        if (SharingSettings.CLEAR_UPLOAD.getValue() && uploader.isInactive()) {
            int i = ((UploadModel)this.DATA_MODEL).getRow(uploader);
            if (i != -1) {
                ((UploadDataLine)((UploadModel)this.DATA_MODEL).get(i)).setPersistConnection(true);
                super.removeRow(i);
            }
        } else {
            UploadDataLine udl = (UploadDataLine)((UploadModel)this.DATA_MODEL).get(uploader);
            if (udl != null) {
                udl.setEndTime(System.currentTimeMillis());
            }
        }
    }

    @Override
    public void removeSelection() {
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        for (int counter = sel.length - 1; counter >= 0; --counter) {
            int i = sel[counter];
            ((UploadDataLine)((UploadModel)this.DATA_MODEL).get(i)).cleanup();
        }
    }

    void chatWithSelectedUploads() {
        int[] sel = this.TABLE.getSelectedRows();
        for (int i = 0; i < sel.length; ++i) {
            Uploader uploader = (Uploader)((UploadDataLine)((UploadModel)this.DATA_MODEL).get(sel[i])).getInitializeObject();
            if (!uploader.isChatEnabled()) continue;
            String host = uploader.getHost();
            int port = uploader.getGnutellaPort();
            GUIMediator.createChat(host, port);
        }
    }

    void browseWithSelectedUploads() {
        boolean found = false;
        int[] sel = this.TABLE.getSelectedRows();
        HashSet<String> searched = new HashSet<String>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            PushEndpoint pushEndpoint;
            Uploader uploader = (Uploader)((UploadDataLine)((UploadModel)this.DATA_MODEL).get(sel[i])).getInitializeObject();
            if (!uploader.isBrowseHostEnabled()) continue;
            String host = uploader.getHost();
            if (host == null) {
                pushEndpoint = this.getPushEndPoint(uploader);
                if (pushEndpoint == null || searched.contains(pushEndpoint.httpStringValue())) continue;
                SearchMediator.doBrowseHost(pushEndpoint);
                searched.add(pushEndpoint.httpStringValue());
                found = true;
                continue;
            }
            if (searched.contains(host)) continue;
            pushEndpoint = this.getPushEndPoint(uploader);
            GUID guid = pushEndpoint != null ? new GUID(pushEndpoint.getClientGUID()) : null;
            SearchMediator.doBrowseHost(new ConnectableImpl(uploader), guid);
            searched.add(host);
            found = true;
        }
        if (found) {
            GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
        }
    }

    private PushEndpoint getPushEndPoint(Uploader uploader) {
        if (uploader instanceof HTTPUploader) {
            return ((HTTPUploader)uploader).getPushEndpoint();
        }
        return null;
    }

    @Override
    public void handleActionKey() {
    }

    void clearCompletedUploads() {
        ((UploadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(2, false);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new UploadPopupMenu(this).getComponent();
        menu.getComponent(0).setEnabled(!this.TABLE.getSelectionModel().isSelectionEmpty());
        menu.getComponent(1).setEnabled(_chatEnabled);
        menu.getComponent(2).setEnabled(_browseEnabled);
        return menu;
    }

    @Override
    public void handleSelection(int row) {
        UploadDataLine dataLine = (UploadDataLine)((UploadModel)this.DATA_MODEL).get(row);
        _chatEnabled = dataLine.isChatEnabled();
        _browseEnabled = dataLine.isBrowseEnabled();
        this.setButtonEnabled(0, !this.TABLE.getSelectionModel().isSelectionEmpty());
        this.setButtonEnabled(1, _browseEnabled);
    }

    @Override
    public void handleNoSelection() {
        _chatEnabled = false;
        _browseEnabled = false;
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
    }
}

