/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;

public class UploadProgressBarRenderer
extends ProgressBarRenderer {
    protected int getBarStatus(Object value) {
        if (value == null) {
            return 0;
        }
        UploadProgressBarData data = (UploadProgressBarData)value;
        return (int)(data.totalUploaded * 100L / data.totalSize);
    }

    protected String getDescription(Object value) {
        if (value == null) {
            return "0 %";
        }
        UploadProgressBarData data = (UploadProgressBarData)value;
        if (data.totalSize == 0L) {
            return "0 %";
        }
        int ratio = this.getBarStatus(value);
        if (!data.isBittorrent || ratio <= 100) {
            return Integer.toString(Math.min(100, ratio)) + " %";
        }
        return I18n.tr("Seeding") + "(" + GUIUtils.toUnitbytes(data.totalUploaded - data.totalSize) + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UploadProgressBarData
    implements Comparable<UploadProgressBarData> {
        public long totalUploaded;
        public long totalSize;
        public final boolean isBittorrent;

        public UploadProgressBarData(boolean isBittorrent) {
            this.isBittorrent = isBittorrent;
        }

        @Override
        public int compareTo(UploadProgressBarData other) {
            float me = (float)this.totalUploaded / (float)this.totalSize;
            float them = (float)other.totalUploaded / (float)other.totalSize;
            if (me > them) {
                return 1;
            }
            if (me < them) {
                return -1;
            }
            return 0;
        }
    }
}

