/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.util;

import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.io.File;
import java.text.MessageFormat;

public class CoreExceptionHandler {
    public static void handleSaveLocationError(SaveLocationException sle) {
        GUIMediator.showError(CoreExceptionHandler.getSaveLocationErrorString(sle));
    }

    public static String getShortSaveLocationErrorString(SaveLocationException sle) {
        switch (sle.getErrorCode()) {
            case 1: {
                return I18n.tr("Invalid Filename");
            }
            case 2: {
                return I18n.tr("Download Already Finished");
            }
            case 3: {
                return I18n.tr("No Write Permission");
            }
            case 4: {
                return I18n.tr("Folder Does Not Exist");
            }
            case 5: {
                return I18n.tr("File Already Exists");
            }
            case 6: {
                return I18n.tr("Filename Taken");
            }
            case 8: {
                return I18n.tr("Not a Folder");
            }
            case 7: {
                return I18n.tr("Not a File");
            }
            case 9: {
                return I18n.tr("Filesystem Error");
            }
            case 10: {
                return I18n.tr("Same File Already Being Downloaded");
            }
        }
        throw new IllegalArgumentException("Unhandled error code: " + sle.getErrorCode());
    }

    public static String getSaveLocationErrorString(SaveLocationException sle) {
        return CoreExceptionHandler.getSaveLocationErrorString(sle, false);
    }

    public static String getSaveLocationErrorString(SaveLocationException sle, boolean html) {
        switch (sle.getErrorCode()) {
            case 1: {
                return MessageFormat.format(I18n.tr("Could not set file location to {0}, because the filename is invalid and may corrupt your system."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 2: {
                return I18n.tr("Could not set the file location, the download is already finished.");
            }
            case 3: {
                return MessageFormat.format(I18n.tr("Could not save download to the folder {0}, because you do not have write access to it."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 4: {
                return MessageFormat.format(I18n.tr("Could not save download to folder {0}, because the folder does not exist."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 5: {
                return MessageFormat.format(I18n.tr("A file already exists at {0}."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 6: {
                return MessageFormat.format(I18n.tr("Another download is already saving to {0}."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 8: {
                return MessageFormat.format(I18n.tr("Could not set download folder to {0}, because it represents an individual file, not a folder."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 7: {
                return MessageFormat.format(I18n.tr("Could not set file location to {0}, because it is not a regular file."), CoreExceptionHandler.params(html, sle.getFile()));
            }
            case 9: {
                return I18n.tr("Could not set file location due to an error in the filesystem.");
            }
            case 10: {
                return I18n.tr("The same file is already being downloaded.");
            }
            case 11: {
                return MessageFormat.format(I18n.tr("The path of the parent folder exceeds the maximum length of paths on the filesystem. {0} "), CoreExceptionHandler.params(html, sle.getFile()));
            }
        }
        throw new IllegalArgumentException("Unhandled error code: " + sle.getErrorCode());
    }

    private static Object[] params(boolean html, File file) {
        String fileName = GUIUtils.convertToNonBreakingSpaces(0, file.toString());
        return new Object[]{html ? "<i>" + fileName + "</i>" : fileName};
    }
}

