/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.wizard;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.wizard.Status;
import com.limegroup.gnutella.gui.wizard.Wizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public abstract class WizardPage
extends JPanel {
    private String key;
    private String titleKey;
    private String descriptionKey;
    private String url;
    private String urlLabelKey;
    protected Wizard wizard;
    protected JLabel statusLabel;

    public WizardPage(String key, String titleKey, String descriptionKey) {
        this.key = key;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
    }

    public WizardPage(String titleKey, String descriptionKey) {
        this(titleKey, titleKey, descriptionKey);
    }

    protected void createPage() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.setBackground(Color.white);
        topPanel.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)topPanel, "North");
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setOpaque(false);
        topPanel.add((Component)titlePanel, "Center");
        JLabel titleLabel = new JLabel(I18n.tr(this.titleKey));
        titleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        titleLabel.setFont(new Font("Dialog", 1, 16));
        titleLabel.setForeground(Color.black);
        titleLabel.setOpaque(false);
        titlePanel.add((Component)titleLabel, "North");
        MultiLineLabel descriptionLabel = new MultiLineLabel(I18n.tr(this.descriptionKey));
        descriptionLabel.setOpaque(false);
        descriptionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        descriptionLabel.setForeground(Color.black);
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(0));
        titlePanel.add((Component)descriptionLabel, "Center");
        if (this.url != null) {
            String label = this.urlLabelKey != null ? I18n.tr(this.urlLabelKey) : this.url;
            URLLabel urlLabel = new URLLabel(this.url, label);
            urlLabel.setOpaque(false);
            urlLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            urlLabel.setForeground(Color.black);
            urlLabel.setOpaque(false);
            titlePanel.add((Component)urlLabel, "South");
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)mainPanel, "Center");
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.add((Component)this.statusLabel, "South");
        this.createPageContent(mainPanel);
        this.revalidate();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getNext() != null;
    }

    protected abstract void createPageContent(JPanel var1);

    public String getKey() {
        return this.key;
    }

    public WizardPage getNext() {
        return this.wizard != null ? this.wizard.getNextPage(this) : null;
    }

    public WizardPage getPrevious() {
        return this.wizard != null ? this.wizard.getPreviousPage(this) : null;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public abstract boolean isPageComplete();

    public void pageShown() {
        this.validateInput();
        this.wizard.updateButtons();
    }

    public void setSatusMessage(String message) {
        this.setStatusMessage(Status.Severity.ERROR, message);
    }

    public void setStatusMessage(Status.Severity severity, String message) {
        if (message == null) {
            this.statusLabel.setText(" ");
            this.statusLabel.setIcon(null);
        } else {
            this.statusLabel.setText(message);
            if (severity == Status.Severity.ERROR) {
                this.statusLabel.setIcon(GUIMediator.getThemeImage("stop_small"));
            } else if (severity == Status.Severity.INFO) {
                this.statusLabel.setIcon(GUIMediator.getThemeImage("annotate_small"));
            } else {
                this.statusLabel.setIcon(null);
            }
        }
    }

    public void validateInput() {
    }

    public void updateStatus(Status ... status) {
        if (status == null || status.length == 0) {
            this.setSatusMessage(null);
        } else {
            this.setStatusMessage(status[0].getSeverity(), status[0].getMessage());
        }
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public void setURL(String url, String urlLabelKey) {
        this.url = url;
        this.urlLabelKey = urlLabelKey;
    }

    private static class MultiLineLabel
    extends JTextArea {
        public MultiLineLabel(String s) {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setHighlighter(null);
            LookAndFeel.installBorder(this, "Label.border");
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
            this.setSelectedTextColor(UIManager.getColor("Label.foreground"));
            this.setText(s);
        }

        public MultiLineLabel() {
            this(" ");
        }
    }
}

