/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.IndentingPanel;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.undo.UndoManager;
import org.limewire.util.I18NConvert;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputPanel
extends IndentingPanel {
    private final LimeXMLSchema SCHEMA;

    public InputPanel(LimeXMLSchema schema, ActionListener listener, Document document, UndoManager undoer) {
        this(schema, listener, document, undoer, false, false, true);
    }

    public InputPanel(LimeXMLSchema schema, ActionListener listener, Document document, UndoManager undoer, boolean expand, boolean indent, boolean search) {
        super(schema, listener, document, undoer, expand, indent, search);
        this.SCHEMA = schema;
    }

    public String getSchemaURI() {
        return this.SCHEMA.getSchemaURI();
    }

    public String getInput() {
        return this.getInput(false);
    }

    public String getInput(boolean normalize) {
        List<NameValue<String>> namValList = this.getXMLInputList(normalize);
        String schemaURI = this.SCHEMA.getSchemaURI();
        String str = this.constructXML(namValList, schemaURI);
        return str;
    }

    private List<NameValue<String>> getXMLInputList(boolean normalize) {
        LinkedList<NameValue<String>> namValList = new LinkedList<NameValue<String>>();
        for (SchemaFieldInfo field : this.SCHEMA.getCanonicalizedFields()) {
            String key = field.getCanonicalizedFieldName();
            JComponent comp = this.getField(key);
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = ((ComboBoxValue)theBox.getSelectedItem()).getValue();
            }
            if (value == null || value.equals("")) continue;
            if (normalize) {
                value = I18NConvert.instance().getNorm(value);
            }
            namValList.add(new NameValue<String>(key, value));
        }
        return namValList;
    }

    public int getNumberOfFieldsWithInput() {
        return this.getXMLInputList(true).size();
    }

    public void storeInput() {
        List<SchemaFieldInfo> list = this.SCHEMA.getCanonicalizedFields();
        for (int i = 0; i < list.size(); ++i) {
            AutoCompleteTextField theField;
            SchemaFieldInfo field = list.get(i);
            String key = field.getCanonicalizedFieldName();
            JComponent comp = this.getField(key);
            if (!(comp instanceof AutoCompleteTextField) || (theField = (AutoCompleteTextField)comp).getText().equals("")) continue;
            theField.addToDictionary();
        }
    }

    private String getCompositeQuery() {
        List<SchemaFieldInfo> list = this.SCHEMA.getCanonicalizedFields();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            SchemaFieldInfo field = list.get(i);
            String key = field.getCanonicalizedFieldName();
            JComponent comp = this.getField(key);
            String value = "";
            if (comp instanceof JTextField) {
                JTextField theField = (JTextField)comp;
                value = theField.getText();
            } else if (comp instanceof JComboBox) {
                JComboBox theBox = (JComboBox)comp;
                value = ((ComboBoxValue)theBox.getSelectedItem()).toString();
            }
            if (value == null || value.trim().length() <= 1) continue;
            sb.append(value + " ");
        }
        return sb.toString().trim();
    }

    public String getStandardQuery() {
        return QueryUtils.createQueryString(this.getCompositeQuery(), true);
    }

    public String getTitleForQuery() {
        return this.getCompositeQuery();
    }

    public String constructXML(List<NameValue<String>> namValList, String uri) {
        if (namValList == null || namValList.isEmpty()) {
            return null;
        }
        return GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(namValList, uri).getXMLString();
    }
}

