/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.xml.editor.DetailsPanel;
import com.limegroup.gnutella.gui.xml.editor.IconPanel;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorPanel;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public abstract class AbstractMetaInfoPanel
extends MetaEditorPanel {
    private JPanel topPanel;
    protected JPanel iconPanel;
    protected JLabel firstLineLabel;
    protected JLabel secondLineLabel;
    protected JLabel thirdLineLabel;
    protected JPanel details;
    private JPanel centerPanel;
    private JPanel fileLocationPanel;
    protected JTextArea fileLocationTextArea;

    public AbstractMetaInfoPanel(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument document) {
        super(fds, schema, document);
        super.setName(I18n.tr("Info"));
        this.initComponents();
        this.setValues();
    }

    protected abstract void setValues();

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.createGeneralPanel();
        this.createDetailsPanel();
        this.createFileLocationPanel();
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.add((Component)this.fileLocationPanel, "South");
    }

    private void createGeneralPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel(new BorderLayout());
            this.topPanel.setOpaque(false);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            this.iconPanel = new IconPanel();
            this.firstLineLabel = new JLabel();
            this.secondLineLabel = new JLabel();
            this.thirdLineLabel = new JLabel();
            this.iconPanel.setBackground(new Color(255, 255, 255));
            this.iconPanel.setBorder(new LineBorder(new Color(153, 153, 153)));
            this.iconPanel.setPreferredSize(new Dimension(48, 48));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)this.iconPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            panel.add((Component)this.firstLineLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 18;
            panel.add((Component)this.secondLineLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            panel.add((Component)this.thirdLineLabel, gridBagConstraints);
            this.topPanel.add((Component)new JSeparator(), "South");
            this.topPanel.add((Component)panel, "West");
        }
    }

    private void createDetailsPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel(new FlowLayout(0));
            this.centerPanel.setOpaque(false);
            this.details = new DetailsPanel(new GridLayout(8, 2, 3, 0));
            this.details.setOpaque(false);
            this.centerPanel.add(this.details);
        }
    }

    private void createFileLocationPanel() {
        if (this.fileLocationPanel == null) {
            this.fileLocationPanel = new JPanel(new BorderLayout());
            this.fileLocationPanel.setOpaque(false);
            this.fileLocationTextArea = new JTextArea();
            this.fileLocationTextArea.setEditable(false);
            this.fileLocationTextArea.setLineWrap(true);
            this.fileLocationTextArea.setRows(2);
            this.fileLocationTextArea.setMinimumSize(new Dimension(12, 13));
            this.fileLocationTextArea.setPreferredSize(new Dimension(12, 32));
            this.fileLocationTextArea.setOpaque(false);
            this.fileLocationPanel.add((Component)new JSeparator(), "North");
            this.fileLocationPanel.add((Component)this.fileLocationTextArea, "South");
        }
    }
}

