/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.TitledPaddedPanel;
import com.limegroup.gnutella.gui.wizard.Status;
import com.limegroup.gnutella.gui.wizard.Wizard;
import com.limegroup.gnutella.gui.wizard.WizardPage;
import com.limegroup.gnutella.gui.wizard.WizardPageModificationHandler;
import com.limegroup.gnutella.gui.xml.editor.CCRDFOuptut;
import com.limegroup.gnutella.gui.xml.editor.MetaDataEventListener;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.PublishedCCLicense;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCPublishWizard
extends Wizard {
    private LimeXMLDocument doc;
    private FileDesc fd;
    private DetailsPage detailsPage;
    private UsagePage usagePage;
    private VerificationPage verificationPage;
    private WarningPage warningPage;
    private LimeXMLSchema schema;

    public CCPublishWizard(FileDesc fd, LimeXMLDocument doc, LimeXMLSchema schema) {
        this.fd = fd;
        this.doc = doc;
        this.schema = schema;
    }

    public void showDialog(Frame parent) {
        this.warningPage = new WarningPage();
        this.detailsPage = new DetailsPage();
        this.usagePage = new UsagePage();
        this.verificationPage = new VerificationPage();
        this.addPage(this.warningPage);
        this.addPage(this.usagePage);
        this.addPage(this.detailsPage);
        this.addPage(this.verificationPage);
        this.initInfo();
        JDialog dialog = this.createDialog(parent);
        dialog.setTitle(I18n.tr("Publish License"));
        dialog.setLocationRelativeTo(MessageService.getParentComponent());
        dialog.setVisible(true);
    }

    @Override
    public void performFinish() {
        if (this.warningPage.MODIFY_LICENSE.isSelected()) {
            MetaDataSaver saver = new MetaDataSaver(new FileDesc[]{this.fd}, this.schema, GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(this.getInputValues(), this.schema.getSchemaURI()).getXMLString());
            saver.saveMetaData(this.getFileEventListener());
            this.dialog.dispose();
        } else {
            DialogOption answer = GUIMediator.showYesNoMessage(I18n.tr("Are you sure you want to permanently remove the license from your local copy of this file?"), DialogOption.YES);
            if (answer == DialogOption.YES) {
                List<NameValue<String>> valList = CCPublishWizard.getPreviousValList(this.doc, false);
                valList.add(new NameValue<String>("audios__audio__license__", ""));
                valList.add(new NameValue<String>("audios__audio__licensetype__", ""));
                MetaDataSaver saver = new MetaDataSaver(new FileDesc[]{this.fd}, this.schema, GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(valList, this.schema.getSchemaURI()).getXMLString());
                saver.saveMetaData();
                this.dialog.dispose();
            }
        }
    }

    private void initInfo() {
        License license = this.fd.getLicense();
        if (license != null) {
            String licenseDeed;
            this.warningPage.setLicenseAvailable(true);
            if (license.getLicenseURI() != null) {
                this.verificationPage.VERIFICATION_URL_FIELD.setText(license.getLicenseURI().toString());
                this.verificationPage.SELF_VERIFICATION.setSelected(true);
                this.verificationPage.updateVerification();
            }
            if ((licenseDeed = license.getLicenseDeed(this.fd.getSHA1Urn()).toString()) != null) {
                if (licenseDeed.equals("http://creativecommons.org/licenses/by-nc-nd/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(false);
                    this.usagePage.ALLOW_MODIFICATIONS_NO.setSelected(true);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-nd/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(true);
                    this.usagePage.ALLOW_MODIFICATIONS_NO.setSelected(true);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-nc/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(false);
                    this.usagePage.ALLOW_MODIFICATIONS_YES.setSelected(true);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-nc-sa/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(false);
                    this.usagePage.ALLOW_MODIFICATIONS_SHAREALIKE.setSelected(true);
                } else if (licenseDeed.equals("http://creativecommons.org/licenses/by-sa/2.5/")) {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(true);
                    this.usagePage.ALLOW_MODIFICATIONS_SHAREALIKE.setSelected(true);
                } else {
                    this.usagePage.ALLOW_COMMERCIAL_YES.setSelected(true);
                    this.usagePage.ALLOW_MODIFICATIONS_YES.setSelected(true);
                }
            }
        } else {
            this.warningPage.setLicenseAvailable(false);
        }
        if (this.doc != null) {
            this.detailsPage.COPYRIGHT_HOLDER.setText(this.doc.getValue("audios__audio__artist__"));
            this.detailsPage.COPYRIGHT_YEAR.setText(this.doc.getValue("audios__audio__year__"));
            this.detailsPage.WORK_TITLE.setText(this.doc.getValue("audios__audio__title__"));
        }
    }

    private MetaDataEventListener getFileEventListener() {
        return new CCRDFOuptut(this.fd, this.detailsPage.COPYRIGHT_HOLDER.getText(), this.detailsPage.WORK_TITLE.getText(), this.detailsPage.COPYRIGHT_YEAR.getText(), this.detailsPage.DESCRIPTION.getText(), this.verificationPage.VERIFICATION_URL_FIELD.getText(), this.getLicenseType());
    }

    private int getLicenseType() {
        int type = 0;
        if (!this.usagePage.ALLOW_COMMERCIAL_YES.isSelected()) {
            type |= 2;
        }
        if (this.usagePage.ALLOW_MODIFICATIONS_SHAREALIKE.isSelected()) {
            type |= 4;
        } else if (this.usagePage.ALLOW_MODIFICATIONS_NO.isSelected()) {
            type |= 1;
        }
        return type;
    }

    private List<NameValue<String>> getInputValues() {
        ArrayList<NameValue<String>> valList = new ArrayList<NameValue<String>>();
        String holder = this.detailsPage.COPYRIGHT_HOLDER.getText();
        String year = this.detailsPage.COPYRIGHT_YEAR.getText();
        String title = this.detailsPage.WORK_TITLE.getText();
        String description = this.detailsPage.DESCRIPTION.getText();
        int type = this.getLicenseType();
        String url = this.verificationPage.VERIFICATION_URL_FIELD.getText();
        boolean saveDetails = this.detailsPage.SAVE_DETAILS_CHECKBOX.isSelected();
        valList.addAll(CCPublishWizard.getPreviousValList(this.doc, saveDetails));
        String embeddedLicense = PublishedCCLicense.getEmbeddableString(holder, title, year, url, description, type);
        if (embeddedLicense != null) {
            valList.add(new NameValue<String>("audios__audio__license__", embeddedLicense));
            valList.add(new NameValue<String>("audios__audio__licensetype__", "creativecommons.org/licenses/"));
        }
        if (saveDetails) {
            valList.add(new NameValue<String>("audios__audio__title__", title));
            valList.add(new NameValue<String>("audios__audio__year__", year));
            valList.add(new NameValue<String>("audios__audio__artist__", holder));
            valList.add(new NameValue<String>("audios__audio__comments__", description));
        }
        return valList;
    }

    public static List<NameValue<String>> getPreviousValList(LimeXMLDocument doc, boolean excludeDetails) {
        ArrayList<NameValue<String>> valList = new ArrayList<NameValue<String>>();
        if (doc != null) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                String key = entry.getKey();
                if (CCPublishWizard.isLicenseKey(key) || excludeDetails && CCPublishWizard.isDetailsKey(key)) continue;
                valList.add(new NameValue<String>(entry.getKey(), entry.getValue()));
            }
        }
        return valList;
    }

    private static boolean isLicenseKey(String key) {
        return key.equals("audios__audio__license__") || key.equals("audios__audio__licensetype__");
    }

    private static boolean isDetailsKey(String key) {
        return key.equals("audios__audio__title__") || key.equals("audios__audio__year__") || key.equals("audios__audio__artist__") || key.equals("audios__audio__comments__");
    }

    private class VerificationPage
    extends WizardPage {
        final JTextField VERIFICATION_URL_FIELD;
        final String VERIFICATION_ARCHIVE;
        final String VERIFICATION_SELF;
        final JRadioButton SELF_VERIFICATION;
        private boolean complete;

        public VerificationPage() {
            super("verificationPage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("Where do you want to store the verification URL?"));
            this.VERIFICATION_URL_FIELD = new SizedTextField(20, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.VERIFICATION_ARCHIVE = I18n.tr("I want to use the Internet Archive to host the file.");
            this.VERIFICATION_SELF = I18n.tr("I want to host the verification file myself at the following URL:");
            this.SELF_VERIFICATION = new JRadioButton(this.VERIFICATION_SELF);
            this.setURL(SharingSettings.CREATIVE_COMMONS_VERIFICATION_URL.getValue(), I18nMarker.marktr("What is this?"));
        }

        protected void createPageContent(JPanel panel) {
            panel.setLayout(new BoxLayout(panel, 1));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.SELF_VERIFICATION);
            this.SELF_VERIFICATION.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    VerificationPage.this.updateVerification();
                }
            });
            BoxPanel p = new BoxPanel(0);
            p.add(new JLabel(I18n.tr("The verification file is hosted at the following URL:")));
            p.add(Box.createHorizontalGlue());
            panel.add(p);
            panel.add(Box.createRigidArea(BoxPanel.VERTICAL_COMPONENT_GAP));
            this.VERIFICATION_URL_FIELD.setText("http://");
            p = new BoxPanel(0);
            p.addVerticalComponentGap();
            p.add(this.VERIFICATION_URL_FIELD);
            this.VERIFICATION_URL_FIELD.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            p.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.VERIFICATION_URL_FIELD.getPreferredSize().height));
            panel.add(p);
            panel.add(Box.createVerticalGlue());
            this.SELF_VERIFICATION.setSelected(true);
            this.updateVerification();
        }

        public boolean isPageComplete() {
            return this.complete;
        }

        private void updateVerification() {
            this.VERIFICATION_URL_FIELD.setEnabled(true);
            this.validateInput();
        }

        public void validateInput() {
            this.complete = true;
            String url = this.VERIFICATION_URL_FIELD.getText();
            if (url.equals("") || !url.startsWith("http://") || url.length() < 8) {
                this.updateStatus(new Status(I18n.tr("Please enter a verification URL for the license."), Status.Severity.INFO));
                this.complete = false;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException invalidURL) {
                this.updateStatus(new Status(I18n.tr("Please enter a verification URL for the license."), Status.Severity.ERROR));
                this.complete = false;
            }
            if (this.complete) {
                this.updateStatus(new Status[0]);
            }
            CCPublishWizard.this.updateButtons();
        }
    }

    private class DetailsPage
    extends WizardPage {
        private final JTextField COPYRIGHT_HOLDER;
        private final JTextField WORK_TITLE;
        private final JTextField COPYRIGHT_YEAR;
        private final JTextArea DESCRIPTION;
        final JCheckBox SAVE_DETAILS_CHECKBOX;
        private boolean complete;

        public DetailsPage() {
            super("detailsPage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("This tool helps you publish audio under a Creative Commons license."));
            this.COPYRIGHT_HOLDER = new SizedTextField(24, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.WORK_TITLE = new SizedTextField(24, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.COPYRIGHT_YEAR = new SizedTextField(6, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
            this.DESCRIPTION = new JTextArea(4, 24);
            this.SAVE_DETAILS_CHECKBOX = new JCheckBox(I18n.tr("Save details to file"));
            this.complete = false;
        }

        protected void createPageContent(JPanel panel) {
            panel.setLayout(new BoxLayout(panel, 1));
            BoxPanel holderPanel = new BoxPanel(0);
            panel.add(holderPanel);
            LabeledComponent c = new LabeledComponent(I18nMarker.marktr("Copyright Holder:"), this.COPYRIGHT_HOLDER, 150, 13);
            this.COPYRIGHT_HOLDER.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            holderPanel.add(c.getComponent());
            holderPanel.add(Box.createRigidArea(BoxPanel.HORIZONTAL_COMPONENT_GAP));
            c = new LabeledComponent(I18nMarker.marktr("Copyright Year:"), this.COPYRIGHT_YEAR, 150, 13);
            this.COPYRIGHT_YEAR.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            holderPanel.add(c.getComponent());
            panel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
            c = new LabeledComponent(I18nMarker.marktr("Title of Work:"), this.WORK_TITLE, 150, 13);
            this.WORK_TITLE.getDocument().addDocumentListener(new WizardPageModificationHandler(this));
            panel.add(c.getComponent());
            panel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
            c = new LabeledComponent(I18nMarker.marktr("Comment:"), new JScrollPane(this.DESCRIPTION), 150, 13);
            panel.add(c.getComponent());
            panel.add(c.getComponent());
            panel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
        }

        public boolean isPageComplete() {
            return this.complete;
        }

        public void validateInput() {
            this.complete = true;
            if ("".equals(this.COPYRIGHT_HOLDER.getText()) || "".equals(this.COPYRIGHT_YEAR.getText()) || "".equals(this.WORK_TITLE.getText())) {
                this.updateStatus(new Status(I18n.tr("Please enter the copyright holder, copright year and title."), Status.Severity.INFO));
                this.complete = false;
            } else {
                try {
                    Integer.parseInt(this.COPYRIGHT_YEAR.getText());
                }
                catch (NumberFormatException e) {
                    this.updateStatus(new Status(I18n.tr("Please enter a valid year for the file you want to publish."), Status.Severity.ERROR));
                    this.complete = false;
                }
            }
            if (this.complete) {
                this.updateStatus(new Status[0]);
            }
            CCPublishWizard.this.updateButtons();
        }
    }

    private class UsagePage
    extends WizardPage {
        final JRadioButton ALLOW_COMMERCIAL_YES;
        final JRadioButton ALLOW_COMMERCIAL_NO;
        final JRadioButton ALLOW_MODIFICATIONS_SHAREALIKE;
        final JRadioButton ALLOW_MODIFICATIONS_YES;
        final JRadioButton ALLOW_MODIFICATIONS_NO;

        public UsagePage() {
            super("usagePage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("This tool helps you publish audio under a Creative Commons license."));
            this.ALLOW_COMMERCIAL_YES = new JRadioButton(I18n.tr("Yes"));
            this.ALLOW_COMMERCIAL_NO = new JRadioButton(I18n.tr("No"));
            this.ALLOW_MODIFICATIONS_SHAREALIKE = new JRadioButton(I18n.tr("ShareAlike"));
            this.ALLOW_MODIFICATIONS_YES = new JRadioButton(I18n.tr("Yes"));
            this.ALLOW_MODIFICATIONS_NO = new JRadioButton(I18n.tr("No"));
        }

        protected void createPageContent(JPanel panel) {
            panel.setLayout(new BoxLayout(panel, 1));
            TitledPaddedPanel commercialUsePanel = new TitledPaddedPanel(I18n.tr("Allow commercial use of your work?"));
            commercialUsePanel.add(Box.createHorizontalGlue());
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.ALLOW_COMMERCIAL_YES);
            bg.add(this.ALLOW_COMMERCIAL_NO);
            BoxPanel buttonPanel = new BoxPanel();
            commercialUsePanel.add(buttonPanel);
            buttonPanel.add(this.ALLOW_COMMERCIAL_YES);
            buttonPanel.add(this.ALLOW_COMMERCIAL_NO);
            panel.add(commercialUsePanel);
            panel.add(Box.createRigidArea(BoxPanel.LINE_GAP));
            TitledPaddedPanel modificationsPanel = new TitledPaddedPanel(I18n.tr("Allow modification of your work?"));
            modificationsPanel.add(Box.createHorizontalGlue());
            bg = new ButtonGroup();
            bg.add(this.ALLOW_MODIFICATIONS_SHAREALIKE);
            bg.add(this.ALLOW_MODIFICATIONS_YES);
            bg.add(this.ALLOW_MODIFICATIONS_NO);
            buttonPanel = new BoxPanel();
            modificationsPanel.add(buttonPanel);
            buttonPanel.add(this.ALLOW_MODIFICATIONS_SHAREALIKE);
            buttonPanel.add(this.ALLOW_MODIFICATIONS_YES);
            buttonPanel.add(this.ALLOW_MODIFICATIONS_NO);
            panel.add(modificationsPanel);
            this.ALLOW_COMMERCIAL_NO.setSelected(true);
            this.ALLOW_MODIFICATIONS_NO.setSelected(true);
        }

        public boolean isPageComplete() {
            return true;
        }
    }

    private class WarningPage
    extends WizardPage {
        private final String WARNING_MESSAGE_CREATE;
        private final String WARNING_MESSAGE_MODIFY;
        private final JCheckBox WARNING_CHECKBOX;
        private final TitledPaddedPanel MODE_SELECTION_PANEL;
        final JRadioButton MODIFY_LICENSE;
        final JRadioButton REMOVE_LICENSE;

        public WarningPage() {
            super("warningPage", I18nMarker.marktr("Publish License"), I18nMarker.marktr("This tool helps you publish audio under a Creative Commons license."));
            this.WARNING_MESSAGE_CREATE = I18n.tr("I understand that to publish a file, I must either own its copyrights or be authorized to publish them under a Creative Commons license.");
            this.WARNING_MESSAGE_MODIFY = I18n.tr("This file already has a license. If you want to modify it, click the checkbox to attest that you either own its copyrights or are authorized to publish them under a Creative Commons license.");
            this.WARNING_CHECKBOX = new JCheckBox();
            this.MODE_SELECTION_PANEL = new TitledPaddedPanel();
            this.MODIFY_LICENSE = new JRadioButton(I18n.tr("Modify the license of this file"));
            this.REMOVE_LICENSE = new JRadioButton(I18n.tr("Permanently remove the license from this file"));
            this.setURL(SharingSettings.CREATIVE_COMMONS_INTRO_URL.getValue(), I18nMarker.marktr("How does it work?"));
        }

        protected void createPageContent(JPanel parent) {
            parent.setLayout(new BoxLayout(parent, 1));
            this.WARNING_CHECKBOX.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    WarningPage.this.updateActions();
                }
            });
            this.WARNING_CHECKBOX.setPreferredSize(new Dimension(540, -1));
            parent.add(this.WARNING_CHECKBOX);
            this.MODE_SELECTION_PANEL.add(Box.createHorizontalGlue());
            parent.add(this.MODE_SELECTION_PANEL);
            this.MODIFY_LICENSE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    WarningPage.this.updateActions();
                }
            });
            this.REMOVE_LICENSE.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    WarningPage.this.updateActions();
                }
            });
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.MODIFY_LICENSE);
            bg.add(this.REMOVE_LICENSE);
            BoxPanel buttonPanel = new BoxPanel();
            buttonPanel.add(this.MODIFY_LICENSE);
            buttonPanel.add(this.REMOVE_LICENSE);
            this.MODE_SELECTION_PANEL.add(buttonPanel);
            this.MODIFY_LICENSE.setSelected(true);
            this.updateActions();
            this.setLicenseAvailable(true);
        }

        public void setLicenseAvailable(boolean available) {
            if (available) {
                this.WARNING_CHECKBOX.setText("<html>" + this.WARNING_MESSAGE_MODIFY + "</html>");
                this.MODE_SELECTION_PANEL.setVisible(true);
            } else {
                this.WARNING_CHECKBOX.setText("<html>" + this.WARNING_MESSAGE_CREATE + "</html>");
                this.MODIFY_LICENSE.setSelected(true);
                this.MODE_SELECTION_PANEL.setVisible(false);
            }
        }

        public boolean canFlipToNextPage() {
            return this.MODIFY_LICENSE.isSelected();
        }

        public boolean isPageComplete() {
            return this.WARNING_CHECKBOX.isSelected();
        }

        private void updateActions() {
            this.MODIFY_LICENSE.setEnabled(this.WARNING_CHECKBOX.isSelected());
            this.REMOVE_LICENSE.setEnabled(this.WARNING_CHECKBOX.isSelected());
            this.getWizard().updateButtons();
        }
    }
}

