/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.URLLabel;
import com.limegroup.gnutella.gui.xml.editor.MetaDataEventListener;
import com.limegroup.gnutella.licenses.PublishedCCLicense;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class CCRDFOuptut
implements MetaDataEventListener {
    private final String CCPUBLISHER_TITLE = I18n.tr("License RDF Output");
    private static final int DIALOG_WIDTH = 480;
    private static final int DIALOG_HEIGHT = 360;
    private final JLabel RDF_OUTPUT_LABEL = new JLabel("<html>" + I18n.tr("In order to publish your file, please insert the following code in your verification page at:") + "</html>");
    private final JTextArea RDF_OUTPUT = new JTextArea(6, 20);
    private CopyAction copyAction = new CopyAction();
    private FinishAction finishAction = new FinishAction();
    private JDialog dialog;
    private final FileDesc _fd;
    private final String _holder;
    private final String _title;
    private final String _year;
    private final String _description;
    private final String _url;
    private final int _type;
    private boolean _isEventHandled;

    public CCRDFOuptut(FileDesc fd, String holder, String title, String year, String description, String url, int type) {
        this._fd = fd;
        this._holder = holder;
        this._title = title;
        this._year = year;
        this._description = description;
        this._url = url;
        this._type = type;
    }

    public void handleFileEvent(FileManagerEvent event) {
        if (!event.isChangeEvent() || event.getFileDescs() == null || event.getFileDescs().length == 0) {
            return;
        }
        if (this._fd.equals(event.getFileDescs()[0])) {
            this.showDialog(event.getFileDescs()[1]);
        }
    }

    public void metaDataUnchanged(FileDesc fd) {
        this.showDialog(fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDialog(final FileDesc newFD) {
        CCRDFOuptut cCRDFOuptut = this;
        synchronized (cCRDFOuptut) {
            if (this._isEventHandled) {
                return;
            }
            this._isEventHandled = true;
        }
        GUIMediator.safeInvokeLater(new Runnable(){

            public void run() {
                CCRDFOuptut.this.initDialog();
                String RDFString = PublishedCCLicense.getRDFRepresentation(CCRDFOuptut.this._holder, CCRDFOuptut.this._title, CCRDFOuptut.this._year, CCRDFOuptut.this._description, newFD.getSHA1Urn().httpStringValue(), CCRDFOuptut.this._type);
                CCRDFOuptut.this.RDF_OUTPUT.setText(RDFString);
                CCRDFOuptut.this.RDF_OUTPUT.setCaretPosition(0);
                CCRDFOuptut.this.dialog.setLocationRelativeTo(MessageService.getParentComponent());
                CCRDFOuptut.this.dialog.setDefaultCloseOperation(2);
                GUIUtils.addHideAction(CCRDFOuptut.this.dialog);
                CCRDFOuptut.this.dialog.setVisible(true);
            }
        });
    }

    private void initDialog() {
        this.dialog = new JDialog((Frame)GUIMediator.getAppFrame(), true);
        this.dialog.setTitle(this.CCPUBLISHER_TITLE);
        BoxPanel mainPanel = new BoxPanel();
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.addLeft(this.RDF_OUTPUT_LABEL);
        mainPanel.addLineGap();
        URLLabel urlLabel = new URLLabel(this._url);
        mainPanel.addLeft(urlLabel);
        mainPanel.addLineGap();
        this.RDF_OUTPUT.setEditable(false);
        this.RDF_OUTPUT.setLineWrap(true);
        mainPanel.add(new JScrollPane(this.RDF_OUTPUT, 20, 30));
        mainPanel.addVerticalComponentGap();
        JButton copyButton = new JButton(this.copyAction);
        mainPanel.addCenter(copyButton);
        mainPanel.addLineGap();
        ButtonRow buttonRow = new ButtonRow(new Action[]{this.finishAction}, 0, 12);
        mainPanel.add(buttonRow);
        this.dialog.setContentPane(mainPanel);
        this.dialog.setSize(new Dimension(480, 360));
    }

    private class FinishAction
    extends AbstractAction {
        public FinishAction() {
            this.putValue("Name", I18n.tr("Finish"));
        }

        public void actionPerformed(ActionEvent e) {
            CCRDFOuptut.this.dialog.dispose();
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("Name", I18n.tr("Copy to Clipboard"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(CCRDFOuptut.this.RDF_OUTPUT.getText()), null);
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
    }
}

