/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.IconManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class IconPanel
extends JPanel {
    private BufferedImage cachedImage;
    private Icon icon;

    public void initWithFileDesc(FileDesc fd) {
        IconManager iconManager = IconManager.instance();
        this.icon = iconManager.getIconForFile(fd.getFile());
    }

    protected void paintComponent(Graphics g) {
        if (this.icon != null) {
            if (this.cachedImage == null || this.cachedImage.getWidth() != this.getWidth() || this.cachedImage.getHeight() != this.getHeight()) {
                this.createCachedImage();
            }
            g.drawImage(this.cachedImage, 0, 0, null);
        }
    }

    private void createCachedImage() {
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        this.cachedImage = gc.createCompatibleImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D g2 = (Graphics2D)this.cachedImage.getGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g2.drawImage(((ImageIcon)this.icon).getImage(), 0, 0, this.cachedImage.getWidth(), this.cachedImage.getHeight(), null);
        g2.dispose();
    }
}

