/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.xml.editor.MetaDataEventListener;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorUtil;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.xml.sax.SAXException;

public class MetaDataSaver {
    private FileDesc[] fds;
    private String input;
    private LimeXMLSchema schema;

    public MetaDataSaver(FileDesc[] fds, LimeXMLSchema schema, String input) {
        this.fds = fds;
        this.schema = schema;
        this.input = input;
    }

    public void saveMetaData() {
        this.saveMetaData(null);
    }

    public void saveMetaData(final MetaDataEventListener listener) {
        if (listener != null) {
            GuiCoreMediator.getFileManager().addFileEventListener(listener);
        }
        BackgroundExecutorService.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(false);
                        }
                    });
                    MetaDataSaver.this.saveMetaDataInternal(listener);
                }
                catch (Throwable throwable) {
                    GUIMediator.safeInvokeAndWait(new Runnable(){

                        public void run() {
                            LibraryMediator.instance().setAnnotateEnabled(true);
                        }
                    });
                    if (listener != null) {
                        Runnable runner = new Runnable(){

                            public void run() {
                                GuiCoreMediator.getFileManager().removeFileEventListener(listener);
                            }
                        };
                        GuiCoreMediator.getCoreBackgroundExecutor().schedule(runner, 30000L, TimeUnit.MILLISECONDS);
                    }
                    throw throwable;
                }
                GUIMediator.safeInvokeAndWait(new /* invalid duplicate definition of identical inner class */);
                if (listener != null) {
                    Runnable runner = new /* invalid duplicate definition of identical inner class */;
                    GuiCoreMediator.getCoreBackgroundExecutor().schedule(runner, 30000L, TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    private void saveMetaDataInternal(MetaDataEventListener listener) {
        if (this.input == null) {
            return;
        }
        if (this.fds.length == 1 && this.input.trim().length() == 0) {
            this.removeMeta(this.fds, this.schema);
            return;
        }
        LimeXMLDocument newDoc = null;
        try {
            newDoc = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(this.input);
        }
        catch (SAXException e) {
            GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
            return;
        }
        catch (SchemaNotFoundException e) {
            GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
            return;
        }
        catch (IOException e) {
            GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
            return;
        }
        SchemaReplyCollectionMapper map = GuiCoreMediator.getSchemaReplyCollectionMapper();
        String schemaURI = newDoc.getSchemaURI();
        LimeXMLReplyCollection collection = map.getReplyCollection(schemaURI);
        assert (collection != null) : "Cant add doc to nonexistent collection";
        for (int i = 0; i < this.fds.length; ++i) {
            String fileName = null;
            try {
                fileName = this.fds[i].getFile().getCanonicalPath();
            }
            catch (IOException err) {
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    public void run() {
                        GUIMediator.showError(I18n.tr("Internal Document Error. Data could not be saved."));
                    }
                });
                continue;
            }
            LimeXMLDocument oldDoc = this.fds[i].getXMLDocument(schemaURI);
            LimeXMLDocument result = null;
            if (oldDoc != null) {
                result = MetaEditorUtil.merge(oldDoc, newDoc);
                oldDoc = collection.replaceDoc(this.fds[i], result);
            } else {
                result = newDoc;
                collection.addReply(this.fds[i], result);
            }
            if (LimeXMLUtils.isSupportedFormat(fileName)) {
                final LimeXMLReplyCollection.MetaDataState committed = collection.mediaFileToDisk(this.fds[i], fileName, result);
                if (committed == LimeXMLReplyCollection.MetaDataState.UNCHANGED) {
                    if (listener == null) continue;
                    listener.metaDataUnchanged(this.fds[i]);
                    continue;
                }
                if (committed == LimeXMLReplyCollection.MetaDataState.NORMAL) continue;
                GUIMediator.safeInvokeAndWait(new Runnable(){

                    public void run() {
                        MetaDataSaver.this.showCommitError(committed);
                    }
                });
                switch (committed) {
                    case FAILED_ARTIST: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__artist__", collection, oldDoc);
                        break;
                    }
                    case FAILED_ALBUM: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__album__", collection, oldDoc);
                        break;
                    }
                    case FAILED_YEAR: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__year__", collection, oldDoc);
                        break;
                    }
                    case FAILED_COMMENT: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__comments__", collection, oldDoc);
                        break;
                    }
                    case FAILED_TRACK: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__track__", collection, oldDoc);
                        break;
                    }
                    case FAILED_GENRE: {
                        this.cleanUpChanges(this.fds[i], "audios__audio__genre__", collection, oldDoc);
                    }
                }
                continue;
            }
            if (collection.writeMapToDisk()) continue;
            GUIMediator.safeInvokeAndWait(new Runnable(){

                public void run() {
                    GUIMediator.showError(I18n.tr("Internal Error. Data could not be saved."));
                }
            });
        }
    }

    private void showCommitError(LimeXMLReplyCollection.MetaDataState committed) {
        switch (committed) {
            case UNCHANGED: {
                GUIMediator.showMessage(I18n.tr("Nothing to save."));
                break;
            }
            case FILE_DEFECTIVE: {
                GUIMediator.showError(I18n.tr("File not found or corrupt file. Data could not be saved"));
                break;
            }
            case RW_ERROR: {
                GUIMediator.showError(I18n.tr("Read Write Error. Data could not be saved."));
                break;
            }
            case BAD_ID3: {
                GUIMediator.showError(I18n.tr("File Corrupt. Data could not be saved."));
                break;
            }
            case FAILED_TITLE: {
                GUIMediator.showError(I18n.tr("File Corrupt. Data could not be saved."));
                break;
            }
            case FAILED_ARTIST: 
            case FAILED_ALBUM: 
            case FAILED_YEAR: 
            case FAILED_COMMENT: 
            case FAILED_TRACK: 
            case FAILED_GENRE: {
                GUIMediator.showError(I18n.tr("Incorrect format entered. Changes will not be saved."));
                break;
            }
            case HASH_FAILED: {
                GUIMediator.showError(I18n.tr("Internal Error. Data could not be saved."));
            }
        }
    }

    private void cleanUpChanges(FileDesc fd, String canonicalFieldName, LimeXMLReplyCollection collection, LimeXMLDocument oldDoc) {
        if (oldDoc == null) {
            collection.removeDoc(fd);
        } else {
            collection.replaceDoc(fd, oldDoc);
        }
    }

    private void removeMeta(FileDesc[] fds, LimeXMLSchema schema) {
        String uri = schema.getSchemaURI();
        LimeXMLReplyCollection collection = GuiCoreMediator.getSchemaReplyCollectionMapper().getReplyCollection(uri);
        assert (collection != null) : "Trying to remove data from a non-existent collection";
        for (int i = 0; i < fds.length; ++i) {
            if (collection.removeDoc(fds[i])) continue;
            GUIMediator.showError(I18n.tr("Unable to remove data."));
        }
    }
}

