/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.xml.editor.MetaDataSaver;
import com.limegroup.gnutella.gui.xml.editor.MetaEditorTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.application.ApplicationTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.audio.AudioTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.document.DocumentTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.image.ImageTabbedPane;
import com.limegroup.gnutella.gui.xml.editor.video.VideoTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.limewire.util.OSUtils;

public class MetaEditor
extends JDialog {
    protected final FileDesc[] fds;
    private final String fileName;
    private JButton cancelButton;
    protected JButton okButton;
    protected MetaEditorTabbedPane tabbedPane;
    protected JPanel southPanel;

    public MetaEditor(Frame parent, FileDesc[] fds, String fileName) {
        super(parent, true);
        this.fds = fds;
        this.fileName = fileName;
        this.initComponents();
        if (OSUtils.isAnyMac()) {
            this.tabbedPane.setFocusable(false);
        }
        this.setTitle(fds[0].getFile().getName());
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.updateUI();
        this.cancelButton.updateUI();
        this.setDefaultCloseOperation(2);
        GUIUtils.addHideAction((JComponent)this.getContentPane());
        this.pack();
    }

    private void initComponents() {
        this.initCenterPanel();
        this.initSouthPanel();
        this.setLocationRelativeTo(this);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MetaEditor.this.disposeWindow();
            }
        });
        this.pack();
    }

    protected void initCenterPanel() {
        this.tabbedPane = this.createTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    protected MetaEditorTabbedPane createTabbedPane() {
        MetaEditorTabbedPane tabbedPane = null;
        if (MediaType.getAudioMediaType().matches(this.fileName)) {
            tabbedPane = new AudioTabbedPane(this.fds);
        } else if (MediaType.getVideoMediaType().matches(this.fileName)) {
            tabbedPane = new VideoTabbedPane(this.fds);
        } else if (MediaType.getProgramMediaType().matches(this.fileName)) {
            tabbedPane = new ApplicationTabbedPane(this.fds);
        } else if (MediaType.getImageMediaType().matches(this.fileName)) {
            tabbedPane = new ImageTabbedPane(this.fds);
        } else if (MediaType.getDocumentMediaType().matches(this.fileName)) {
            tabbedPane = new DocumentTabbedPane(this.fds);
        }
        return tabbedPane;
    }

    protected void initSouthPanel() {
        JButton secondBtn;
        JButton firstBtn;
        this.southPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        this.cancelButton = new JButton();
        this.cancelButton.setText(I18n.tr("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.disposeWindow();
            }
        });
        this.okButton = new JButton();
        this.okButton.setText(I18n.tr("OK"));
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MetaEditor.this.saveAndDisposeWindow();
            }
        });
        if (OSUtils.isAnyMac()) {
            firstBtn = this.cancelButton;
            secondBtn = this.okButton;
        } else {
            firstBtn = this.okButton;
            secondBtn = this.cancelButton;
        }
        buttonPanel.add(firstBtn);
        buttonPanel.add(secondBtn);
        this.southPanel.add((Component)buttonPanel, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
    }

    protected void disposeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    protected void saveAndDisposeWindow() {
        if (this.tabbedPane.hasDataChanged()) {
            MetaDataSaver saver = new MetaDataSaver(this.tabbedPane.getFileDesc(), this.tabbedPane.getSchema(), this.tabbedPane.getInput());
            saver.saveMetaData();
        }
        this.disposeWindow();
    }
}

